/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.finance.bean.ReceiveEntity;
import com.ejianc.business.finance.bean.ReceiveInvoiceEntity;
import com.ejianc.business.finance.service.IReceiveInvoiceService;
import com.ejianc.business.finance.service.IReceiveService;
import com.ejianc.business.finance.vo.ReceiveVO;
import com.ejianc.business.tax.bean.InvoiceOpenRegistEntity;
import com.ejianc.business.tax.service.IInvoiceOpenRegistService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/receive"})
public class ReceiveController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IReceiveService receiveService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IReceiveInvoiceService receiveInvoiceService;
    @Autowired
    private IInvoiceOpenRegistService invoiceOpenRegistService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ReceiveVO> saveOrUpdate(@RequestBody ReceiveVO receiveVO) {
        ReceiveVO backVO = this.receiveService.insertOrUpdate(receiveVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)backVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ReceiveVO> queryDetail(Long id) {
        ReceiveVO backVO = this.receiveService.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)backVO);
    }

    @RequestMapping(value={"/queryPrint"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryPrint(Long id) {
        JSONObject json = new JSONObject();
        json.put("Receive", (Object)this.receiveService.queryDetail(id));
        return CommonResponse.success((String)"\u67e5\u8be2\u6253\u5370\u6570\u636e\u6210\u529f\uff01", (Object)json);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        JSONObject page = this.receiveService.queryPageJson(param, false);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ReceiveVO> vos) {
        List<Long> ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        String msg = this.receiveService.delete(ids);
        return CommonResponse.success((String)msg);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        List<ReceiveVO> supplierVos = this.receiveService.queryExportList(queryParam);
        HashMap<String, List<ReceiveVO>> beans = new HashMap<String, List<ReceiveVO>>();
        beans.put("records", supplierVos);
        String excelName = ((Parameter)queryParam.getParams().get("projectType")).getValue().toString().equals("1") ? "receive-export.xlsx" : "receivegs-export.xlsx";
        ExcelExport.getInstance().export(excelName, beans, response);
    }

    @RequestMapping(value={"/queryInfoContractId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ReceiveVO> queryInfoContractId(Long contractId) {
        ReceiveVO receiveVO = this.receiveService.queryInfoContractId(contractId);
        return CommonResponse.success((String)"\u67e5\u8be2\u6253\u5370\u6570\u636e\u6210\u529f\uff01", (Object)receiveVO);
    }

    @RequestMapping(value={"/queryTotalReceiveMny"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<ReceiveVO>> queryTotalReceiveMny(@RequestParam(value="quoteIds") List<Long> quoteIds) {
        List<ReceiveVO> vos = this.receiveService.queryTotalReceiveMny(quoteIds);
        return CommonResponse.success((String)"\u67e5\u8be2\u6253\u5370\u6570\u636e\u6210\u529f\uff01", vos);
    }

    @RequestMapping(value={"/queryInfoProjectId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ReceiveVO> queryInfoProjectId(Long projectId) {
        ReceiveVO receiveVO = this.receiveService.queryInfoProjectId(projectId);
        if (null == receiveVO) {
            receiveVO = new ReceiveVO();
            receiveVO.setSumCollectMny(BigDecimal.ZERO);
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.in(InvoiceOpenRegistEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        lambdaQueryWrapper.eq(InvoiceOpenRegistEntity::getProjectId, (Object)projectId);
        List list = this.invoiceOpenRegistService.list((Wrapper)lambdaQueryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            BigDecimal sumInvoicingMny = list.stream().filter(item -> null != item.getOpenMny()).map(InvoiceOpenRegistEntity::getOpenMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            receiveVO.setSumInvoicingMny(sumInvoicingMny);
        } else {
            receiveVO.setSumInvoicingMny(BigDecimal.ZERO);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6253\u5370\u6570\u636e\u6210\u529f\uff01", (Object)receiveVO);
    }

    @RequestMapping(value={"/queryInfoOrgId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ReceiveVO> queryIznfoOrgId(Long orgId) {
        ReceiveVO receiveVO = new ReceiveVO();
        List list = this.receiveService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"org_id", (Object)orgId)).eq((Object)"project_type", (Object)2)).in((Object)"bill_state", Arrays.asList(1, 3)));
        if (CollectionUtils.isNotEmpty((Collection)list) && list.size() > 0) {
            receiveVO.setSumCollectMny(list.stream().filter(item -> null != item.getReceiveMny()).map(ReceiveEntity::getReceiveMny).reduce(BigDecimal.ZERO, BigDecimal::add));
        } else {
            receiveVO.setSumCollectMny(BigDecimal.ZERO);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u7d2f\u8ba1\u6536\u6b3e\u6210\u529f\uff01", (Object)receiveVO);
    }

    @RequestMapping(value={"/queryfpProjectId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<ReceiveVO>> queryfpProjectId(@RequestParam(value="openRegistIds") List<Long> openRegistIds) {
        ArrayList resList = new ArrayList();
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.in(BaseEntity::getId, openRegistIds);
        List list = this.invoiceOpenRegistService.list((Wrapper)lambdaQueryWrapper);
        LambdaQueryWrapper lambdaQueryWrapper2 = new LambdaQueryWrapper();
        lambdaQueryWrapper2.in(ReceiveInvoiceEntity::getInvoiceId, openRegistIds);
        List list2 = this.receiveInvoiceService.list((Wrapper)lambdaQueryWrapper2);
        Map<Long, BigDecimal> map1 = list2.stream().filter(item -> null != item.getCurrentInvoiceTaxMny()).collect(Collectors.groupingBy(ReceiveInvoiceEntity::getInvoiceId, Collectors.mapping(ReceiveInvoiceEntity::getCurrentInvoiceTaxMny, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
        list.forEach(e -> {
            ReceiveVO receiveVO = new ReceiveVO();
            receiveVO.setId(e.getId());
            BigDecimal currentInvoiceTaxMny = BigDecimal.ZERO;
            if (map1.containsKey(e.getId())) {
                currentInvoiceTaxMny = (BigDecimal)map1.get(e.getId());
            }
            receiveVO.setInvoiceMny(ComputeUtil.safeSub((BigDecimal)e.getOpenMny(), (BigDecimal)currentInvoiceTaxMny));
            resList.add(receiveVO);
        });
        return CommonResponse.success((String)"\u67e5\u8be2\u6253\u5370\u6570\u636e\u6210\u529f\uff01", resList);
    }

    @RequestMapping(value={"/queryReceiveByProjectBillId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryReceiveByProjectBillId(@RequestParam Long projectBillId) {
        JSONObject returnObject = new JSONObject();
        List detailList = this.receiveService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"project_bill_id", (Object)projectBillId)).in((Object)"receive_kind", Arrays.asList(1850783141581557761L, 1850783094378860546L)));
        returnObject.put("detailList", (Object)detailList);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)returnObject);
    }
}

