package com.ejianc.business.invest.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.finance.utils.BigDecimalUtil;
import com.ejianc.business.invest.bean.PersonDebtEntity;
import com.ejianc.business.invest.service.IPersonDebtService;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.invest.bean.PersonRepaymentEntity;
import com.ejianc.business.invest.service.IPersonRepaymentService;
import com.ejianc.business.invest.vo.PersonRepaymentVO;

/**
 * 项目投资-个人还款
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("personRepayment")
public class PersonRepaymentController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "BFYJ_XMTZ_GRHK";//此处需要根据实际修改

    @Autowired
    private IPersonRepaymentService service;
    @Autowired
    private IPersonDebtService debtService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PersonRepaymentVO> saveOrUpdate(@RequestBody PersonRepaymentVO saveOrUpdateVO) {
    	PersonRepaymentEntity entity = BeanMapper.map(saveOrUpdateVO, PersonRepaymentEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	PersonRepaymentVO vo = BeanMapper.map(entity, PersonRepaymentVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PersonRepaymentVO> queryDetail(Long id) {
    	PersonRepaymentEntity entity = service.selectById(id);
    	PersonRepaymentVO vo = BeanMapper.map(entity, PersonRepaymentVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PersonRepaymentVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (PersonRepaymentVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(PersonRepaymentVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PersonRepaymentVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("debtPersonName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));


        IPage<PersonRepaymentEntity> page = service.queryPage(param,false);
        IPage<PersonRepaymentVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), PersonRepaymentVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("debtPersonName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<PersonRepaymentEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<PersonRepaymentVO> voList = BeanMapper.mapList(list, PersonRepaymentVO.class);
        voList.forEach(e -> {
            e.setBillStateName(BillStateEnum.getEnumByStateCode(e.getBillState()).getDescription());
        });
        beans.put("records", voList);
        ExcelExport.getInstance().export("PersonRepayment-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refPersonRepaymentData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PersonRepaymentVO>> refPersonRepaymentData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<PersonRepaymentEntity> page = service.queryPage(param,false);
        IPage<PersonRepaymentVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PersonRepaymentVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }


     /**
     * @Description 根据身份证号查询借款单信息
     * @param
     * @Return void
     */
    @RequestMapping(value = "/queryPersonDebtRepayment", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PersonRepaymentVO> queryPersonDebtRepayment(String idCard, Long personDebtId, String checkType) {
        if (StringUtils.isNotBlank(checkType) && "personDebt".equals(checkType)){
            QueryWrapper<PersonDebtEntity> personDebtEntityQueryWrapper = new QueryWrapper<PersonDebtEntity>();
            personDebtEntityQueryWrapper.eq("id_card", idCard);
            personDebtEntityQueryWrapper.notIn("bill_state", Arrays.asList(1, 3));
            if (null != personDebtId ){
                personDebtEntityQueryWrapper.ne("id", personDebtId);
            }
            List<PersonDebtEntity> personDebtEntityList = debtService.list(personDebtEntityQueryWrapper);
            if (CollectionUtils.isNotEmpty(personDebtEntityList) && personDebtEntityList.size() > 0){
                throw new BusinessException("当前身份证人员存在未生效的借款单！");
            }
        }else {
            List<PersonRepaymentEntity> repaymentEntityList = service.list(new QueryWrapper<PersonRepaymentEntity>().eq("person_debt_id", personDebtId).notIn("bill_state", Arrays.asList(1, 3)));
            if (CollectionUtils.isNotEmpty(repaymentEntityList) && repaymentEntityList.size() > 0){
                return CommonResponse.error("当前借款单有未生效的还款单！", new PersonRepaymentVO());
            }
        }

        PersonRepaymentVO personRepaymentVO = service.queryPersonDebtRepayment(idCard);
        PersonDebtEntity personDebtEntity = debtService.selectById(personDebtId);
        if (null != personDebtEntity){
            personRepaymentVO.setBillDebtMny(personDebtEntity.getDebtMny());
        }
        List<PersonRepaymentEntity> entityList = service.list(new QueryWrapper<PersonRepaymentEntity>().eq("id_card", idCard).in("bill_state", Arrays.asList(1, 3)).orderByDesc("handle_date"));
        if (CollectionUtils.isNotEmpty(entityList) && entityList.size() > 0){
            BigDecimal billLastRepaymentMny = entityList.stream().filter(e -> personDebtId.equals(e.getPersonDebtId()) && e.getRepaymentCapitalMny() != null).map(PersonRepaymentEntity::getRepaymentCapitalMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            personRepaymentVO.setBillLastRepaymentMny(billLastRepaymentMny);
            personRepaymentVO.setBillRepaymentMny(billLastRepaymentMny);
            for (PersonRepaymentEntity personRepaymentEntity : entityList) {
                if (personDebtId.longValue() == personRepaymentEntity.getId().longValue()){
                    personRepaymentVO.setLastHandleDate(personRepaymentEntity.getHandleDate());
                    personRepaymentVO.setAllInterestMny(personRepaymentVO.getAllInterestMny());
                    personRepaymentVO.setLastAllInterestMny(personRepaymentVO.getAllInterestMny());
                    personRepaymentVO.setRemainInterestMny(personRepaymentVO.getRemainInterestMny());
                    break;
                }
            }
            personRepaymentVO.setBillDebtResidueMny(BigDecimalUtil.safeSub(personRepaymentVO.getBillDebtMny(), null == personRepaymentVO.getBillLastRepaymentMny() ? BigDecimal.ZERO : personRepaymentVO.getBillLastRepaymentMny()));

        }
        return CommonResponse.success("根据身份证号查询借款单信息数据成功！", personRepaymentVO);
     }
}
