/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bid.bean.BidPersonAffirmEntity;
import com.ejianc.business.bid.mapper.BidPersonAffirmMapper;
import com.ejianc.business.bid.service.IBidPersonAffirmService;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="bidPersonAffirmService")
public class BidPersonAffirmServiceImpl
extends BaseServiceImpl<BidPersonAffirmMapper, BidPersonAffirmEntity>
implements IBidPersonAffirmService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String PC_URL = "/ejc-bfyjerp-frontend/#/bidPersonAffirm/card?id=";
    @Autowired
    private IPushMessageApi pushMessageApi;

    @Override
    public List<BidPersonAffirmEntity> getByBusOpportunityId(Long id) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"opportunity_id", (Object)id);
        query.orderByDesc((Object)"create_time");
        return super.list((Wrapper)query);
    }

    @Override
    public String sendMsgToInstallPerson(BidPersonAffirmEntity entity) {
        this.logger.info("\u5f00\u59cb\u7ed9\u6807\u4e66\u5458\u3001\u9884\u7b97\u5458\u53d1\u9001\u6d88\u606f\uff1a----");
        String msg = this.sendMsg(entity, "\u6807\u4e66\u5458\u786e\u8ba4", entity.getEngineeringName() + "\uff0c\u9884\u7b97\u8d39\u7528\uff1a" + entity.getBudgetFee() + "\uff1a\u8bf7\u786e\u8ba4\uff01");
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            this.logger.error("\u5f00\u59cb\u7ed9\u6807\u4e66\u5458\u3001\u9884\u7b97\u5458\u53d1\u9001\u6d88\u606f\u5f02\u5e38\uff1a" + msg);
        }
        this.logger.info("\u5f00\u59cb\u7ed9\u6807\u4e66\u5458\u3001\u9884\u7b97\u5458\u53d1\u9001\u6d88\u606f\u7ed3\u675f\uff01");
        return msg;
    }

    private String sendMsg(BidPersonAffirmEntity entity, String subject, String content) {
        Object[] msgRecUserIds = new String[]{entity.getBidPersonId().toString(), entity.getBudgetPersonId().toString()};
        this.logger.info("\u6d88\u606f\u63a5\u6536\u4eba: {}", (Object)StringUtils.join((Object[])msgRecUserIds, (String)","));
        PushMsgParameter msgParameter = new PushMsgParameter();
        msgParameter.setReceivers((String[])msgRecUserIds);
        msgParameter.setContent(content);
        msgParameter.setSubject(content);
        msgParameter.setMsgType("notice");
        msgParameter.setTenantId(entity.getTenantId().toString());
        msgParameter.setSaveFlag(true);
        msgParameter.setSendUserId(InvocationInfoProxy.getUserid());
        msgParameter.setChannel(new String[]{"sys"});
        msgParameter.setPcUrl(PC_URL + entity.getId());
        CommonResponse msgSendResp = this.pushMessageApi.pushMessage(msgParameter);
        if (!msgSendResp.isSuccess()) {
            return msgSendResp.getMsg();
        }
        return null;
    }
}

