package com.ejianc.business.bid.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bid.bean.ProjectRegistrationAffirmEntity;
import com.ejianc.business.bid.service.IProjectRegistrationAffirmService;
import com.ejianc.business.bid.vo.ProjectRegistrationAffirmVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 投标管理-项目登记确认单
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("projectRegistrationAffirm")
public class ProjectRegistrationAffirmController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "PROJECT_REGISTRATION_AFFIRM";
    private static final String PROJECT_BILL_CODE = "BID_PROJECT_REGISTER";

    @Autowired
    private IProjectRegistrationAffirmService service;

    @Autowired
    private SessionManager sessionManager;

    @GetMapping(value = "getByBusOpportunityId")
    public CommonResponse<JSONObject> getByBusOpportunityId(@RequestParam Long id) {
        JSONObject resp = new JSONObject();
        List<ProjectRegistrationAffirmVO> dataList = new ArrayList<>();
        List<ProjectRegistrationAffirmEntity> list = service.getByBusOpportunityId(id);
        if(CollectionUtils.isNotEmpty(list)) {
            dataList = BeanMapper.mapList(list, ProjectRegistrationAffirmVO.class);
        }
        resp.put("detailList", dataList);
        return CommonResponse.success(resp);
    }

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    public CommonResponse<ProjectRegistrationAffirmVO> saveOrUpdate(@RequestBody ProjectRegistrationAffirmVO saveOrUpdateVO) {
    	ProjectRegistrationAffirmEntity entity = BeanMapper.map(saveOrUpdateVO, ProjectRegistrationAffirmEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }

            entity.setEmployeeId(Long.valueOf(InvocationInfoProxy.getEmployeeId()));
            entity.setEmployeeName(sessionManager.getUserContext().getEmployeeName());
        }

    	if(StringUtils.isBlank(entity.getEngineeringCode())) {
    	    //项目编码为空 自动生成新的
            BillCodeParam billCodeParam = BillCodeParam.build(PROJECT_BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setEngineeringCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

    	service.saveOrUpdate(entity, false);
    	ProjectRegistrationAffirmVO vo = BeanMapper.map(entity, ProjectRegistrationAffirmVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    public CommonResponse<ProjectRegistrationAffirmVO> queryDetail(Long id) {
    	ProjectRegistrationAffirmEntity entity = service.selectById(id);
    	ProjectRegistrationAffirmVO vo = BeanMapper.map(entity, ProjectRegistrationAffirmVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    public CommonResponse<String> delete(@RequestBody List<ProjectRegistrationAffirmVO> vos) {
        service.removeByIds(vos.stream().map(ProjectRegistrationAffirmVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    public CommonResponse<IPage<ProjectRegistrationAffirmVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("engineeringCode");
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("collectionTypeName");
        fuzzyFields.add("collectionStandardName");
        fuzzyFields.add("managementFeeCollectionType");
        fuzzyFields.add("otherFee");
        fuzzyFields.add("accountName");
        fuzzyFields.add("account");
        fuzzyFields.add("openAccountBankName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<ProjectRegistrationAffirmEntity> page = service.queryPage(param,false);
        IPage<ProjectRegistrationAffirmVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProjectRegistrationAffirmVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("engineeringCode");
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("collectionTypeName");
        fuzzyFields.add("collectionStandardName");
        fuzzyFields.add("managementFeeCollectionType");
        fuzzyFields.add("otherFee");
        fuzzyFields.add("accountName");
        fuzzyFields.add("account");
        fuzzyFields.add("openAccountBankName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<ProjectRegistrationAffirmEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ProjectRegistrationAffirm-export.xlsx", beans, response);
    }

    /**
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/refProjectRegistrationAffirmData", method = RequestMethod.GET)
    public CommonResponse<IPage<ProjectRegistrationAffirmVO>> refProjectRegistrationAffirmData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("engineeringCode");
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("collectionTypeName");
        fuzzyFields.add("collectionStandardName");
        fuzzyFields.add("managementFeeCollectionType");
        fuzzyFields.add("otherFee");
        fuzzyFields.add("accountName");
        fuzzyFields.add("account");
        fuzzyFields.add("openAccountBankName");
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ProjectRegistrationAffirmEntity> page = service.queryPage(param,false);
        IPage<ProjectRegistrationAffirmVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProjectRegistrationAffirmVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
