package com.ejianc.business.finance.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 出纳资金-出纳日报表-主表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_finance_daypay")
public class DaypayEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="date")
    private Date date; // 日期
    @TableField(value="start_mny")
    private BigDecimal startMny; // 期初金额
    @TableField(value="end_mny")
    private BigDecimal endMny; // 结余金额
    @TableField(exist=false)
    @SubEntity(serviceName="daypayDetailService",pidName = "mid")
    private List<DaypayDetailEntity> daypayDetailList = new ArrayList<>(); // 出纳资金-占用资金表-子表


    public List<DaypayDetailEntity> getDaypayDetailList() {
        return daypayDetailList;
    }

    public void setDaypayDetailList(List<DaypayDetailEntity> daypayDetailList) {
        this.daypayDetailList = daypayDetailList;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getDate() {
        return date;
    }

    public void setDate(Date date) {
        this.date = date;
    }
    public BigDecimal getStartMny() {
        return startMny;
    }

    public void setStartMny(BigDecimal startMny) {
        this.startMny = startMny;
    }
    public BigDecimal getEndMny() {
        return endMny;
    }

    public void setEndMny(BigDecimal endMny) {
        this.endMny = endMny;
    }
    
}
