package com.ejianc.business.finance.utils;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

@Component
public class WarnFeignUtil {
    private final Logger logger = LoggerFactory.getLogger(getClass());

//    @Value("${weChat.cgdd-agentid}")
//    private String cgddAgentid;
//
//    @Value("${weChat.cgdd-secret}")
//    private String cgddSecret;
    @Autowired
    private IPushMessageApi pushMessageApi;



    public void sendMsg(List<String> messageType, List<String> user, String msgType, String subject, String content, String mobileUrl) {
        this.sendMsg(messageType, user, msgType, subject, content, mobileUrl, null);
    }

    public void sendMsg(List<String> messageType, List<String> user, String msgType, String subject, String content, String mobileUrl, String formurl) {
        logger.info("发送消息开始！===========");
        PushMsgParameter parameter = new PushMsgParameter();
        List<String> channel = new ArrayList<>();
        if (messageType.contains("sys")) {
            // 系统消息
            channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);
        }
        if (messageType.contains("smsg")) {
            // 短信消息
            // channel.add(PushMsgParameter.CHANNEL_TYPE_NOTE);
        }
//        if (messageType.contains("weChat")) {
//            // 系统消息
//            channel.add(PushMsgParameter.CHANNEL_TYPE_WEXINEE);
//        }
        if (messageType.contains("dingding")) {
            // 钉钉消息
            channel.add(PushMsgParameter.CHANNEL_TYPE_DINGDING);
        }
        Collections.replaceAll(user, "1247777316689256450", "303581417601122400");// 系统管理员特殊处理
        String[] receivers = user.toArray(new String[user.size()]);
        parameter.setReceivers(receivers);// 收信人
        parameter.setChannel(channel.toArray(new String[channel.size()]));// 消息类型
        parameter.setMsgType(msgType);
        parameter.setSubject(subject);// 标题
        parameter.setContent(content);// 内容
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
//        if (messageType.contains("weChat")) {
//            JSONObject weixineeParams = new JSONObject();
//            weixineeParams.put("agentid", cgddAgentid);
//            weixineeParams.put("secret", cgddSecret);
////            weixineeParams.put("content", subject);
//            weixineeParams.put("msgtype", "textcard");
//            weixineeParams.put("title", "消息提醒");
//            weixineeParams.put("description", subject);
//            weixineeParams.put("url", mobileUrl);
//            weixineeParams.put("btntxt", "点击查看");
//
//            parameter.setWeixineeParams(weixineeParams);
//        }
        if (messageType.contains("dingding")) {
            JSONObject dingdingParams = new JSONObject();
            dingdingParams.put("title", subject);
            String ddcontent = subject + (",通知时间:"+new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            dingdingParams.put("content", ddcontent);
            dingdingParams.put("maurl", mobileUrl);
            dingdingParams.put("pcurl", formurl);
            parameter.setDingdingParams(dingdingParams);
        }
        try {
            logger.info("发送信息{}", JSONObject.toJSONString(parameter));
            CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
            if (result.isSuccess()) {
                logger.error("消息发送成功---------------->" + result.getMsg());
            } else {
                logger.error("消息发送失败---------------->" + result.getMsg());
            }
        } catch (Exception e) {
            logger.error("调用消息中心RPC服务异常--------------" + e);
        }
    }
}
