package com.ejianc.business.oa.service.impl;

import com.ejianc.business.oa.bean.InstoreDetailEntity;
import com.ejianc.business.oa.bean.OutstoreDetailEntity;
import com.ejianc.business.oa.service.IInstoreDetailService;
import com.ejianc.business.oa.service.IOutstoreDetailService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.oa.mapper.InstoreMapper;
import com.ejianc.business.oa.bean.InstoreEntity;
import com.ejianc.business.oa.service.IInstoreService;

import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;

/**
 * 人力行政-资产入库单
 * 
 * @author generator
 * 
 */
@Service("instoreService")
public class InstoreServiceImpl extends BaseServiceImpl<InstoreMapper, InstoreEntity> implements IInstoreService{

    @Autowired
    private IInstoreDetailService instoreDetailService;
    @Autowired
    private IOutstoreDetailService outstoreDetailService;

    @Override
    public BigDecimal calculateCanUseNum(Long inStoreSubId, Long materialId, Long outSubId) {
        InstoreDetailEntity inEntity = instoreDetailService.selectById(inStoreSubId);
        if(inEntity == null ){
            throw new BusinessException("没有找到该物资入库记录！");
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("sourceSubId",new Parameter(QueryParam.EQ,inStoreSubId));
        List<OutstoreDetailEntity> subs = outstoreDetailService.queryList(queryParam,false);

        BigDecimal canUseNum = inEntity.getInstoreNumber();
        BigDecimal cannotUseNum = BigDecimal.ZERO;
        if(!ListUtil.isEmpty(subs)){
            for (OutstoreDetailEntity s: subs) {
                if(outSubId ==null || !Objects.equals(outSubId,s.getId())){
                    cannotUseNum = ComputeUtil.safeAdd(cannotUseNum,s.getOutStoreNumber());
                }
            }
        }
        canUseNum = ComputeUtil.safeSub(canUseNum,cannotUseNum);
        return canUseNum ;
    }
}
