package com.ejianc.business.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.bid.vo.BusOpportunityVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.bid.mapper.BusOpportunityMapper;
import com.ejianc.business.bid.bean.BusOpportunityEntity;
import com.ejianc.business.bid.service.IBusOpportunityService;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 投标管理-商机登记实体
 * 
 * @author generator
 * 
 */
@Service("busOpportunityService")
public class BusOpportunityServiceImpl extends BaseServiceImpl<BusOpportunityMapper, BusOpportunityEntity> implements IBusOpportunityService{

    @Override
    public List<BusOpportunityEntity> getAllByRegistrationId(Long registrationId, Long id) {
        QueryWrapper<BusOpportunityEntity> query = new QueryWrapper<>();
        query.eq("dr", BaseVO.DR_UNDELETE);
        if(null != registrationId) {
            query.eq("registration_id", registrationId);
        }
        if(null != id) {
            query.ne("id", id);
        }
        return super.list(query);
    }

    @Override
    public List<BusOpportunityVO> getAllUnQuoteBill() {
        List<BusOpportunityVO> resp = new ArrayList<>();
        QueryWrapper<BusOpportunityEntity> query = new QueryWrapper<>();
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.in("bill_state", new Integer[]{
                BillStateEnum.PASSED_STATE.getBillStateCode(),
                BillStateEnum.COMMITED_STATE.getBillStateCode()
        });
        query.ne("report_quote_flag", "1");

        List<BusOpportunityEntity> dbList = super.list(query);
        if(CollectionUtils.isNotEmpty(dbList)) {
            resp = BeanMapper.mapList(dbList, BusOpportunityVO.class);
        }

        return resp;
    }

    @Override
    public void updateQuoteFlag(List<Long> updateOpprIds, String quoteFlag) {
        UpdateWrapper<BusOpportunityEntity> update = new UpdateWrapper<>();
        update.in("id", updateOpprIds);
        update.set("report_quote_flag", quoteFlag);
        update.set("update_time", new Date());
        update.set("update_user_code", InvocationInfoProxy.getUsercode());

        super.update(update);
    }
}
