package com.ejianc.business.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bid.vo.ProjectPersonAffirmVO;
import com.ejianc.business.finance.utils.WarnFeignUtil;
import com.ejianc.business.oa.bean.CarEntity;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.bid.mapper.ProjectPersonAffirmMapper;
import com.ejianc.business.bid.bean.ProjectPersonAffirmEntity;
import com.ejianc.business.bid.service.IProjectPersonAffirmService;

import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

/**
 * 投标管理-确认项目经理及技术负责人
 * 
 * @author generator
 * 
 */
@Service("projectPersonAffirmService")
public class ProjectPersonAffirmServiceImpl extends BaseServiceImpl<ProjectPersonAffirmMapper, ProjectPersonAffirmEntity> implements IProjectPersonAffirmService{

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private WarnFeignUtil feignUtil;


    @Value("${common.env.base-host}")
    private String baseHost;

    private static final String BILL_CODE = "BID_PROJECT_PERSON_AFFIRM";
    @Override
    public List<ProjectPersonAffirmEntity> getByBusOpportunityId(Long id) {
        QueryWrapper<ProjectPersonAffirmEntity> query = new QueryWrapper<>();
        query.eq("opportunity_id", id);
        query.orderByDesc("create_time");
        return super.list(query);
    }

    @Override
    public ProjectPersonAffirmVO saveOrUpdate(ProjectPersonAffirmVO saveOrUpdateVO) {
        ProjectPersonAffirmEntity entity = BeanMapper.map(saveOrUpdateVO, ProjectPersonAffirmEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setEmployeeId(Long.valueOf(InvocationInfoProxy.getEmployeeId()));
            entity.setEmployeeName(sessionManager.getUserContext().getEmployeeName());
        }
        ProjectPersonAffirmVO vo = BeanMapper.map(entity, ProjectPersonAffirmVO.class);

        String pusherId = vo.getPusherId();
        List<String> pusherIds = new ArrayList<>();
        if (StringUtils.isNotBlank(pusherId)){
            String[] split = pusherId.split(",");
            pusherIds = Arrays.asList(split);
        }

        //发送消息
        List<String> messageType = new ArrayList<>();
        messageType.add("sys");
        String formurl = baseHost + "ejc-bfyjerp-frontend/#/projectPersonAffirm";
        if (CollectionUtils.isNotEmpty(pusherIds)){
            StringBuffer buffer = new StringBuffer();
            buffer.append(vo.getEngineeringName() +"项目,"+"项目经理及技术负责人已做调整，请查看");
            String subject = buffer.toString();
            String content = subject + "<a href=" + '"' + formurl + '"' + ">前往点击</a>";
            feignUtil.sendMsg(messageType, pusherIds, "notice", subject, content, null);
        }

        return vo;
    }
}
