package com.ejianc.business.oa.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 人力行政-员工离职审批表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_oa_employee_remove")
public class EmployeeRemoveEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 编号
    @TableField(value="employee_id")
    private Long employeeId; // 员工名称
    @TableField(value="name")
    private String name; // 员工名称
    @TableField(value="org_id")
    private Long orgId; // 区域ID
    @TableField(value="org_name")
    private String orgName; // 区域
    @TableField(value="dept_id")
    private Long deptId; // 部门ID
    @TableField(value="dept_name")
    private String deptName; // 部门
    @TableField(value="post_id")
    private Long postId; // 岗位ID
    @TableField(value="post_name")
    private String postName; // 岗位
    @TableField(value="into_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date intoDate; // 入职日期
    @TableField(value="remove_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date removeDate; // 实际离职日期
    @TableField(value="salary_end_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date salaryEndDate; // 薪资核算截止日
    @TableField(value="insured_flag")
    private Integer insuredFlag; // 是否缴纳保险
    @TableField(value="insured_flag_name")
    private String insuredFlagName; // 是否缴纳保险
    @TableField(value="insured_end_date")
    @JsonFormat(pattern = "yyyy-MM", timezone = "GMT+8")
    private Date insuredEndDate; // 保险最后缴纳月份
    @TableField(value="memo")
    private String memo; // 离职原因
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    
    
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    public Long getPostId() {
        return postId;
    }

    public void setPostId(Long postId) {
        this.postId = postId;
    }
    public String getPostName() {
        return postName;
    }

    public void setPostName(String postName) {
        this.postName = postName;
    }
    public Date getIntoDate() {
        return intoDate;
    }

    public void setIntoDate(Date intoDate) {
        this.intoDate = intoDate;
    }
    public Date getRemoveDate() {
        return removeDate;
    }

    public void setRemoveDate(Date removeDate) {
        this.removeDate = removeDate;
    }
    public Date getSalaryEndDate() {
        return salaryEndDate;
    }

    public void setSalaryEndDate(Date salaryEndDate) {
        this.salaryEndDate = salaryEndDate;
    }
    public Integer getInsuredFlag() {
        return insuredFlag;
    }

    public void setInsuredFlag(Integer insuredFlag) {
        this.insuredFlag = insuredFlag;
    }
    public String getInsuredFlagName() {
        return insuredFlagName;
    }

    public void setInsuredFlagName(String insuredFlagName) {
        this.insuredFlagName = insuredFlagName;
    }
    public Date getInsuredEndDate() {
        return insuredEndDate;
    }

    public void setInsuredEndDate(Date insuredEndDate) {
        this.insuredEndDate = insuredEndDate;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    
}
