package com.ejianc.business.scene.service;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.scene.utils.NoticeEnum;
import com.ejianc.business.scene.vo.CheckBfyjVO;
import com.ejianc.business.scene.vo.CheckDetailBfyjVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

/**
 * @author songlx
 * @version 1.0
 * @description: 微信公众号消息通知
 * @date 2021/10/20
 */
@Service
public class CheckMessageService {

    private final Logger logger = LoggerFactory.getLogger(getClass());


    @Value("${common.env.base-host}")
    private String baseHost;

//    @Value("${weixin_template.check_id}")
//    private String weixinCheckTemplateId;

    @Autowired
    private IPushMessageApi pushMessageApi;


    public CommonResponse<String> sendMsg(CheckBfyjVO checkVO, String[] receivers, NoticeEnum notice) {
        if (checkVO != null) {

            logger.info("发送消息开始========= msgId = "+checkVO.getMsgId() + "，msgBillCode = "+checkVO.getMsgBillCode() + "，msgNum = "+checkVO.getMsgNum()+"========================");

            PushMsgParameter parameter = new PushMsgParameter();
            List<String> channel = new ArrayList<>();
            channel.add(PushMsgParameter.CHANNEL_TYPE_WEIXIN);
            channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);

            HashMap<String, String> keyMap = new HashMap<>();
            keyMap.put("#NUM#", checkVO.getMsgNum() != null ? String.valueOf(checkVO.getMsgNum()) : null);
            keyMap.put("#BILLCODE#", checkVO.getMsgBillCode());
            keyMap.put("#CHECKNAME#", checkVO.getCheckName());
            keyMap.put("#ID#", String.valueOf(checkVO.getMsgId()));
            keyMap.put("#BASEHOST#", baseHost);
//暂时不发送
//            if (StringUtils.isNotBlank(weixinCheckTemplateId)) {
//                // 微信公众号消息
//                JSONObject weixinParams = new JSONObject();
//                weixinParams.put("template_id", weixinCheckTemplateId);
//                JSONObject wxparams = new JSONObject();
//                wxparams.put("first", NoticeEnum.getMobileContent(notice, keyMap));
//                wxparams.put("keyword1", notice.getKey1());
//                wxparams.put("keyword2", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
//                weixinParams.put("data", wxparams);
//                logger.info("==============================微信公众号===================================================");
//                String mobileUrl = NoticeEnum.getMobileUrl(notice, keyMap) + "openid={openid}";
//                logger.info("mobileUrl = "+ mobileUrl);
//                weixinParams.put("url", mobileUrl);
//                parameter.setWeixinParams(weixinParams);
//            } else {
//                logger.info("未配置微信公众号模板，故不发微信公众号消息");
//            }

            parameter.setReceivers(receivers);// 收信人
            parameter.setChannel(channel.toArray(new String[channel.size()]));// 消息类型
            parameter.setMsgType("notice");

            String subjectExt = "【" + DateUtil.formatDate(checkVO.getCheckDate()) + " " + checkVO.getCheckName() + " (" + checkVO.getCheckTypeName() + ")】";
            parameter.setSubject(notice.getSubject() + subjectExt);// 标题
            logger.info("==============================系统消息===================================================");
            String sysContent = NoticeEnum.getPcContent(notice, keyMap);
            logger.info("sysContent = "+ sysContent);
            parameter.setContent(sysContent);// 内容
            parameter.setMobileUrl(NoticeEnum.getMobileUrl(notice, keyMap));
            parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
            parameter.setSendUserId(InvocationInfoProxy.getUserid());
            try {
                CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
                if (result.isSuccess()) {
                    logger.error("消息发送成功---------------->" + result.getMsg());
                } else {
                    logger.error("消息发送失败---------------->" + result.getMsg());
                }
            } catch (Exception e) {
                logger.error("调用消息中心RPC服务异常--------------" + e);
            }
        }
        return CommonResponse.success();
    }

    ;



}
