package com.ejianc.business.tax.controller;

import java.io.Serializable;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.contract.bean.ContractManageEntity;
import com.ejianc.business.finance.bean.PaySporadicEntity;
import com.ejianc.business.finance.service.IPaySporadicService;
import com.ejianc.business.tax.bean.InvoiceOpenRegistEntity;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.tax.bean.InvoiceReceivePoolEntity;
import com.ejianc.business.tax.bean.OuterCertEntity;
import com.ejianc.business.tax.service.IInvoiceReceivePoolService;
import com.ejianc.business.tax.vo.InvoiceOpenRegistVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.tax.bean.InvoiceReceiveRegistEntity;
import com.ejianc.business.tax.service.IInvoiceReceiveRegistService;
import com.ejianc.business.tax.vo.InvoiceReceiveRegistVO;

/**
 * 税务管理-收票登记
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("invoiceReceiveRegist")
public class InvoiceReceiveRegistController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IInvoiceReceiveRegistService service;
    @Autowired
    private IInvoiceReceivePoolService invoiceReceivePoolService;
    @Autowired
    private IPaySporadicService paySporadicService;


    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<InvoiceReceiveRegistVO> saveOrUpdate(@RequestBody InvoiceReceiveRegistVO saveOrUpdateVO) {
    	InvoiceReceiveRegistEntity entity = BeanMapper.map(saveOrUpdateVO, InvoiceReceiveRegistEntity.class);
        service.insertOrUpdate(entity);
    	InvoiceReceiveRegistVO vo = BeanMapper.map(entity, InvoiceReceiveRegistVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description 根据项目id查询金额
     * @param id
     */
    @RequestMapping(value = "/queryMnyByProjectAndSupplierId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InvoiceReceiveRegistVO> queryMnyByProjectAndSupplierId(Long projectId,Long supplierId) {
        LambdaQueryWrapper<PaySporadicEntity> lambdaWrapper = new LambdaQueryWrapper<>();
        lambdaWrapper.in(PaySporadicEntity::getBillState,1,3);
        lambdaWrapper.eq(PaySporadicEntity::getProjectId,projectId);
        lambdaWrapper.eq(PaySporadicEntity::getSupplyId,supplierId);
        List<PaySporadicEntity> daypayEntityList = paySporadicService.list(lambdaWrapper);
        InvoiceReceiveRegistVO invoiceOpenRegistVO = new InvoiceReceiveRegistVO();
        //累计开票金额
        if (CollectionUtils.isNotEmpty(daypayEntityList)){
            BigDecimal sumPayMny = daypayEntityList.stream().filter(s->s.getApplyMny() != null).map(PaySporadicEntity::getApplyMny)
                    .reduce(BigDecimal.ZERO, BigDecimal::add);
            invoiceOpenRegistVO.setSumPayMny(sumPayMny);
        }

        return CommonResponse.success("查询详情数据成功！",invoiceOpenRegistVO);
    }


    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InvoiceReceiveRegistVO> queryDetail(Long id) {
    	InvoiceReceiveRegistEntity entity = service.selectById(id);
    	InvoiceReceiveRegistVO vo = BeanMapper.map(entity, InvoiceReceiveRegistVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InvoiceReceiveRegistVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (InvoiceReceiveRegistVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(InvoiceReceiveRegistVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<InvoiceReceiveRegistVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("projectName","code"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));


        IPage<InvoiceReceiveRegistEntity> page = service.queryPage(param,false);
        IPage<InvoiceReceiveRegistVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), InvoiceReceiveRegistVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("projectName","code"));
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<InvoiceReceiveRegistEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        if ("1".equals(param.getParams().get("projectFlag").getValue().toString())){
            ExcelExport.getInstance().exportWithTrans("InvoiceReceiveRegist-export.xlsx", beans, response);
        }else {
            ExcelExport.getInstance().exportWithTrans("InvoiceReceiveRegistOrg-export.xlsx", beans, response);
        }
    }
    @RequestMapping(value = "/queryTotalReceiveMnyBySupplierId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BigDecimal> queryTotalReceiveMnyBySupplierId(@RequestParam(value = "supplierId",required = true) Long supplierId,@RequestParam(value = "id",required = false)Long id) {
        LambdaQueryWrapper<InvoiceReceiveRegistEntity> lambdaQueryWrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapper.eq(InvoiceReceiveRegistEntity::getSellerId,supplierId)
                .eq(InvoiceReceiveRegistEntity::getDr,0)
                .ne(id!=null,InvoiceReceiveRegistEntity::getId,id)
                .in(InvoiceReceiveRegistEntity::getBillState,1,3);
        List<InvoiceReceiveRegistEntity> list = service.list(lambdaQueryWrapper);
        BigDecimal sumMny = list.stream().map(InvoiceReceiveRegistEntity::getCurrentReceiveMnyTax).reduce(BigDecimal.ZERO, BigDecimal::add);
        return CommonResponse.success("查询详情数据成功！",sumMny);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refInvoiceReceiveRegistData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<InvoiceReceiveRegistVO>> refInvoiceReceiveRegistData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<InvoiceReceiveRegistEntity> page = service.queryPage(param,false);
        IPage<InvoiceReceiveRegistVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), InvoiceReceiveRegistVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }



    /**
     * @Description 根据项目id查询其他费用单据的数据
     * @param
     * @Return void
     */
    @RequestMapping(value = "/queryInvoiceReceiveRegisterByProjectBillId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryInvoiceReceiveRegisterByProjectBillId(@RequestParam Long projectBillId) {
        JSONObject returnObject = new JSONObject();
        List<InvoiceReceiveRegistEntity> invoiceReceiveRegisterIdList = service.list(new QueryWrapper<InvoiceReceiveRegistEntity>().eq("project_bill_id", projectBillId));

        if (CollectionUtils.isNotEmpty(invoiceReceiveRegisterIdList) && invoiceReceiveRegisterIdList.size() > 0){
            returnObject.put("detailList", invoiceReceiveRegisterIdList);
            //查对应的收票登记-子表
            List<InvoiceReceivePoolEntity> detailList = invoiceReceivePoolService.list(new QueryWrapper<InvoiceReceivePoolEntity>().in("receive_bill_id", invoiceReceiveRegisterIdList.stream().map(InvoiceReceiveRegistEntity::getId).collect(Collectors.toList())));

            //查到合格的发票
            List<InvoiceReceivePoolEntity> passList = detailList.stream().filter(p -> p.getPassFlag() != null && 1 == p.getPassFlag()).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(passList) && passList.size() > 0){

                //专票-自定义档案id：1853691016918339586
                returnObject.put("specialDetailList", passList.stream().filter(p -> p.getInvoiceType() != null && "1853691016918339586".equals(String.valueOf(p.getInvoiceType()))).collect(Collectors.toList()));
                //普票-自定义档案id：1853691041769590785
                returnObject.put("commonDetailList", passList.stream().filter(p -> p.getInvoiceType() != null && "1853691041769590785".equals(String.valueOf(p.getInvoiceType()))).collect(Collectors.toList()));
            }
        }
        return CommonResponse.success("查询列表数据成功！", returnObject);
    }
}
