package com.ejianc.business.bid.mapper;

import com.ejianc.business.bid.bean.AreaEntity;
import com.ejianc.business.bid.vo.AreaVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * @author CJ
 * @Description:
 * @date 2021/10/12 10:47
 */
@Mapper
public interface AreaMapper extends BaseCrudMapper<AreaEntity> {
    /**
     * 根据主键批量删除行政地区记录
     *
     * @param ids
     */
    void batchDelByIds(@Param(value = "ids") List<Long> ids);

    /**
     * 查询匹配的行政地区
     *
     * @param pid
     * @return
     */
    List<Map> queryAll(@Param(value = "pid") Long pid);

    /**
     * 查询匹配的地区列表
     *
     * @param pid
     * @param billCode
     * @param areaName
     * @param status
     * @return
     */
    List<AreaVO> queryList(@Param(value = "pid") Long pid, @Param(value = "billCode") String billCode, @Param(value = "areaName") String areaName, @Param(value = "status") Integer status);
}
