package com.ejianc.business.cost.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cost.bean.OtherFeeEntity;
import com.ejianc.business.cost.service.IOtherFeeService;
import com.ejianc.business.cost.vo.ProjectBillVO;
import com.ejianc.business.cost.vo.ProjectDetailBillVO;
import com.ejianc.business.cost.vo.ProjectReportVO;
import com.ejianc.business.finance.bean.PayMigrantEntity;
import com.ejianc.business.finance.bean.ReceiveEntity;
import com.ejianc.business.finance.service.IPayMigrantService;
import com.ejianc.business.finance.service.IReceiveService;
import com.ejianc.business.finance.utils.BigDecimalUtil;
import com.ejianc.business.project.bean.ProjectRegisterEntity;
import com.ejianc.business.project.service.IProjectRegisterService;
import com.ejianc.business.tax.bean.InvoiceOpenRegistEntity;
import com.ejianc.business.tax.bean.InvoiceReceivePoolEntity;
import com.ejianc.business.tax.bean.InvoiceReceiveRegistEntity;
import com.ejianc.business.tax.service.IInvoiceOpenRegistService;
import com.ejianc.business.tax.service.IInvoiceReceivePoolService;
import com.ejianc.business.tax.service.IInvoiceReceiveRegistService;
import com.ejianc.business.tax.vo.InvoiceReceivePoolVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.cost.mapper.ProjectBillMapper;
import com.ejianc.business.cost.bean.ProjectBillEntity;
import com.ejianc.business.cost.service.IProjectBillService;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 成本会计-项目对账单
 * 
 * @author generator
 * 
 */
@Service("projectBillService")
public class ProjectBillServiceImpl extends BaseServiceImpl<ProjectBillMapper, ProjectBillEntity> implements IProjectBillService{

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOtherFeeService otherFeeService;
    @Autowired
    private IInvoiceReceiveRegistService invoiceReceiveRegistService;
    @Autowired
    private IInvoiceReceivePoolService invoiceReceivePoolService;
    @Autowired
    private IReceiveService receiveService;
    @Autowired
    private IPayMigrantService payMigrantService;
    @Autowired
    private IInvoiceOpenRegistService invoiceOpenRegistService;
    @Autowired
    private IProjectRegisterService projectRegisterService;


    private static final String BILL_CODE = "BFYJ_CBKJ_QTFY";//此处需要根据实际修改

    @Override
    public ProjectBillVO insertOrUpdate(ProjectBillVO saveOrUpdateVO) {
        ProjectBillEntity entity = BeanMapper.map(saveOrUpdateVO, ProjectBillEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setId(IdWorker.getId());



            //绑定收票登记
            if (CollectionUtils.isNotEmpty(saveOrUpdateVO.getInvoiceReceiveRegisterIdList()) && saveOrUpdateVO.getInvoiceReceiveRegisterIdList().size() > 0){
                invoiceReceiveRegistService.update(new UpdateWrapper<InvoiceReceiveRegistEntity>().in("id", saveOrUpdateVO.getInvoiceReceiveRegisterIdList()).set("project_bill_id", entity.getId()));
            }
            if (CollectionUtils.isNotEmpty(saveOrUpdateVO.getInvoiceReceivePoolIdList()) && saveOrUpdateVO.getInvoiceReceivePoolIdList().size() > 0){
                invoiceReceivePoolService.update(new UpdateWrapper<InvoiceReceivePoolEntity>().in("id", saveOrUpdateVO.getInvoiceReceivePoolIdList()).set("project_bill_id", entity.getId()));
            }
            //绑定开票登记
            if (CollectionUtils.isNotEmpty(saveOrUpdateVO.getInvoiceOpenRegistIdList()) && saveOrUpdateVO.getInvoiceOpenRegistIdList().size() > 0){
                invoiceOpenRegistService.update(new UpdateWrapper<InvoiceOpenRegistEntity>().in("id", saveOrUpdateVO.getInvoiceOpenRegistIdList()).set("project_bill_id", entity.getId()));
            }
            //绑定收款登记
            if (CollectionUtils.isNotEmpty(saveOrUpdateVO.getReceiveIdList()) && saveOrUpdateVO.getReceiveIdList().size() > 0){
                receiveService.update(new UpdateWrapper<ReceiveEntity>().in("id", saveOrUpdateVO.getReceiveIdList()).set("project_bill_id", entity.getId()));
            }
            //绑定民工工资收款
            if (CollectionUtils.isNotEmpty(saveOrUpdateVO.getPayMigrantIdList()) && saveOrUpdateVO.getPayMigrantIdList().size() > 0){
                payMigrantService.update(new UpdateWrapper<PayMigrantEntity>().in("id", saveOrUpdateVO.getPayMigrantIdList()).set("project_bill_id", entity.getId()));
            }
            //绑定其他费用单
            if (CollectionUtils.isNotEmpty(saveOrUpdateVO.getOtherFeeIdList()) && saveOrUpdateVO.getOtherFeeIdList().size() > 0){
                otherFeeService.update(new UpdateWrapper<OtherFeeEntity>().in("id", saveOrUpdateVO.getOtherFeeIdList()).set("project_bill_id", entity.getId()));
            }
        }
        super.saveOrUpdate(entity, false);
        ProjectBillVO vo = BeanMapper.map(super.selectById(entity.getId()), ProjectBillVO.class);
        return vo;
    }

    @Override
    public ProjectBillVO queryProjectBillDataByProjectId(String projectId, List<ProjectBillEntity> oldProjectBillEntityList) {
        ProjectBillVO projectBillVO = new ProjectBillVO();
        //1、占用收票
        //标记合格的收票登记，且未被项目对账单引用过得
//        todo：查询 合格的收票登记
        // 统计业务类型为 项目异地预缴 的收票登记 智取一个值 异地预缴税额
//        .eq("receive_type", 2)
        List<InvoiceReceiveRegistEntity> invoiceReceiveRegisterList = invoiceReceiveRegistService.list(new QueryWrapper<InvoiceReceiveRegistEntity>().in("bill_state", Arrays.asList(1, 3)).eq("project_id", projectId));
        if (CollectionUtils.isNotEmpty(invoiceReceiveRegisterList) && invoiceReceiveRegisterList.size() > 0){
            //占用收票赋值
            List<Long> invoiceReceiveRegisterIdList = invoiceReceiveRegisterList.stream().map(InvoiceReceiveRegistEntity::getId).collect(Collectors.toList());
            projectBillVO.setInvoiceReceiveRegisterIdList(invoiceReceiveRegisterIdList);

            //查对应的收票登记-子表
            List<InvoiceReceivePoolEntity> invoiceReceivePoolList = invoiceReceivePoolService.list(new QueryWrapper<InvoiceReceivePoolEntity>().in("receive_bill_id", invoiceReceiveRegisterIdList));

            //查到合格的发票
            List<InvoiceReceivePoolEntity> passList = invoiceReceivePoolList.stream().filter(p -> p.getPassFlag() != null && 1 == p.getPassFlag() && null == p.getProjectBillId()).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(passList) && passList.size() > 0){
                projectBillVO.setInvoiceReceivePoolIdList(passList.stream().map(InvoiceReceivePoolEntity::getId).collect(Collectors.toList()));
                //异地预缴税额
                projectBillVO.setDifPlaceAdvanceTax(passList.stream().filter(p -> p.getTaxMny() != null && p.getReceiveType() != null && p.getReceiveType() == 2).map(InvoiceReceivePoolEntity::getTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add));
                //新增可抵扣税额（专票-自定义档案id：1853691016918339586）
                projectBillVO.setDeductTax(passList.stream().filter(p -> p.getTaxMny() != null && null != p.getInvoiceType() &&  "1853691016918339586".equals(String.valueOf(p.getInvoiceType()))).map(InvoiceReceivePoolEntity::getTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add));
                //新增专票成本
                projectBillVO.setSpecialTicketCost(passList.stream().filter(p -> p.getInvoiceTaxMny() != null && null != p.getInvoiceType() &&  "1853691016918339586".equals(String.valueOf(p.getInvoiceType()))).map(InvoiceReceivePoolEntity::getInvoiceTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add));
                //新增普票成本（普票-自定义档案id：1853691041769590785）
                projectBillVO.setCommonTicketMny(passList.stream().filter(p -> p.getInvoiceTaxMny() != null && null != p.getInvoiceType() &&  "1853691041769590785".equals(String.valueOf(p.getInvoiceType()))).map(InvoiceReceivePoolEntity::getInvoiceTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            }
            //不合格的发票
            List<InvoiceReceivePoolEntity> noPassList = invoiceReceivePoolList.stream().filter(p -> p.getTaxMny() != null && 0 == p.getPassFlag()).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(noPassList) && noPassList.size() > 0){
                //待合格成本
                projectBillVO.setWaitPassCost(noPassList.stream().filter(p -> p.getInvoiceTaxMny() != null).map(InvoiceReceivePoolEntity::getInvoiceTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add));
                //待合格抵扣税额 不合格发票中，专票税额合计
                projectBillVO.setWaitPassDeductTax(noPassList.stream().filter(p -> p.getTaxMny() != null && null != p.getInvoiceType() &&  "1853691016918339586".equals(String.valueOf(p.getInvoiceType()))).map(InvoiceReceivePoolEntity::getTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            }
        }

        //2、占用开票
        List<InvoiceOpenRegistEntity> openRegisterList = invoiceOpenRegistService.list(new QueryWrapper<InvoiceOpenRegistEntity>().in("bill_state", Arrays.asList(1, 3)).eq("project_id", projectId));
        if (CollectionUtils.isNotEmpty(openRegisterList) && openRegisterList.size() > 0){
            //累计开票金额
            projectBillVO.setTotalInvoiceMny(openRegisterList.stream().filter(p -> p.getOpenMny() != null).map(InvoiceOpenRegistEntity::getOpenMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            List<InvoiceOpenRegistEntity> noQuoteList = openRegisterList.stream().filter(p -> p.getProjectBillId() == null).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(noQuoteList) && noQuoteList.size() > 0){
                projectBillVO.setInvoiceOpenRegistIdList(noQuoteList.stream().map(InvoiceOpenRegistEntity::getId).collect(Collectors.toList()));
                //本次开票额
                projectBillVO.setInvoiceMny(noQuoteList.stream().filter(p -> p.getOpenMny() != null).map(InvoiceOpenRegistEntity::getOpenMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            }
        }


        //2、收款登记单
        // 查收款类型为已交税金-1850783141581557761L、合同收款-1850783094378860546L
        List<ReceiveEntity> allReceiveList = receiveService.list(new QueryWrapper<ReceiveEntity>().in("bill_state", Arrays.asList(1, 3)).eq("project_id", projectId).in("receive_kind", Arrays.asList(1850783094378860546L,1850783141581557761L)));
        if (CollectionUtils.isNotEmpty(allReceiveList) && allReceiveList.size() > 0){
            //累计回款金额
            projectBillVO.setTotalPaymentMny(allReceiveList.stream().filter(p -> p.getReceiveMny() != null && null != p.getReceiveKind() && "1850783094378860546".equals(String.valueOf(p.getReceiveKind()))).map(ReceiveEntity::getReceiveMny).reduce(BigDecimal.ZERO, BigDecimal::add));

            //查出未被引用的收款登记单
            List<ReceiveEntity> receiveList = allReceiveList.stream().filter(p -> p.getProjectBillId() == null).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(receiveList) && receiveList.size() > 0){
                projectBillVO.setReceiveIdList(receiveList.stream().map(ReceiveEntity::getId).collect(Collectors.toList()));
                //本次回款金额
                projectBillVO.setRepaymentMny(receiveList.stream().filter(p -> p.getReceiveMny() != null && null != p.getReceiveKind() && "1850783094378860546".equals(String.valueOf(p.getReceiveKind()))).map(ReceiveEntity::getReceiveMny).reduce(BigDecimal.ZERO, BigDecimal::add));
                //已交税金
                projectBillVO.setAlreadyPayTax(receiveList.stream().filter(p -> p.getReceiveMny() != null && null != p.getReceiveKind() && "1850783141581557761".equals(String.valueOf(p.getReceiveKind()))).map(ReceiveEntity::getReceiveMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            }
        }

        //3、民工工资支付申请记录
        List<PayMigrantEntity> payMigrantList = payMigrantService.list(new QueryWrapper<PayMigrantEntity>().in("bill_state", Arrays.asList(1, 3)).eq("project_id", projectId).gt("pay_mny", BigDecimal.ZERO).isNull("project_bill_id"));
        if (CollectionUtils.isNotEmpty(payMigrantList) && payMigrantList.size() > 0){
            projectBillVO.setPayMigrantIdList(payMigrantList.stream().map(PayMigrantEntity::getId).collect(Collectors.toList()));
            //新增农民工工资成本
            projectBillVO.setMigrantWorkerCashCost(payMigrantList.stream().filter(p -> p.getPayMny() != null).map(PayMigrantEntity::getPayMny).reduce(BigDecimal.ZERO, BigDecimal::add));
        }

        //4、其他费用单
        List<OtherFeeEntity> otherFeeList = otherFeeService.list(new QueryWrapper<OtherFeeEntity>().in("bill_state", Arrays.asList(1, 3)).eq("project_id", projectId).isNull("project_bill_id"));
        if (CollectionUtils.isNotEmpty(otherFeeList) && otherFeeList.size() > 0){
            projectBillVO.setOtherFeeIdList(otherFeeList.stream().map(OtherFeeEntity::getId).collect(Collectors.toList()));
            projectBillVO.setOtherChargeableMny(otherFeeList.stream().filter(p -> p.getFeeMny() != null).map(OtherFeeEntity::getFeeMny).reduce(BigDecimal.ZERO, BigDecimal::add));
        }


        ProjectRegisterEntity projectEntity = projectRegisterService.selectById(projectId);
        //
        BigDecimal totalChargingReferMny = BigDecimal.ZERO;
        //上次结余税额	上次对账单中的剩余可抵税额
        BigDecimal lastRepaymentTax = BigDecimal.ZERO;
        //上次结余成本	上次项目对账单的【剩余可用成本】
        BigDecimal lastBalanceCost = BigDecimal.ZERO;

        //金额赋值
        if (CollectionUtils.isNotEmpty(oldProjectBillEntityList) && oldProjectBillEntityList.size() > 0){
            totalChargingReferMny = oldProjectBillEntityList.stream().filter(p -> p.getChargingReferMny() != null).map(ProjectBillEntity::getChargingReferMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            lastRepaymentTax = oldProjectBillEntityList.get(0).getLeaveDeductTax();
            lastBalanceCost = oldProjectBillEntityList.get(0).getLeaveUsableCost();
        }

        //计费依据
        BigDecimal chargingReferMny;
        if (null != projectBillVO.getTotalInvoiceMny() && null != projectBillVO.getTotalPaymentMny()){
            chargingReferMny = ComputeUtil.safeSub(projectBillVO.getTotalInvoiceMny().compareTo(projectBillVO.getTotalPaymentMny()) > 0 ? projectBillVO.getTotalInvoiceMny() : projectBillVO.getTotalPaymentMny(), totalChargingReferMny);
        }else {
            chargingReferMny = null == projectBillVO.getTotalInvoiceMny() ? (null == projectBillVO.getTotalPaymentMny() ? BigDecimal.ZERO : projectBillVO.getTotalPaymentMny()) : projectBillVO.getTotalInvoiceMny();
        }
        projectBillVO.setChargingReferMny(chargingReferMny);
        //金额
        projectBillVO.setMny(ComputeUtil.safeDiv(ComputeUtil.safeMultiply(chargingReferMny, projectEntity.getTaxLevyRate()), new BigDecimal(100)).setScale(2, BigDecimal.ROUND_HALF_UP));

        //上次结余税额
        projectBillVO.setLastRepaymentTax(lastRepaymentTax);

        //现有抵扣税额合计: 上次结余税额+新增可抵税额
        projectBillVO.setDeductTaxCollect(ComputeUtil.safeAdd(lastRepaymentTax, projectBillVO.getDeductTax()));

        //本次抵扣税额
        //1、数据中心中的【现有抵扣税额合计】与最高上限取小值
        //2、最高上限公式：计费依据/1.09*0.09
        BigDecimal maxTop = ComputeUtil.safeMultiply(ComputeUtil.safeDiv(chargingReferMny, new BigDecimal(1.09)), new BigDecimal(0.09)).setScale(2, BigDecimal.ROUND_HALF_UP);
        projectBillVO.setAlreadyDeductTax(maxTop.compareTo(null != projectBillVO.getDeductTaxCollect() ? projectBillVO.getDeductTaxCollect() : BigDecimal.ZERO) > 0 ? projectBillVO.getDeductTaxCollect() : maxTop);

        //项目部应缴税小计:金额-异地预缴税额-已交税金-本次抵扣税额
        projectBillVO.setProjectDeptTax(ComputeUtil.safeSub(projectBillVO.getMny(), projectBillVO.getDifPlaceAdvanceTax(), projectBillVO.getAlreadyPayTax(), projectBillVO.getAlreadyDeductTax()));



        //管理费金额 计费依据*管理费征收率
        projectBillVO.setManagementFeeMny(ComputeUtil.safeDiv(ComputeUtil.safeMultiply(chargingReferMny, projectEntity.getManagementFeeRate()), new BigDecimal(100)).setScale(2, BigDecimal.ROUND_HALF_UP));

        //本次需提供成本 计费依据*0.92
        projectBillVO.setNeedCost(ComputeUtil.safeMultiply(chargingReferMny, new BigDecimal(0.92)).setScale(2, BigDecimal.ROUND_HALF_UP));

        //无成本票预留 【本次需提供成本】-【现有抵扣税额合计】
        projectBillVO.setNoCostTicketLevy(ComputeUtil.safeSub(projectBillVO.getNeedCost(), projectBillVO.getDeductTaxCollect()));

        //无需成本票预留金额	【无成本票预留】*无成本票预留征收率
        projectBillVO.setNoCostTicketReservedLevyMny(ComputeUtil.safeDiv(ComputeUtil.safeMultiply(projectBillVO.getNoCostTicketLevy(), projectEntity.getNoCostTicketReservedLevyRate()), new BigDecimal(100)).setScale(2, BigDecimal.ROUND_HALF_UP));

        //项目部应交费小计	管理费金额+无成本票预留金额+其他应收费用
        projectBillVO.setProjectDeptChargeableMny(ComputeUtil.safeAdd(projectBillVO.getManagementFeeMny(), projectBillVO.getNoCostTicketReservedLevyMny(), projectBillVO.getOtherChargeableMny()));

        //本次对账金额(前端设值)	本次回款金额-项目部应交税小计-项目部应交费小计-数据中心中【现有抵扣税额合计转现金】
        projectBillVO.setBillMny(ComputeUtil.safeSub(projectBillVO.getRepaymentMny(), projectBillVO.getProjectDeptTax(), projectBillVO.getProjectDeptChargeableMny()));



        //剩余可抵扣税额(前端设值)	现有抵扣税额合计-新增抵扣税额-现有抵扣税额合计转现金
        projectBillVO.setLeaveDeductTax(ComputeUtil.safeSub(projectBillVO.getDeductTaxCollect(), projectBillVO.getDeductTax()));
        //上次结余成本	上次项目对账单的【剩余可用成本】
        projectBillVO.setLastBalanceCost(lastBalanceCost);
        //现有成本合计	上次结余成本+新增专票成本+新增普票成本+新增农民工工资成本
        projectBillVO.setCostCollect(ComputeUtil.safeAdd(projectBillVO.getLastBalanceCost(), projectBillVO.getCommonTicketMny(), projectBillVO.getSpecialTicketCost(), projectBillVO.getMigrantWorkerCashCost()));
        //本次使用成本	本次需提供成本与现有成本合计取小值
        projectBillVO.setUseCost(projectBillVO.getNeedCost().compareTo(projectBillVO.getCostCollect()) > 0 ? projectBillVO.getCostCollect() : projectBillVO.getNeedCost());
        //剩余可用成本	现有成本合计-本次使用成本
        projectBillVO.setLeaveUsableCost(ComputeUtil.safeSub(projectBillVO.getCostCollect(), projectBillVO.getUseCost()));

        //本次抵扣上限（含预缴）计费依据/1.09*0.09-异地预缴税额
        projectBillVO.setDeductLimit(ComputeUtil.safeSub(maxTop, projectBillVO.getDifPlaceAdvanceTax()));
        //合同回款比例 累计回款金额（合同回款）/合同额
        projectBillVO.setContractPaymentRate(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(projectBillVO.getTotalPaymentMny(), projectEntity.getBidMny()), new BigDecimal(100)).setScale(2, BigDecimal.ROUND_HALF_UP));


        return projectBillVO;
    }

    @Override
    public void removeDataByProjectBillId(Long id) {
        otherFeeService.update(new UpdateWrapper<OtherFeeEntity>().in("project_bill_id", id).set("project_bill_id", null));
        invoiceReceiveRegistService.update(new UpdateWrapper<InvoiceReceiveRegistEntity>().in("project_bill_id", id).set("project_bill_id", null));
        invoiceReceivePoolService.update(new UpdateWrapper<InvoiceReceivePoolEntity>().in("project_bill_id", id).set("project_bill_id", null));
        receiveService.update(new UpdateWrapper<ReceiveEntity>().in("project_bill_id", id).set("project_bill_id", null));
        payMigrantService.update(new UpdateWrapper<PayMigrantEntity>().in("project_bill_id", id).set("project_bill_id", null));
        invoiceOpenRegistService.update(new UpdateWrapper<InvoiceOpenRegistEntity>().in("project_bill_id", id).set("project_bill_id", null));
    }

    @Override
    public List<ProjectDetailBillVO> pageList(Page<ProjectDetailBillVO> page, QueryWrapper<ProjectDetailBillVO> queryWrapper) {
        return baseMapper.pageList(page, queryWrapper);
    }

    @Override
    public List<InvoiceReceivePoolVO> queryCostDetailReport(Page<InvoiceReceivePoolVO> page, QueryWrapper<InvoiceReceivePoolVO> queryWrapper) {
        return baseMapper.queryCostDetailReport(page, queryWrapper);
    }

    @Override
    public ProjectReportVO queryProjectReportByProjectId(Long projectId) {
        return baseMapper.queryProjectReportByProjectId(projectId);
    }
}
