package com.ejianc.business.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bid.service.ITenderFundsService;
import com.ejianc.business.bid.vo.TenderFundsBackVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.bid.mapper.TenderFundsBackMapper;
import com.ejianc.business.bid.bean.TenderFundsBackEntity;
import com.ejianc.business.bid.service.ITenderFundsBackService;

import java.util.List;

/**
 * 投标管理-投标保证金退还
 * 
 * @author generator
 * 
 */
@Service("tenderFundsBackService")
public class TenderFundsBackServiceImpl extends BaseServiceImpl<TenderFundsBackMapper, TenderFundsBackEntity> implements ITenderFundsBackService{

    @Autowired
    private ITenderFundsService tenderFundsService;

    @Override
    public List<TenderFundsBackEntity> getByBusOpportunityId(Long id) {
        QueryWrapper<TenderFundsBackEntity> query = new QueryWrapper<>();
        query.eq("opportunity_id", id);
        query.orderByDesc("create_time");

        return super.list(query);
    }

    @Override
    public TenderFundsBackVO saveTenderFundsBack(TenderFundsBackEntity entity) {
        tenderFundsService.saveQuoteBillId(entity.getTenderFundsId(), entity.getId());
        super.saveOrUpdate(entity, false);
        return BeanMapper.map(entity, TenderFundsBackVO.class);
    }

    @Override
    public void deleteAllByIds(List<Long> ids) {
        tenderFundsService.delAllQuoteBillId(ids);
        super.removeByIds(ids, false);
    }
}
