package com.ejianc.business.contract.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.contract.bean.ContractManageEntity;
import com.ejianc.business.contract.service.IContractManageService;
import com.ejianc.business.contract.utils.BillCodeSetEnum;
import com.ejianc.business.contract.vo.ContractChangeVO;
import com.ejianc.business.contract.vo.ContractRecordVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.contract.mapper.ContractChangeMapper;
import com.ejianc.business.contract.bean.ContractChangeEntity;
import com.ejianc.business.contract.service.IContractChangeService;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static java.math.BigDecimal.ROUND_HALF_DOWN;

/**
 * 合同变更
 * 
 * @author generator
 * 
 */
@Service("contractChangeService")
public class ContractChangeServiceImpl extends BaseServiceImpl<ContractChangeMapper, ContractChangeEntity> implements IContractChangeService{

    @Autowired
    private IContractManageService contractService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IContractChangeService service;
    @Override
    public ContractChangeVO addConvertByConId(Long contractId) {
        ContractManageEntity contractVO = contractService.selectById(contractId);
        ContractChangeVO changeVO = BeanMapper.map(contractVO, ContractChangeVO.class);
        changeVO.setBillState(null);
        changeVO.setBeforeContractName(contractVO.getContractName());
        changeVO.setBeforeChangeMny(contractVO.getContractMny());
        changeVO.setBeforeChangeTaxMny(contractVO.getContractTaxMny());
        changeVO.setContractId(changeVO.getId());
        changeVO.setChangeVersion(contractVO.getChangeVersion() == null ? 1 : contractVO.getChangeVersion()+ 1);
        changeVO.setCreateUserCode(null);
        changeVO.setCreateTime(null);
        changeVO.setUpdateUserCode(null);
        changeVO.setUpdateTime(null);
        changeVO.setChangeDate(new Date());
        changeVO.setId(IdWorker.getId());
        return changeVO;
    }

    @Override
    public ContractChangeVO insertOrUpdate(ContractChangeVO changeVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<ContractChangeEntity> entities = null;
        int count = 0;

        //变更合同只能存在一条未生效的
        LambdaQueryWrapper<ContractChangeEntity> lambdachange = Wrappers.<ContractChangeEntity>lambdaQuery();
        lambdachange.eq(ContractChangeEntity::getTenantId, tenantId);
        lambdachange.eq(ContractChangeEntity::getContractId,changeVO.getContractId());
        if(changeVO.getId() != null && changeVO.getId() > 0) {
            lambdachange.ne(ContractChangeEntity::getId,changeVO.getId());
        }
        lambdachange.ne(ContractChangeEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdachange.ne(ContractChangeEntity::getBillState,BillStateEnum.COMMITED_STATE.getBillStateCode());
        int num = super.count(lambdachange);
        if(num>0){
            throw new BusinessException("该合同已存在未生效的变更单!");
        }
        if(StringUtils.isEmpty(changeVO.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BillCodeSetEnum.getEnumByContractType(changeVO.getContractType()).getBillCode(), InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                changeVO.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        if(changeVO.getId() != null && changeVO.getId() > 0 && service.getById(changeVO.getId())!=null) {
            //修改 校验合同编号唯一，变更单除去本单，采购合同  同时唯一
            LambdaQueryWrapper<ContractChangeEntity> lambda = Wrappers.<ContractChangeEntity>lambdaQuery();
            lambda.eq(ContractChangeEntity::getBillCode, changeVO.getBillCode());
            lambda.eq(ContractChangeEntity::getTenantId, tenantId);
            lambda.ne(ContractChangeEntity::getContractId,changeVO.getContractId());
            entities = super.list(lambda);

            LambdaQueryWrapper<ContractManageEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(ContractManageEntity::getTenantId, tenantId);
            queryWrapper.eq(ContractManageEntity::getBillCode, changeVO.getBillCode());
            queryWrapper.ne(ContractManageEntity::getId, changeVO.getContractId());
            count = contractService.count(queryWrapper);

        }else{
            //校验合同编号是否重复
            LambdaQueryWrapper<ContractChangeEntity> lambda = Wrappers.<ContractChangeEntity>lambdaQuery();
            lambda.eq(ContractChangeEntity::getTenantId, tenantId);
            lambda.eq(ContractChangeEntity::getBillCode, changeVO.getBillCode());
            lambda.ne(ContractChangeEntity::getContractId,changeVO.getContractId());
            entities = super.list(lambda);
            LambdaQueryWrapper<ContractManageEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(ContractManageEntity::getTenantId, tenantId);
            queryWrapper.eq(ContractManageEntity::getBillCode, changeVO.getBillCode());
            queryWrapper.ne(ContractManageEntity::getId, changeVO.getContractId());
            count = contractService.count(queryWrapper);
        }

        if(entities != null && entities.size() > 0  && count > 0 ) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }

        ContractChangeEntity changeEntity = BeanMapper.map(changeVO, ContractChangeEntity.class);
        super.saveOrUpdate(changeEntity, false);


        saveWriteContract(changeEntity);

        return BeanMapper.map(changeEntity, ContractChangeVO.class);
    }
    @Override
    public ContractRecordVO queryDetailRecord(Long id) {
        ContractManageEntity contractEntity = contractService.selectById(id);
        ContractRecordVO changeRecordVO = new ContractRecordVO();
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();
        BigDecimal baseTaxMny = contractEntity.getBaseTaxMoney() == null ? BigDecimal.ZERO : contractEntity.getBaseTaxMoney();
        changeRecordVO.setContractId(id);
        changeRecordVO.setContractTaxMny(contractTaxMny);
        changeRecordVO.setBaseTaxMoney(baseTaxMny);
        changeRecordVO.setContractStatus(contractEntity.getContractStatus());
        changeRecordVO.setChangeStatus(contractEntity.getChangeStatus());
        changeRecordVO.setSumChangeMny(contractTaxMny.subtract(baseTaxMny));
        BigDecimal sumChangeMny = changeRecordVO.getSumChangeMny() ==null ? BigDecimal.ZERO : changeRecordVO.getSumChangeMny();
        if(sumChangeMny.compareTo(BigDecimal.ZERO)!=0&&baseTaxMny.compareTo(BigDecimal.ZERO)!=0){
            BigDecimal sumScale = (sumChangeMny.divide(baseTaxMny, 8,ROUND_HALF_DOWN)).multiply(new BigDecimal(100));
            changeRecordVO.setSumScale(sumScale);
        }
        if(null != contractEntity.getChangeVersion() && contractEntity.getChangeVersion()>0){
            //合同版本号>0说明会有变更记录
            LambdaQueryWrapper<ContractChangeEntity> lambda = Wrappers.<ContractChangeEntity>lambdaQuery();
            lambda.eq(ContractChangeEntity::getContractId,id);
            lambda.in(ContractChangeEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
            List<ContractChangeEntity> entities = super.list(lambda);
            entities.forEach(changevo -> {
                        if(changevo.getChangeVersion()<10){
                            changevo.setBillCode(changevo.getBillCode()+"-0"+changevo.getChangeVersion());
                        }else{
                            changevo.setBillCode(changevo.getBillCode()+"-"+changevo.getChangeVersion());
                        }
                    }
            );
            changeRecordVO.setDetailList(BeanMapper.mapList(entities, ContractRecordVO.class));
        }
        return changeRecordVO;
    }
    private void saveWriteContract(ContractChangeEntity changeEntity){
        LambdaUpdateWrapper<ContractManageEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.set(ContractManageEntity::getChangeId, changeEntity.getId());
        updateWrapper.set(ContractManageEntity::getChangeCode, changeEntity.getBillCode());
        updateWrapper.set(ContractManageEntity::getChangeVersion, changeEntity.getChangeVersion());
        updateWrapper.set(ContractManageEntity::getChangeStatus, 2);
        updateWrapper.set(ContractManageEntity::getChangingMny, changeEntity.getContractMny());
        updateWrapper.set(ContractManageEntity::getChangingTaxMny, changeEntity.getContractTaxMny());
        updateWrapper.eq(ContractManageEntity::getId, changeEntity.getContractId());
        contractService.update(contractService.selectById(changeEntity.getContractId()), updateWrapper, false);
    }


}
