package com.ejianc.business.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bid.bean.ProjectPersonAffirmEntity;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.bid.mapper.ProjectRegistrationAffirmMapper;
import com.ejianc.business.bid.bean.ProjectRegistrationAffirmEntity;
import com.ejianc.business.bid.service.IProjectRegistrationAffirmService;

import java.util.List;

/**
 * 投标管理-项目登记确认单
 * 
 * @author generator
 * 
 */
@Service("projectRegistrationAffirmService")
public class ProjectRegistrationAffirmServiceImpl extends BaseServiceImpl<ProjectRegistrationAffirmMapper, ProjectRegistrationAffirmEntity> implements IProjectRegistrationAffirmService{

    @Override
    public List<ProjectRegistrationAffirmEntity> getByBusOpportunityId(Long id) {
        QueryWrapper<ProjectRegistrationAffirmEntity> query = new QueryWrapper<>();
        query.eq("opportunity_id", id);
        query.orderByDesc("create_time");
        return super.list(query);
    }
}
