package com.ejianc.business.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bid.bean.ProjectPersonAffirmEntity;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.bid.mapper.BidServiceFeeMapper;
import com.ejianc.business.bid.bean.BidServiceFeeEntity;
import com.ejianc.business.bid.service.IBidServiceFeeService;

import java.util.List;

/**
 * 投标管理-中标服务费
 * 
 * @author generator
 * 
 */
@Service("bidServiceFeeService")
public class BidServiceFeeServiceImpl extends BaseServiceImpl<BidServiceFeeMapper, BidServiceFeeEntity> implements IBidServiceFeeService{

    @Override
    public List<BidServiceFeeEntity> getByBusOpportunityId(Long id) {
        QueryWrapper<BidServiceFeeEntity> query = new QueryWrapper<>();
        query.eq("opportunity_id", id);
        query.orderByDesc("create_time");
        return super.list(query);
    }
}
