package com.ejianc.business.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bid.bean.BidPersonAffirmEntity;
import com.ejianc.business.bid.mapper.BidPersonAffirmMapper;
import com.ejianc.business.bid.service.IBidPersonAffirmService;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 投标管理-确认标书员
 * 
 * @author generator
 * 
 */
@Service("bidPersonAffirmService")
public class BidPersonAffirmServiceImpl extends BaseServiceImpl<BidPersonAffirmMapper, BidPersonAffirmEntity> implements IBidPersonAffirmService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String PC_URL = "/ejc-bfyjerp-frontend/#/bidPersonAffirm/card?id=";

    @Autowired
    private IPushMessageApi pushMessageApi;

    @Override
    public List<BidPersonAffirmEntity> getByBusOpportunityId(Long id) {
        QueryWrapper<BidPersonAffirmEntity> query = new QueryWrapper<>();
        query.eq("opportunity_id", id);
        query.orderByDesc("create_time");
        return super.list(query);
    }


    @Override
    public String sendMsgToInstallPerson(BidPersonAffirmEntity entity) {
        logger.info("开始给标书员、预算员发送消息：----");
        //工程名称：-工程名称，预算费用：，请注意
        String msg = this.sendMsg(entity, "标书员确认", entity.getEngineeringName() + "，预算费用：" + entity.getBudgetFee() + "：请确认！");
        if (StringUtils.isNotBlank(msg)){
            logger.error("开始给标书员、预算员发送消息异常：" + msg);
        }
        logger.info("开始给标书员、预算员发送消息结束！");
        return msg;
    }

    private String sendMsg(BidPersonAffirmEntity entity, String subject, String content) {
        String[] msgRecUserIds = new String[]{entity.getBidPersonId().toString(), entity.getBudgetPersonId().toString()};

        logger.info("消息接收人: {}", StringUtils.join(msgRecUserIds, ","));
        PushMsgParameter msgParameter = new PushMsgParameter();
        //消息接收人
        msgParameter.setReceivers(msgRecUserIds);
        //消息内容
        msgParameter.setContent(content);
        //消息主题
        msgParameter.setSubject(content);
        //消息类型
        msgParameter.setMsgType("notice");
        msgParameter.setTenantId(entity.getTenantId().toString());
        //消息保存
        msgParameter.setSaveFlag(true);
        //消息发送人
        msgParameter.setSendUserId(InvocationInfoProxy.getUserid());
        //消息发送渠道
        msgParameter.setChannel(new String[]{PushMsgParameter.CHANNEL_TYPE_SYS});
        msgParameter.setPcUrl(PC_URL + entity.getId());

        CommonResponse<String> msgSendResp = pushMessageApi.pushMessage(msgParameter);
        if (!msgSendResp.isSuccess()) {
            return msgSendResp.getMsg();
        }
        return null;
    }
}
