package com.ejianc.business.bid.service.impl;

import com.ejianc.business.bid.bean.AreaEntity;
import com.ejianc.business.bid.mapper.AreaMapper;
import com.ejianc.business.bid.service.IAreaService;
import com.ejianc.business.bid.vo.AreaVO;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * 行政地区数据服务实现类
 *
 * @author CJ
 * @Description: 行政地区数据服实现务
 * @date 2021/10/12 10:48
 */
@Service(value = "areaService")
public class AreaServiceImpl extends BaseServiceImpl<AreaMapper, AreaEntity> implements IAreaService {

    @Autowired
    private AreaMapper areaMapper;

    @Override
    public void batchDelByIds(List<Long> ids) {
        if(CollectionUtils.isNotEmpty(ids)) {
            areaMapper.batchDelByIds(ids);
        }
    }

    @Override
    public List<Map> queryAll(Long pid) {
        return areaMapper.queryAll(pid);
    }

    @Override
    public List<AreaVO> queryList(Long pid, String billCode, String areaName, Integer status) {
        return areaMapper.queryList(pid, billCode, areaName, status);
    }

}
