/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.project.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bid.vo.CompanyPerformanceVO;
import com.ejianc.business.project.bean.ProjectRegisterEntity;
import com.ejianc.business.project.mapper.ProjectRegisterMapper;
import com.ejianc.business.project.service.IProjectRegisterService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="projectRegisterService")
public class ProjectRegisterServiceImpl
extends BaseServiceImpl<ProjectRegisterMapper, ProjectRegisterEntity>
implements IProjectRegisterService {
    @Autowired
    private ProjectRegisterMapper mapper;

    @Override
    public ProjectRegisterEntity getByAffirmId(Long affirmId) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"affirm_id", (Object)affirmId);
        return (ProjectRegisterEntity)((Object)super.getOne((Wrapper)query));
    }

    @Override
    public List<ProjectRegisterEntity> getAllByOrgIds(List<Long> orgIds, String projectStatus) {
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"org_id", orgIds);
        if (StringUtils.isNotBlank((CharSequence)projectStatus)) {
            query.in((Object)"status", (Object[])projectStatus.split(","));
        }
        return super.list((Wrapper)query);
    }

    @Override
    public List<ProjectRegisterEntity> getAllByDepartmentIds(List<Long> departmentIds, String projectStatus) {
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"project_department_id", departmentIds);
        if (StringUtils.isNotBlank((CharSequence)projectStatus)) {
            query.in((Object)"status", (Object[])projectStatus.split(","));
        }
        return super.list((Wrapper)query);
    }

    @Override
    public List<CompanyPerformanceVO> pagePerformance(Map<String, Object> params) {
        return this.mapper.pagePerformance(params);
    }

    @Override
    public int countPerformance(Map<String, Object> params) {
        return this.mapper.countPerformance(params);
    }
}

