package com.ejianc.business.oa.service.impl;

import com.ejianc.business.oa.vo.CertTypeVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.oa.mapper.CertTypeMapper;
import com.ejianc.business.oa.bean.CertTypeEntity;
import com.ejianc.business.oa.service.ICertTypeService;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 人力行政-证照分类档案
 * 
 * @author generator
 * 
 */
@Service("certTypeService")
public class CertTypeServiceImpl extends BaseServiceImpl<CertTypeMapper, CertTypeEntity> implements ICertTypeService{

    @Override
    public List<CertTypeEntity> queryByCode(String code, Long id) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("code", new Parameter(QueryParam.EQ, code));
        if (null != id){
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, id));
        }
        List<CertTypeEntity> entityList = super.queryList(queryParam);
        if(entityList != null) {
            return entityList;
        }
        return null;
    }

    @Override
    public List<CertTypeVO> queryListByPid(Long id) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("parent_id", new Parameter(QueryParam.EQ, id));
        List<CertTypeEntity> entityList = super.queryList(queryParam);
        if(entityList != null) {
            return BeanMapper.mapList(entityList, CertTypeVO.class);
        }
        return null;
    }

    @Override
    public List<CertTypeEntity> queryProcessCategoryList(QueryParam queryParam) {
        Map<String, Parameter> paramMap = queryParam.getParams();

        Map<String,Object> condition = new HashMap<String, Object>();
        for(Map.Entry<String, Parameter> entry:paramMap.entrySet()) {
            condition.put(entry.getKey(), entry.getValue().getValue());
        }
        //放入租户ID进map
        condition.put("tenantId", InvocationInfoProxy.getTenantid());
        List<CertTypeEntity> resultList = baseMapper.queryProcessCategoryList(condition);
        return resultList;
    }
}
