package com.ejianc.business.oa.controller;

import java.io.Serializable;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.oa.vo.CertTypeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.oa.bean.CertTypeEntity;
import com.ejianc.business.oa.service.ICertTypeService;

/**
 * 人力行政-证照分类档案
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("certType")
public class CertTypeController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "CERT_TYPE";//此处需要根据实际修改

    @Autowired
    private ICertTypeService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CertTypeVO> saveOrUpdate(@RequestBody CertTypeVO saveOrUpdateVO) {
    	CertTypeEntity entity = BeanMapper.map(saveOrUpdateVO, CertTypeEntity.class);
        if(StringUtils.isNoneBlank(entity.getCode())){
            List<CertTypeEntity> codeData = service.queryByCode(entity.getCode(), entity.getId());
            if(codeData!=null && codeData.size()>0){
                throw new BusinessException("分类编码已存在,请重新填写");
            }
        }
    	if(entity.getId() == null || entity.getId() == 0){
            if (null == entity.getCode()){
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if(billCode.isSuccess()) {
                    entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                }else{
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }
            entity.setId(IdWorker.getId());
            if(entity.getParentId() != null && entity.getParentId() > 0) {
                CertTypeEntity uniqueBean = service.selectById(entity.getParentId());
                entity.setInnerCode(uniqueBean.getInnerCode() + "|" + entity.getId());
            } else {
                entity.setInnerCode(entity.getId().toString());
            }
        }else {
            CertTypeEntity certTypeEntity = service.selectById(entity.getId());
            certTypeEntity.setName(saveOrUpdateVO.getName());
            certTypeEntity.setCode(saveOrUpdateVO.getCode());
            certTypeEntity.setDescription(saveOrUpdateVO.getDescription());
            certTypeEntity.setSequence(saveOrUpdateVO.getSequence());
            entity = certTypeEntity;
        }
    	service.saveOrUpdate(entity, false);
    	CertTypeVO vo = BeanMapper.map(service.selectById(entity.getId()), CertTypeVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CertTypeVO> queryDetail(Long id) {
    	CertTypeEntity entity = service.selectById(id);
    	CertTypeVO vo = BeanMapper.map(entity, CertTypeVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        if (ListUtil.isNotEmpty(ids)) {
            for (Long id : ids) {
                //如果分类有子节点并且所有子节点也包含在删除项内，允许删除
                List<CertTypeVO> children = service.queryListByPid(id);
                if(children != null && children.size() > 0) {
                    for (CertTypeVO child : children) {
                        if(!ids.contains(child.getId())){
                            return CommonResponse.error("分类【" + child.getName() + "】下有子分类不允许删除");
                        }
                    }
                }
            }
        } else {
            return CommonResponse.error("删除失败：主键为空!");
        }
        service.removeByIds(ids);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam queryParam) {

        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
//        queryParam.getOrderMap().put("sequence", "asc");
        List<CertTypeEntity> dataList = service.queryProcessCategoryList(queryParam);

        List<Map> resultMapList = BeanMapper.mapList(dataList, Map.class);
        resultMapList.forEach(l-> {
            if(l.get("isLeaf").equals(false)){
                l.put("children", new ArrayList<>());
            }
        });
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", ResultAsTree.createTreeData(resultMapList));

        return CommonResponse.success(jsonObject);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<CertTypeEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("CertType-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refCertTypeData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<CertTypeVO>> refCertTypeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<CertTypeEntity> page = service.queryPage(param,false);
        IPage<CertTypeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CertTypeVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }



    /**
     * 证照档案参照
     *
     * @param condition
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/queryCertTypeTree", method = RequestMethod.GET)
    @ResponseBody
    public List<CertTypeVO> queryCertTypeTree(@RequestParam(required=false) String condition,
                                                                     @RequestParam(required=false) Long pid, @RequestParam(required = false) String searchText) {
        List<CertTypeVO> dataList = null;
        try {
            Map<String,Object> params = new HashMap<>();
            if(StringUtils.isNotBlank(searchText)) {
                params.put("name", searchText);
            }
            if(pid!=null){
                params.put("parentId", pid);
            }
            dataList = service.queryListEntityTree(params);

            dataList.forEach(l-> {
                if(!l.getIsLeaf()){
                    l.setChildren(new ArrayList<>());
                    l.setIsParent(true);
                }else{
                    l.setIsParent(false);
                }
            });
            if(StringUtils.isNotBlank(searchText)){
                return dataList;
            }
            return createTreeDataVO(dataList);
        } catch (Exception e) {
            logger.error("查询所有模块树异常: ", e);
            return null;
        }
    }


    public static List<CertTypeVO> createTreeDataVO(List<CertTypeVO> list) {
        List<CertTypeVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();
        Map<String, CertTypeVO> listMap = new HashMap<>();
        for(CertTypeVO orgEntity:list) {
            listMap.put(orgEntity.getId().toString(), orgEntity);
        }

        for(int i =0; i<list.size(); i++) {
            CertTypeVO orgEntity = list.get(i);
            String parentId = (orgEntity.getParentId() != null && orgEntity.getParentId() > 0) ? orgEntity.getParentId().toString():"";
            CertTypeVO parent = listMap.get(parentId);
            if(parent != null) {
                List<CertTypeVO> child = parent.getChildren();
                if(child != null) {
                    child.add(orgEntity);
                }else{
                    List<CertTypeVO> children = new ArrayList<CertTypeVO>();
                    children.add(orgEntity);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(orgEntity.getId().toString());
            }
        }

        for(String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }
}
