package com.ejianc.business.oa.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.oa.bean.PurchaseDetailEntity;
/**
 * 人力行政-采购申请单
 * 
 * @author generator
 * 
 */
 @TableName("ejc_oa_purchase")
public class PurchaseEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="store_id")
    private Long storeId; // 仓库id
    @TableField(value="store_name")
    private String storeName; // 仓库名称
    @TableField(value="apply_date")
    private Date applyDate; // 申请日期
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="confirm_time")
    private Date confirmTime; // 经办时间
    @TableField(value="dept_id")
    private Long deptId; // 申请部门ID
    @TableField(value="dept_name")
    private String deptName; // 申请部门
    @TableField(value="handle_person_id")
    private Long handlePersonId; // 负责人
    @TableField(value="handle_person_name")
    private String handlePersonName; // 负责人名称
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="purchaseDetailService", pidName = "purchaseId")
    private List<PurchaseDetailEntity> detailList = new ArrayList<>(); // 人力行政-采购申请单子表
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getStoreId() {
        return storeId;
    }

    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }
    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }
    public Date getApplyDate() {
        return applyDate;
    }

    public void setApplyDate(Date applyDate) {
        this.applyDate = applyDate;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(Date confirmTime) {
        this.confirmTime = confirmTime;
    }
    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    public Long getHandlePersonId() {
        return handlePersonId;
    }

    public void setHandlePersonId(Long handlePersonId) {
        this.handlePersonId = handlePersonId;
    }
    public String getHandlePersonName() {
        return handlePersonName;
    }

    public void setHandlePersonName(String handlePersonName) {
        this.handlePersonName = handlePersonName;
    }


    public List<PurchaseDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<PurchaseDetailEntity> detailList) {
        this.detailList = detailList;
    }
}
