package com.ejianc.business.oa.controller;

import java.io.Serializable;

import cn.hutool.core.collection.CollUtil;
import com.ejianc.business.oa.bean.OutstoreDetailEntity;
import com.ejianc.business.oa.service.IInstoreService;
import com.ejianc.business.oa.vo.OutstoreDetailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.oa.bean.OutstoreEntity;
import com.ejianc.business.oa.service.IOutstoreService;
import com.ejianc.business.oa.vo.OutstoreVO;

/**
 * 人力行政-物品出库单
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("outstore")
public class OutstoreController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String TRANSFER_BILL_CODE = "OA_TRANSFER";//调拨单
    private static final String OUT_STORE_BILL_CODE = "OA_OUTSTORE";//出库单
    private static final String ASSET_SCRAP_BILL_CODE = "ASSET_SCRAP";//出库单

    @Autowired
    private IOutstoreService service;
    @Autowired
    private IInstoreService instoreService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OutstoreVO> saveOrUpdate(@RequestBody OutstoreVO saveOrUpdateVO) {
    	OutstoreEntity entity = BeanMapper.map(saveOrUpdateVO, OutstoreEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(0 == entity.getOutStoreType() ? TRANSFER_BILL_CODE : 1 == entity.getOutStoreType() ? OUT_STORE_BILL_CODE : ASSET_SCRAP_BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        List<OutstoreDetailEntity> outStoreSubEntities = entity.getDetailList();
        if (ListUtil.isNotEmpty(outStoreSubEntities)) {
            Map<Long, BigDecimal> numMap = new HashMap();
            if (null != saveOrUpdateVO.getId()) {
                OutstoreEntity oldEntity = service.selectById(saveOrUpdateVO.getId());
                if (CollUtil.isNotEmpty(oldEntity.getDetailList())) {
                    numMap = oldEntity.getDetailList().stream().collect(Collectors.toMap(OutstoreDetailEntity::getSourceSubId
                            , OutstoreDetailEntity::getOutStoreNumber));
                }
            }
            for (OutstoreDetailEntity outStoreSubEntity : outStoreSubEntities) {
                if (!"del".equals(outStoreSubEntity.getRowState())) {
                    //查询已被占用数量
                    BigDecimal inNum = instoreService.calculateCanUseNum(outStoreSubEntity.getSourceSubId(), outStoreSubEntity.getMaterialId(), null);
                    //本次出库数量
                    BigDecimal _num = outStoreSubEntity.getOutStoreNumber();
                    if (null != numMap.get(outStoreSubEntity.getSourceSubId())) {
                        //本次需占用
                        _num = ComputeUtil.safeSub(_num, numMap.get(outStoreSubEntity.getSourceSubId()));
                    }
                    if (ComputeUtil.isGreaterThan(_num, inNum)) {
                        throw new BusinessException("物资【" + outStoreSubEntity.getMaterialName() + "】已被使用完毕，请刷新后重新制单！");
                    }
                }
            }
        }
    	service.saveOrUpdate(entity, false);
    	OutstoreVO vo = BeanMapper.map(entity, OutstoreVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OutstoreVO> queryDetail(Long id) {
    	OutstoreEntity entity = service.selectById(id);
    	OutstoreVO vo = BeanMapper.map(entity, OutstoreVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OutstoreVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (OutstoreVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(OutstoreVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OutstoreVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode","orgName","outStoreName","inStoreName","inOrgName"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<OutstoreEntity> page = service.queryPage(param,false);
        IPage<OutstoreVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), OutstoreVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode","orgName","outStoreName","inStoreName","inOrgName"));
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<OutstoreEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();

        List<OutstoreVO> voList = BeanMapper.mapList(list, OutstoreVO.class);
        voList.forEach(e -> {
            e.setBillStateName(BillStateEnum.getEnumByStateCode(e.getBillState()).getDescription());
        });
        beans.put("records", voList);
        ExcelExport.getInstance().export(param.getParams().get("outStoreType").getValue().toString().equals("0") ? "Transferstore-export.xlsx" : param.getParams().get("outStoreType").getValue().toString().equals("1") ? "Outstore-export.xlsx" : "AssetScrap-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refOutstoreData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OutstoreVO>> refOutstoreData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<OutstoreEntity> page = service.queryPage(param,false);
        IPage<OutstoreVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OutstoreVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }




    /**
     * @Description 根据仓库，物资获取出库详情
     * @param
     * @Return void
     */
    @RequestMapping(value = "/queryOutDataByStore", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List> queryOutDataByStore(Long storeId, Long materialId) {
        List<OutstoreDetailVO> dataList = service.queryOutDataByStore(storeId, materialId);
        return CommonResponse.success("根据仓库，物资查询出库详情！", dataList);
    }
}
