package com.ejianc.business.scene.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.scene.bean.CheckBfyjEntity;
import com.ejianc.business.scene.bean.CheckRecordBfyjEntity;
import com.ejianc.business.scene.service.CheckMessageService;
import com.ejianc.business.scene.service.ICheckBfyjService;
import com.ejianc.business.scene.service.ICheckRecordBfyjService;
import com.ejianc.business.scene.utils.*;
import com.ejianc.business.scene.vo.CheckBfyjVO;
import com.ejianc.business.scene.vo.CheckDetailBfyjVO;
import com.ejianc.business.scene.vo.CheckRecordBfyjVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.fields.service.ICommenQueryFieldsService;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.scene.mapper.CheckDetailBfyjMapper;
import com.ejianc.business.scene.bean.CheckDetailBfyjEntity;
import com.ejianc.business.scene.service.ICheckDetailBfyjService;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

/**
 * 现场监控-现场检查-检查单待检复检子表
 * 
 * @author generator
 * 
 */
@Service("checkDetailBfyjService")
public class CheckDetailBfyjServiceImpl extends BaseServiceImpl<CheckDetailBfyjMapper, CheckDetailBfyjEntity> implements ICheckDetailBfyjService{

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private ICheckBfyjService service;
    @Autowired
    private ICheckRecordBfyjService sceneCheckRecordService;

    @Autowired
    private JedisPool jedisPool;

    @Autowired
    private ICommenQueryFieldsService commenQueryFieldsService;

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private CheckMessageService checkMessageService;

    private static final String BILL_CODE = "SCENE_CHECK_DETAIL_CODE";//此处需要根据实际修改

    /**
     * 保存整改单
     * @param saveorUpdateVO
     * @return
     */
    @Override
    public CommonResponse<CheckDetailBfyjVO> insertOrUpdate(CheckDetailBfyjVO saveorUpdateVO) {

        CheckDetailBfyjEntity entity = BeanMapper.map(saveorUpdateVO, CheckDetailBfyjEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                //entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setIsReform(Integer.parseInt(CheckItemReformState.REVIEW_REFORM_STATE.getCode()));
        }

        if(saveorUpdateVO.getVersion() !=null && saveorUpdateVO.getVersion()!=0){
            Jedis jedis = jedisPool.getResource();
            boolean locked = false;
            try{
                locked = RedisTool.tryLock(jedis, String.valueOf(saveorUpdateVO.getId()), "saveOrUpdate", 1000);
                logger.info("判断单据单据锁结果------"+locked);
                if(locked){
                    JSONObject checkDetailEntity = commenQueryFieldsService.queryBillDetail(String.valueOf(saveorUpdateVO.getId()),"BT211018000000001");
                    String objVersion = checkDetailEntity.getJSONObject("data").get("version").toString();
                    Integer version =checkDetailEntity.getJSONObject("data").get("version")==null?0:Integer.parseInt(objVersion.substring(0,objVersion.indexOf(".")));
                    Integer conVersion = saveorUpdateVO.getVersion();
                    if(version!=conVersion){
                        return CommonResponse.error("该检查项已被更新，请刷新后重新整改！");
                    }
                }else{
                    return CommonResponse.error("出现并发操作,请稍后重试！");
                }
            }catch (Exception e) {
                e.printStackTrace();
            } finally {
                if(locked) {
                    RedisTool.releaseLock(jedis, String.valueOf(saveorUpdateVO.getId()), "saveOrUpdate");
                }
                jedis.close();
            }
        }

        super.saveOrUpdate(entity, false);
        //新增或修改后，需要查询当前检查项的检查记录回显
        QueryParam param = new QueryParam();
        param.getParams().put("pid",new Parameter(QueryParam.EQ, entity.getId()));
        param.getOrderMap().put("createTime", QueryParam.DESC);
        List<CheckRecordBfyjEntity> sceneCheckRecordList = sceneCheckRecordService.queryList(param, false);
        CheckDetailBfyjVO vo = BeanMapper.map(entity, CheckDetailBfyjVO.class);
        List<CheckRecordBfyjVO> CheckRecordBfyjVO = BeanMapper.mapList(sceneCheckRecordList, CheckRecordBfyjVO.class);
        vo.setSceneCheckRecords(CheckRecordBfyjVO);

        return CommonResponse.success("保存或修改单据成功！",BeanMapper.map(vo, CheckDetailBfyjVO.class));
    }

    @Override
    public void checkDetailSubmitHandler(Long billId) {
        if(billId != null){
            //提交后，检查项的整改次数+1
            CheckDetailBfyjEntity sceneCheckDetail = this.selectById(billId);
            LambdaUpdateWrapper<CheckDetailBfyjEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(CheckDetailBfyjEntity::getId,billId);
            updateWrapper.set(CheckDetailBfyjEntity::getReformNumber,sceneCheckDetail.getReformNumber()+1);
            updateWrapper.set(CheckDetailBfyjEntity::getIsReform, Integer.parseInt(CheckItemReformState.REVIEW_REFORM_STATE.getCode()));
            updateWrapper.set(CheckDetailBfyjEntity::getTaskState, CheckItemReformState.REVIEW_REFORM_STATE.getDescription());
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            //整改信息，最新的当前整改人-整改时间-整改描述
            String reformNews = sceneCheckDetail.getCurrentRectificationPerson()+"-"+sdf.format(sceneCheckDetail.getReformDate())+"-"+sceneCheckDetail.getReformMsg();
            updateWrapper.set(CheckDetailBfyjEntity::getReformNews,reformNews);
            //待整改每次提交，都需要把复查状态设置为待复查，
            updateWrapper.set(CheckDetailBfyjEntity::getReviewResult, Integer.parseInt(ReviewState.REVIEW_STATE.getCode()));
            // 能否编辑 设置为能编辑（此字段前端组件判断）
            updateWrapper.set(CheckDetailBfyjEntity::getIsModify,Integer.parseInt(ModifyState.NOT_MODIFIED_STATE.getCode()));


            Date finishDate = sceneCheckDetail.getFinishDate();
            Date nowDate = new Date();
            String nowDateStr = sdf.format(nowDate);
            String finishDateStr = sdf.format(finishDate);
            //当前时间大于完成时间 逾期状态设置为1
            if(nowDateStr.compareTo(finishDateStr) > 0){
                updateWrapper.set(CheckDetailBfyjEntity::getIsOverdue, Integer.parseInt(OverdueState.OVERDUE_STATE.getCode()));
            }else if(sceneCheckDetail.getIsOverdue()==null){
                //当前整改未逾期，且逾期状态为空时，设置默认逾期状态
                updateWrapper.set(CheckDetailBfyjEntity::getIsOverdue, Integer.parseInt(OverdueState.NOTOVERDUE_STATE.getCode()));
            }
            //清空复查信息 reviewDescribe
            updateWrapper.set(CheckDetailBfyjEntity::getReviewDescribe, null);
            //复查图片
            updateWrapper.set(CheckDetailBfyjEntity::getReviewImgUrl, null);
            updateWrapper.set(CheckDetailBfyjEntity::getReviewImgIds, null);
            this.update(updateWrapper);

            //生成整改信息
            CheckRecordBfyjEntity sceneCheckRecord=new CheckRecordBfyjEntity();
            sceneCheckRecord.setPid(sceneCheckDetail.getId());
            sceneCheckRecord.setCheckId(sceneCheckDetail.getPid());
            //设置操作状态
            sceneCheckRecord.setOperationType(Integer.parseInt(OperationState.REFORM_STATE.getCode()));
            sceneCheckRecord.setReviewPerson(sceneCheckDetail.getReviewPerson());
            sceneCheckRecord.setReviewDescribe(sceneCheckDetail.getReviewDescribe());
            sceneCheckRecord.setReviewResult(sceneCheckDetail.getReviewResult());
            sceneCheckRecord.setImgIds(sceneCheckDetail.getReformImgIds());
            sceneCheckRecord.setCheckPerson(sceneCheckDetail.getCheckPerson());
            sceneCheckRecord.setCheckItem(sceneCheckDetail.getCheckItem());
            sceneCheckRecord.setRectificationPerson(sceneCheckDetail.getCurrentRectificationPerson());
            sceneCheckRecord.setRectificationDescribe(sceneCheckDetail.getReformMsg());
            sceneCheckRecordService.save(sceneCheckRecord);

            //提交时要判断子表是否已经全部提交了，全部提交后把主表的复查状态设置为待复查
            int count = 0;
            QueryParam param = new QueryParam();
            param.getParams().put("pid",new Parameter(QueryParam.EQ,sceneCheckDetail.getPid()));
            List<CheckDetailBfyjEntity> detailList = this.queryList(param);
            for (CheckDetailBfyjEntity detailEntity:detailList) {
                if(detailEntity.getIsReform()==Integer.parseInt(CheckItemReformState.REVIEW_REFORM_STATE.getCode()) || detailEntity.getIsReform()==Integer.parseInt(CheckItemReformState.REFORM_SUCCESS_STATE.getCode())){
                    count+=1;
                }
            }
            if(count == detailList.size()){
                LambdaUpdateWrapper<CheckBfyjEntity> wrapper = new LambdaUpdateWrapper<>();
                wrapper.eq(CheckBfyjEntity::getId,sceneCheckDetail.getPid());
                wrapper.set(CheckBfyjEntity::getReformStatus, Integer.parseInt(ReformState.REVIEW_STATE.getCode()));
                wrapper.set(CheckBfyjEntity::getReviewStatus,Integer.parseInt(SubmitState.NO_SUBMITTED.getCode()));
                wrapper.set(CheckBfyjEntity::getReformFinishDate ,sdf.format(new Date()));
                service.update(wrapper);
                //全部都提交后，向复查人发送消息
                CheckBfyjEntity CheckBfyjEntity = service.selectById(sceneCheckDetail.getPid());
                CheckBfyjVO vo = BeanMapper.map(CheckBfyjEntity, CheckBfyjVO.class);
                String reviewId = vo.getReviewId();
                if(StringUtils.isNotBlank(reviewId)){
                    String[] review = reviewId.split(",");
                    vo.setMsgNum(0);
                    vo.setMsgId(vo.getId());
                    vo.setMsgBillCode(vo.getBillCode());
                    checkMessageService.sendMsg(vo,review,NoticeEnum.REFORM_COMMIT);
                }
            }


        }

    }
}