package com.ejianc.business.tax.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 税务管理-成本比例分析
 * 
 * @author generator
 * 
 */
 @TableName("ejc_tax_cost_ratio")
public class CostRatioEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="business_name")
    private String businessName; // 企业名称
    @TableField(value="build_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date buildDate; // 成立日期
    @TableField(value="year")
    @JsonFormat(pattern = "yyyy", timezone = "GMT+8")
    private Date year; // 年份
    @TableField(value="income_mny")
    private BigDecimal incomeMny; // 收入
    @TableField(value="cost_mny")
    private BigDecimal costMny; // 成本
    @TableField(value="ratio")
    private BigDecimal ratio; // 占比
    
    
    

    public String getBusinessName() {
        return businessName;
    }

    public void setBusinessName(String businessName) {
        this.businessName = businessName;
    }

    public Date getBuildDate() {
        return buildDate;
    }

    public void setBuildDate(Date buildDate) {
        this.buildDate = buildDate;
    }

    public Date getYear() {
        return year;
    }

    public void setYear(Date year) {
        this.year = year;
    }

    public BigDecimal getIncomeMny() {
        return incomeMny;
    }

    public void setIncomeMny(BigDecimal incomeMny) {
        this.incomeMny = incomeMny;
    }
    public BigDecimal getCostMny() {
        return costMny;
    }

    public void setCostMny(BigDecimal costMny) {
        this.costMny = costMny;
    }
    public BigDecimal getRatio() {
        return ratio;
    }

    public void setRatio(BigDecimal ratio) {
        this.ratio = ratio;
    }
    
}
