package com.ejianc.business.tax.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 税务管理-收票登记-详情
 * 
 * @author generator
 * 
 */
 @TableName("ejc_tax_invoice_receive_pool")
public class InvoiceReceivePoolEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_id")
    private Long projectId; // 项目主键
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="org_id")
    private Long orgId; // 组织主键
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目所属组织
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目所属组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目所属组织编码
    @TableField(value="receive_type")
    private Integer receiveType; // 业务类型：1自缴异地预缴2/项目异地预缴票
//    @TableField(value="customer_id")
//    private Long customerId; // 购方主键
//    @TableField(value="customer_name")
//    private String customerName; // 购方名称
    @TableField(value="supplier_name")
    private String supplierName; // 销方名称
    @TableField(value="supplier_id")
    private Long supplierId; // 销方主键
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="invoice_type")
    private Long invoiceType; // 发票类型
    @TableField(value="invoice_type_name")
    private String invoiceTypeName; // 发票类型名称；
    @TableField(value="invoice_number")
    private String invoiceNumber; // 发票号码
    @TableField(value="invoice_code")
    private String invoiceCode; // 发票代码
    @TableField(value="invoice_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date invoiceDate; // 开票日期
    @TableField(value="invoice_mny")
    private BigDecimal invoiceMny; // 发票金额（不含税）
    @TableField(value="tax_mny")
    private BigDecimal taxMny; // 税额
    @TableField(value="invoice_tax_mny")
    private BigDecimal invoiceTaxMny; // 价税合计
    @TableField(value="bill_code")
    private String billCode; // 主表编码
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="invoice_tax_mnys")
    private String invoiceTaxMnys; // 价税合计大写
    @TableField(value="receive_bill_code")
    private String receiveBillCode; // 收票登记单号
    @TableField(value="receive_bill_id")
    private Long receiveBillId; // 收票登记单id
    @TableField(value="regist")
    private Integer regist; // 是否登记
    @TableField(value="tax_rate")
    private BigDecimal taxRate; // 税率
    @TableField(value="pass_flag")
    private Integer passFlag; // 是否合格(1-是，0否)
    @TableField(value="receive_type_name")
    private String receiveTypeName; // 业务类型：1自缴异地预缴2/项目异地预缴票
    @TableField(value="project_bill_id")
    private Long projectBillId; // 项目对账单id

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getOrgName() {
        return orgName;
    }

    public Integer getPassFlag() {
        return passFlag;
    }

    public void setPassFlag(Integer passFlag) {
        this.passFlag = passFlag;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public Long getProjectBillId() {
        return projectBillId;
    }

    public void setProjectBillId(Long projectBillId) {
        this.projectBillId = projectBillId;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public String getReceiveTypeName() {
        return receiveTypeName;
    }

    public void setReceiveTypeName(String receiveTypeName) {
        this.receiveTypeName = receiveTypeName;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Integer getReceiveType() {
        return receiveType;
    }

    public void setReceiveType(Integer receiveType) {
        this.receiveType = receiveType;
    }
//    public Long getCustomerId() {
//        return customerId;
//    }
//
//    public void setCustomerId(Long customerId) {
//        this.customerId = customerId;
//    }
//    public String getCustomerName() {
//        return customerName;
//    }
//
//    public void setCustomerName(String customerName) {
//        this.customerName = customerName;
//    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(Long invoiceType) {
        this.invoiceType = invoiceType;
    }
    public String getInvoiceTypeName() {
        return invoiceTypeName;
    }

    public void setInvoiceTypeName(String invoiceTypeName) {
        this.invoiceTypeName = invoiceTypeName;
    }
    public String getInvoiceNumber() {
        return invoiceNumber;
    }

    public void setInvoiceNumber(String invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
    }
    public String getInvoiceCode() {
        return invoiceCode;
    }

    public void setInvoiceCode(String invoiceCode) {
        this.invoiceCode = invoiceCode;
    }
    public Date getInvoiceDate() {
        return invoiceDate;
    }

    public void setInvoiceDate(Date invoiceDate) {
        this.invoiceDate = invoiceDate;
    }
    public BigDecimal getInvoiceMny() {
        return invoiceMny;
    }

    public void setInvoiceMny(BigDecimal invoiceMny) {
        this.invoiceMny = invoiceMny;
    }
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    public BigDecimal getInvoiceTaxMny() {
        return invoiceTaxMny;
    }

    public void setInvoiceTaxMny(BigDecimal invoiceTaxMny) {
        this.invoiceTaxMny = invoiceTaxMny;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getInvoiceTaxMnys() {
        return invoiceTaxMnys;
    }

    public void setInvoiceTaxMnys(String invoiceTaxMnys) {
        this.invoiceTaxMnys = invoiceTaxMnys;
    }
    public String getReceiveBillCode() {
        return receiveBillCode;
    }

    public void setReceiveBillCode(String receiveBillCode) {
        this.receiveBillCode = receiveBillCode;
    }
    public Long getReceiveBillId() {
        return receiveBillId;
    }

    public void setReceiveBillId(Long receiveBillId) {
        this.receiveBillId = receiveBillId;
    }
    public Integer getRegist() {
        return regist;
    }

    public void setRegist(Integer regist) {
        this.regist = regist;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    
}
