/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cost.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cost.service.IProjectBillService;
import com.ejianc.business.cost.vo.ProjectDetailBillVO;
import com.ejianc.business.project.bean.ProjectRegisterEntity;
import com.ejianc.business.project.service.IProjectRegisterService;
import com.ejianc.business.tax.vo.InvoiceReceivePoolVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"projectCost"})
public class ProjectCostController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private IProjectRegisterService projectRegisterService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProjectBillService service;
    @Autowired
    private IProjectRegisterService registerService;

    @RequestMapping(value={"/queryProjectDetailBill"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryProjectDetailBill(@RequestBody QueryParam param) {
        param.setPageIndex(1);
        param.setPageSize(100);
        List fuzzyFields = param.getFuzzyFields();
        JSONObject res = new JSONObject();
        if (null == param.getParams().get("projectId")) {
            return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
        }
        Long projectId = Long.valueOf(((Parameter)param.getParams().get("projectId")).getValue().toString());
        ProjectRegisterEntity projectRegisterEntity = (ProjectRegisterEntity)((Object)this.registerService.selectById(projectId));
        QueryWrapper queryWrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<ProjectDetailBillVO> pageData = this.service.pageList((Page<ProjectDetailBillVO>)page, (QueryWrapper<ProjectDetailBillVO>)queryWrapper);
        BigDecimal balance = BigDecimal.ZERO;
        for (ProjectDetailBillVO data : pageData) {
            data.setId(Long.valueOf(IdWorker.getId()));
            balance = ComputeUtil.safeSub((BigDecimal)ComputeUtil.safeAdd((BigDecimal)(null != data.getReceiveMny() ? data.getReceiveMny() : BigDecimal.ZERO), (BigDecimal)balance), (BigDecimal)(null != data.getPaymentMny() ? data.getPaymentMny() : BigDecimal.ZERO));
            data.setBalance(balance);
        }
        res.put("records", pageData);
        res.put("total", (Object)page.getTotal());
        res.put("current", (Object)page.getCurrent());
        res.put("size", (Object)page.getSize());
        res.put("pages", (Object)page.getPages());
        res.put("collectionTypeName", (Object)projectRegisterEntity.getCollectionTypeName());
        res.put("contractMny", (Object)projectRegisterEntity.getBidMny());
        res.put("balance", (Object)(null != pageData && pageData.size() > 1 ? pageData.get(pageData.size() - 1).getBalance() : BigDecimal.ZERO));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    @RequestMapping(value={"/projectDetailBillExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void projectDetailBillExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        QueryWrapper queryWrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<ProjectDetailBillVO> pageData = this.service.pageList((Page<ProjectDetailBillVO>)page, (QueryWrapper<ProjectDetailBillVO>)queryWrapper);
        BigDecimal balance = BigDecimal.ZERO;
        for (ProjectDetailBillVO data : pageData) {
            data.setId(Long.valueOf(IdWorker.getId()));
            balance = ComputeUtil.safeSub((BigDecimal)ComputeUtil.safeAdd((BigDecimal)(null != data.getReceiveMny() ? data.getReceiveMny() : BigDecimal.ZERO), (BigDecimal)balance), (BigDecimal)(null != data.getPaymentMny() ? data.getPaymentMny() : BigDecimal.ZERO));
            data.setBalance(balance);
        }
        HashMap<String, List<ProjectDetailBillVO>> beans = new HashMap<String, List<ProjectDetailBillVO>>();
        beans.put("records", pageData);
        ExcelExport.getInstance().export("ProjectDetailBillReport-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/queryCostDetailReport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryCostDetailReport(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("supplierName", "invoiceCode"));
        JSONObject res = new JSONObject();
        QueryWrapper queryWrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<InvoiceReceivePoolVO> pageData = this.service.queryCostDetailReport((Page<InvoiceReceivePoolVO>)page, (QueryWrapper<InvoiceReceivePoolVO>)queryWrapper);
        res.put("records", pageData);
        res.put("total", (Object)page.getTotal());
        res.put("current", (Object)page.getCurrent());
        res.put("size", (Object)page.getSize());
        res.put("pages", (Object)page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    @RequestMapping(value={"/costDetailReportExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void costDetailReportExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("supplierName", "invoiceCode"));
        JSONObject res = new JSONObject();
        QueryWrapper queryWrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<InvoiceReceivePoolVO> pageData = this.service.queryCostDetailReport((Page<InvoiceReceivePoolVO>)page, (QueryWrapper<InvoiceReceivePoolVO>)queryWrapper);
        for (InvoiceReceivePoolVO pageDatum : pageData) {
            pageDatum.setPassFlagName(null != pageDatum.getPassFlag() && pageDatum.getPassFlag() == 1 ? "\u5408\u683c" : "\u4e0d\u5408\u683c");
        }
        HashMap<String, List<InvoiceReceivePoolVO>> beans = new HashMap<String, List<InvoiceReceivePoolVO>>();
        beans.put("records", pageData);
        ExcelExport.getInstance().export("CostDetailReport-export.xlsx", beans, response);
    }
}

