package com.ejianc.business.invest.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 项目投资-项目借款
 * 
 * @author generator
 * 
 */
 @TableName("ejc_invest_project_debt")
public class ProjectDebtEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目所属组织
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目所属组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目所属组织名称
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_receive_mny")
    private BigDecimal projectReceiveMny; // 项目回款
    @TableField(value="business_manager_id")
    private Long businessManagerId; // 业务经理
    @TableField(value="business_manager_name")
    private String businessManagerName; // 业务经理名称
    @TableField(value="manager_debt_mny")
    private BigDecimal managerDebtMny; // 业务经理名下项目借款
    @TableField(value="project_base_info")
    private String projectBaseInfo; // 项目基本信息
    @TableField(value="debt_info")
    private String debtInfo; // 借款事由
    @TableField(value="debt_mny")
    private BigDecimal debtMny; // 借款金额
    @TableField(value="debt_mny_str")
    private String debtMnyStr; // 借款金额大写
    @TableField(value="interest_type")
    private String interestType; // 计息方式：1-按月计息，2-按天计息，3-不收利息
    @TableField(value="interest_rate")
    private BigDecimal interestRate; // 按天计息为固定值，千分之一；按月计息时，下拉选则，1分，2分，3分，即每月1%，2%，3%利息；不收利息：按0计算
    @TableField(value="interest_rate_month")
    private String interestRateMonth; // 利率（按月计息），下拉选则，1-1分，2-2分，3-3分，即每月1%，2%，3%利息。
    @TableField(value="interest_start_date")
    private Date interestStartDate; // 利息开始日期
    @TableField(value="interest_end_date")
    private Date interestEndDate; // 预计还款日期
    @TableField(value="handle_date")
    private Date handleDate; // 办理日期
    @TableField(value="total_debt_mny")
    private BigDecimal totalDebtMny; // 累计借款金额（不含本次）
    @TableField(value="total_repayment_mny")
    private BigDecimal totalRepaymentMny; // 累计还款金额
    @TableField(value="total_debt_residue_mny")
    private BigDecimal totalDebtResidueMny; // 累计借款结余（累计借款本金-累计还款本金）
    @TableField(value="account_id")
    private Long accountId; // 收款账户
    @TableField(value="account_name")
    private String accountName; // 账户名
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="confirm_time")
    private Date confirmTime; // 经办时间
    @TableField(value="debt_person")
    private String debtPerson; // 借款人
    @TableField(value="income_person")
    private String incomePerson; // 实际收款人
    @TableField(value="contract_mny")
    private BigDecimal contractMny; // 合同金额(施工合同的合同金额)
    //借款单维度金额
    @TableField(value="bill_debt_mny")
    private BigDecimal billDebtMny; // 借款金额
    @TableField(value="bill_repayment_mny")
    private BigDecimal billRepaymentMny; // 还款金额
    @TableField(value="bill_debt_residue_mny")
    private BigDecimal billDebtResidueMny; // 借款结余（累计借款本金-累计还款本金）


    public BigDecimal getBillDebtMny() {
        return billDebtMny;
    }

    public void setBillDebtMny(BigDecimal billDebtMny) {
        this.billDebtMny = billDebtMny;
    }

    public BigDecimal getBillRepaymentMny() {
        return billRepaymentMny;
    }

    public void setBillRepaymentMny(BigDecimal billRepaymentMny) {
        this.billRepaymentMny = billRepaymentMny;
    }

    public BigDecimal getBillDebtResidueMny() {
        return billDebtResidueMny;
    }

    public void setBillDebtResidueMny(BigDecimal billDebtResidueMny) {
        this.billDebtResidueMny = billDebtResidueMny;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public BigDecimal getProjectReceiveMny() {
        return projectReceiveMny;
    }

    public void setProjectReceiveMny(BigDecimal projectReceiveMny) {
        this.projectReceiveMny = projectReceiveMny;
    }
    public Long getBusinessManagerId() {
        return businessManagerId;
    }

    public void setBusinessManagerId(Long businessManagerId) {
        this.businessManagerId = businessManagerId;
    }
    public String getBusinessManagerName() {
        return businessManagerName;
    }

    public void setBusinessManagerName(String businessManagerName) {
        this.businessManagerName = businessManagerName;
    }
    public BigDecimal getManagerDebtMny() {
        return managerDebtMny;
    }

    public void setManagerDebtMny(BigDecimal managerDebtMny) {
        this.managerDebtMny = managerDebtMny;
    }
    public String getProjectBaseInfo() {
        return projectBaseInfo;
    }

    public void setProjectBaseInfo(String projectBaseInfo) {
        this.projectBaseInfo = projectBaseInfo;
    }
    public String getDebtInfo() {
        return debtInfo;
    }

    public void setDebtInfo(String debtInfo) {
        this.debtInfo = debtInfo;
    }
    public BigDecimal getDebtMny() {
        return debtMny;
    }

    public void setDebtMny(BigDecimal debtMny) {
        this.debtMny = debtMny;
    }
    public String getDebtMnyStr() {
        return debtMnyStr;
    }

    public void setDebtMnyStr(String debtMnyStr) {
        this.debtMnyStr = debtMnyStr;
    }
    public String getInterestType() {
        return interestType;
    }

    public void setInterestType(String interestType) {
        this.interestType = interestType;
    }
    public BigDecimal getInterestRate() {
        return interestRate;
    }

    public void setInterestRate(BigDecimal interestRate) {
        this.interestRate = interestRate;
    }
    public String getInterestRateMonth() {
        return interestRateMonth;
    }

    public void setInterestRateMonth(String interestRateMonth) {
        this.interestRateMonth = interestRateMonth;
    }
    public Date getInterestStartDate() {
        return interestStartDate;
    }

    public void setInterestStartDate(Date interestStartDate) {
        this.interestStartDate = interestStartDate;
    }
    public Date getInterestEndDate() {
        return interestEndDate;
    }

    public void setInterestEndDate(Date interestEndDate) {
        this.interestEndDate = interestEndDate;
    }
    public Date getHandleDate() {
        return handleDate;
    }

    public void setHandleDate(Date handleDate) {
        this.handleDate = handleDate;
    }
    public BigDecimal getTotalDebtMny() {
        return totalDebtMny;
    }

    public void setTotalDebtMny(BigDecimal totalDebtMny) {
        this.totalDebtMny = totalDebtMny;
    }
    public BigDecimal getTotalRepaymentMny() {
        return totalRepaymentMny;
    }

    public void setTotalRepaymentMny(BigDecimal totalRepaymentMny) {
        this.totalRepaymentMny = totalRepaymentMny;
    }
    public BigDecimal getTotalDebtResidueMny() {
        return totalDebtResidueMny;
    }

    public void setTotalDebtResidueMny(BigDecimal totalDebtResidueMny) {
        this.totalDebtResidueMny = totalDebtResidueMny;
    }
    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }
    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(Date confirmTime) {
        this.confirmTime = confirmTime;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getDebtPerson() {
        return debtPerson;
    }

    public void setDebtPerson(String debtPerson) {
        this.debtPerson = debtPerson;
    }

    public String getIncomePerson() {
        return incomePerson;
    }

    public void setIncomePerson(String incomePerson) {
        this.incomePerson = incomePerson;
    }
}
