package com.ejianc.business.invest.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.finance.utils.BigDecimalUtil;
import com.ejianc.business.invest.bean.ProjectDebtEntity;
import com.ejianc.business.invest.service.IProjectDebtService;
import com.ejianc.business.project.bean.ProjectRegisterEntity;
import com.ejianc.business.project.service.IProjectRegisterService;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.invest.bean.ProjectRepaymentEntity;
import com.ejianc.business.invest.service.IProjectRepaymentService;
import com.ejianc.business.invest.vo.ProjectRepaymentVO;

/**
 * 项目投资-项目还款
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("projectRepayment")
public class ProjectRepaymentController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "BFYJ_XMTZ_XMHK";//此处需要根据实际修改

    @Autowired
    private IProjectRepaymentService service;
    @Autowired
    private IProjectDebtService projectDebtService;
    @Autowired
    private IProjectRegisterService projectRegisterService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProjectRepaymentVO> saveOrUpdate(@RequestBody ProjectRepaymentVO saveOrUpdateVO) {
    	ProjectRepaymentEntity entity = BeanMapper.map(saveOrUpdateVO, ProjectRepaymentEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	ProjectRepaymentVO vo = BeanMapper.map(entity, ProjectRepaymentVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProjectRepaymentVO> queryDetail(Long id) {
    	ProjectRepaymentEntity entity = service.selectById(id);
    	ProjectRepaymentVO vo = BeanMapper.map(entity, ProjectRepaymentVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProjectRepaymentVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ProjectRepaymentVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ProjectRepaymentVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProjectRepaymentVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("businessManagerName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));


        IPage<ProjectRepaymentEntity> page = service.queryPage(param,false);
        IPage<ProjectRepaymentVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProjectRepaymentVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("businessManagerName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ProjectRepaymentEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<ProjectRepaymentVO> voList = BeanMapper.mapList(list, ProjectRepaymentVO.class);
        voList.forEach(e -> {
            e.setBillStateName(BillStateEnum.getEnumByStateCode(e.getBillState()).getDescription());
        });
        beans.put("records", voList);
        ExcelExport.getInstance().export("ProjectRepayment-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refProjectRepaymentData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ProjectRepaymentVO>> refProjectRepaymentData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }


        IPage<ProjectRepaymentEntity> page = service.queryPage(param,false);
        IPage<ProjectRepaymentVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProjectRepaymentVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }


    /**
     * @Description 根据合同id查询借款单信息
     * @param
     * @Return void
     */
    @RequestMapping(value = "/queryProjectDebt", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProjectRepaymentVO> queryProjectDebt(Long projectId, Long projectDebtId) {
        ProjectRepaymentVO projectRepaymentVO = service.queryProjectDebt(projectId);
        List<ProjectRepaymentEntity> repaymentEntityList = service.list(new QueryWrapper<ProjectRepaymentEntity>().eq("project_debt_id", projectDebtId).notIn("bill_state", Arrays.asList(1, 3)));
        if (CollectionUtils.isNotEmpty(repaymentEntityList) && repaymentEntityList.size() > 0){
            return CommonResponse.error("当前借款单有未生效的还款单！", new ProjectRepaymentVO());
        }
        //业务经理名下项目借款赋值
        List<ProjectRegisterEntity> registerEntityList = projectRegisterService.list(new QueryWrapper<ProjectRegisterEntity>().eq("follow_person_id", projectRepaymentVO.getBusinessManagerId()));
        if (CollectionUtils.isNotEmpty(registerEntityList) && registerEntityList.size() > 0){
            List<Long> projectIds = registerEntityList.stream().map(ProjectRegisterEntity::getId).collect(Collectors.toList());
            List<ProjectDebtEntity> projectDebtEntityList = projectDebtService.list(new QueryWrapper<ProjectDebtEntity>().in("project_id", projectIds).in("bill_state", Arrays.asList(1, 3)));
            List<ProjectRepaymentEntity> projectRepaymentEntityList = service.list(new QueryWrapper<ProjectRepaymentEntity>().in("project_id", projectIds).in("bill_state", Arrays.asList(1, 3)).orderByDesc("handle_date"));
            if (CollectionUtils.isNotEmpty(projectDebtEntityList) && projectDebtEntityList.size() > 0){
                for (ProjectDebtEntity projectDebtEntity : projectDebtEntityList) {
                    if (null != projectDebtId && projectDebtId.longValue() == projectDebtEntity.getId().longValue()){
                        projectRepaymentVO.setBillDebtMny(projectDebtEntity.getDebtMny());
                        break;
                    }
                }
                BigDecimal managerDebtMny = projectDebtEntityList.stream().filter(p -> p.getDebtMny() != null).map(ProjectDebtEntity::getDebtMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (CollectionUtils.isNotEmpty(projectRepaymentEntityList) && projectRepaymentEntityList.size() > 0){
                    BigDecimal projectRepaymentMny = projectRepaymentEntityList.stream().filter(p -> p.getRepaymentCapitalMny() != null).map(ProjectRepaymentEntity::getRepaymentCapitalMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                    managerDebtMny = ComputeUtil.safeSub(managerDebtMny, projectRepaymentMny);
                    BigDecimal billLastRepaymentMny = projectRepaymentEntityList.stream().filter(e -> projectDebtId.equals(e.getProjectDebtId()) && e.getRepaymentCapitalMny() != null).map(ProjectRepaymentEntity::getRepaymentCapitalMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                    projectRepaymentVO.setBillLastRepaymentMny(billLastRepaymentMny);
                    projectRepaymentVO.setBillRepaymentMny(billLastRepaymentMny);
                    for (ProjectRepaymentEntity projectRepaymentEntity : projectRepaymentEntityList) {
                        if (null == projectRepaymentVO.getHandleDate() && projectDebtId.longValue() == projectRepaymentEntity.getProjectDebtId().longValue()){
                            projectRepaymentVO.setAllInterestMny(projectRepaymentEntity.getAllInterestMny());
                            projectRepaymentVO.setLastAllInterestMny(projectRepaymentEntity.getAllInterestMny());
                            projectRepaymentVO.setRemainInterestMny(projectRepaymentEntity.getRemainInterestMny());
                            projectRepaymentVO.setLastHandleDate(projectRepaymentEntity.getHandleDate());
                            break;
                        }
                    }
                }
                projectRepaymentVO.setBillDebtResidueMny(BigDecimalUtil.safeSub(projectRepaymentVO.getBillDebtMny(), null == projectRepaymentVO.getBillLastRepaymentMny() ? BigDecimal.ZERO : projectRepaymentVO.getBillLastRepaymentMny()));
                projectRepaymentVO.setManagerDebtMny(managerDebtMny);
            }
        }
        return CommonResponse.success("根据项目id查询借款单信息数据成功！", projectRepaymentVO);
    }
}
