/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.oa.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.oa.bean.EmployeeFormalEntity;
import com.ejianc.business.oa.bean.EmployeeIntoEntity;
import com.ejianc.business.oa.service.IEmployeeFormalService;
import com.ejianc.business.oa.service.IEmployeeIntoService;
import com.ejianc.business.warn.vo.WarningReceiveVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/warn/"})
public class WarnController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String EMPLOYEE_WARN_NAME = "\u5458\u5de5\u5165\u804c\u8bd5\u7528\u671f\u622a\u6b62\u65e5\u671f\u9884\u8b66";
    private static final String EMPLOYEE_FORMAL_WARN_NAME = "\u5458\u5de5\u5408\u540c\u5230\u671f\u65e5\u671f\u9884\u8b66";
    private static final String EMPLOYEE_URL = "/ejc-bfyjerp-frontend/#/employeeInto";
    private static final String EMPLOYEE_FORMAL_URL = "/ejc-bfyjerp-frontend/#/employeeFormal";
    @Autowired
    private IEmployeeIntoService employeeIntoService;
    @Autowired
    private IEmployeeFormalService employeeFormalService;
    @Autowired
    private IWarnCenterApi warnCenterApi;
    @Autowired
    private IEmployeeApi employeeApi;

    @PostMapping(value={"employeeIntoWarn"})
    public CommonResponse<String> employeeIntoWarn(@RequestBody JSONObject jsonParam) {
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonParam);
        List billParams = JSONArray.parseArray((String)jsonParam.getString("billParams"), JSONObject.class);
        this.logger.info("\u9884\u8b66\u53c2\u6570\u5217\u8868\uff1a{}", (Object)billParams);
        JSONObject defaultWarnInfo = JSON.parseObject((String)jsonParam.getString("defaultParam"));
        this.logger.info("\u9884\u8b66\u9ed8\u8ba4\u8bbe\u7f6e\uff1a{}", (Object)defaultWarnInfo);
        QueryParam param = new QueryParam();
        SimpleDateFormat sim = new SimpleDateFormat("yyyy-MM-dd");
        Date endDate = new Date();
        Date startDate = DateUtil.subDays((Date)endDate, (int)10);
        param.getParams().put("try_date", new Parameter("between", (Object)(sim.format(startDate) + "," + sim.format(DateUtil.addDays((Date)endDate, (int)1)))));
        param.getParams().put("bill_state", new Parameter("in", Arrays.asList(1, 3)));
        List entityList = this.employeeIntoService.queryList(param);
        if (CollectionUtils.isEmpty((Collection)entityList)) {
            this.logger.error("\u6267\u884c\u5458\u5de5\u5165\u804c\u8bd5\u7528\u671f\u622a\u6b62\u65e5\u671f\u9884\u8b66\u5b8c\u6210\uff0c\u672a\u53d1\u73b0\u6709\u5339\u914d\u9884\u8b66\u89c4\u5219\u7684\u5355\u636e\u4fe1\u606f\uff01");
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        this.logger.info("\u5458\u5de5\u5165\u804c\u8bd5\u7528\u671f\u622a\u6b62\u65e5\u671f\u9884\u8b66\u7684\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)entityList));
        ArrayList<EarlyWarnTransVO> resp = new ArrayList<EarlyWarnTransVO>();
        String tmpContent = null;
        for (EmployeeIntoEntity entity : entityList) {
            String warnLevel = defaultWarnInfo.getString("warnLevel");
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName(entity.getName());
            vo.setPcTitle("\u5458\u5de5\u5165\u804c\u5ba1\u6279");
            vo.setPcUrl(EMPLOYEE_URL);
            vo.setOrgId(entity.getOrgId());
            vo.setOrgName(entity.getOrgName());
            vo.setSourceId(entity.getId().toString());
            vo.setTenantId(Long.valueOf(999999L));
            vo.setWarnLevel(warnLevel);
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
            ArrayList<WarningReceiveVO> receiveList = new ArrayList<WarningReceiveVO>();
            WarningReceiveVO receiveVO = new WarningReceiveVO();
            CommonResponse employeeData = this.employeeApi.getByEmpmloyeeCode(entity.getCreateUserCode());
            if (employeeData.isSuccess()) {
                receiveVO.setName(((EmployeeVO)employeeData.getData()).getName());
                receiveVO.setNameId(((EmployeeVO)employeeData.getData()).getId());
            }
            receiveVO.setType("user");
            receiveList.add(receiveVO);
            vo.setReceiveList(receiveList);
            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            vo.setEarlywarnContent(tmpContent.replaceAll("#name#", entity.getName()));
            resp.add(vo);
        }
        return this.sendWarnToTaskWithReceive(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    @PostMapping(value={"employeeFormalWarn"})
    public CommonResponse<String> employeeFormalWarn(@RequestBody JSONObject jsonParam) {
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonParam);
        List billParams = JSONArray.parseArray((String)jsonParam.getString("billParams"), JSONObject.class);
        this.logger.info("\u9884\u8b66\u53c2\u6570\u5217\u8868\uff1a{}", (Object)billParams);
        JSONObject defaultWarnInfo = JSON.parseObject((String)jsonParam.getString("defaultParam"));
        this.logger.info("\u9884\u8b66\u9ed8\u8ba4\u8bbe\u7f6e\uff1a{}", (Object)defaultWarnInfo);
        QueryParam param = new QueryParam();
        SimpleDateFormat sim = new SimpleDateFormat("yyyy-MM-dd");
        Date endDate = new Date();
        Date startDate = DateUtil.subDays((Date)endDate, (int)45);
        param.getParams().put("contract_date_end", new Parameter("between", (Object)(sim.format(startDate) + "," + sim.format(DateUtil.addDays((Date)endDate, (int)1)))));
        param.getParams().put("bill_state", new Parameter("in", Arrays.asList(1, 3)));
        List entityList = this.employeeFormalService.queryList(param);
        if (CollectionUtils.isEmpty((Collection)entityList)) {
            this.logger.error("\u6267\u884c\u5458\u5de5\u5408\u540c\u5230\u671f\u65e5\u671f\u9884\u8b66\u5b8c\u6210\uff0c\u672a\u53d1\u73b0\u6709\u5339\u914d\u9884\u8b66\u89c4\u5219\u7684\u5355\u636e\u4fe1\u606f\uff01");
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        this.logger.info("\u5458\u5de5\u5408\u540c\u5230\u671f\u65e5\u671f\u9884\u8b66\u7684\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)entityList));
        ArrayList<EarlyWarnTransVO> resp = new ArrayList<EarlyWarnTransVO>();
        String tmpContent = null;
        for (EmployeeFormalEntity entity : entityList) {
            String warnLevel = defaultWarnInfo.getString("warnLevel");
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName(entity.getName());
            vo.setPcTitle("\u5458\u5de5\u5165\u804c\u5ba1\u6279");
            vo.setPcUrl(EMPLOYEE_FORMAL_URL);
            vo.setOrgId(entity.getOrgId());
            vo.setOrgName(entity.getOrgName());
            vo.setSourceId(entity.getId().toString());
            vo.setTenantId(Long.valueOf(999999L));
            vo.setWarnLevel(warnLevel);
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
            ArrayList<WarningReceiveVO> receiveList = new ArrayList<WarningReceiveVO>();
            WarningReceiveVO receiveVO = new WarningReceiveVO();
            CommonResponse employeeData = this.employeeApi.getByEmpmloyeeCode(entity.getCreateUserCode());
            if (employeeData.isSuccess()) {
                receiveVO.setName(((EmployeeVO)employeeData.getData()).getName());
                receiveVO.setNameId(((EmployeeVO)employeeData.getData()).getId());
            }
            receiveVO.setType("user");
            receiveList.add(receiveVO);
            vo.setReceiveList(receiveList);
            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            vo.setEarlywarnContent(tmpContent.replaceAll("#name#", entity.getName()));
            resp.add(vo);
        }
        return this.sendWarnToTaskWithReceive(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    private CommonResponse<String> sendWarnToTask(List<EarlyWarnTransVO> warnList, Long warnId) {
        this.logger.info("\u53d1\u9001\u4efb\u52a1\uff1a{}", (Object)JSONObject.toJSONString(warnList));
        CommonResponse warnResp = this.warnCenterApi.sendToWarnCenter(warnList, warnId);
        if (!warnResp.isSuccess()) {
            this.logger.error("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25\uff0c{}", (Object)warnResp.getMsg());
            return CommonResponse.error((String)("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25" + warnResp.getMsg()));
        }
        return CommonResponse.success((String)"\u4efb\u52a1\u63a5\u53d7\u5904\u7406\u6210\u529f\uff01");
    }

    private CommonResponse<String> sendWarnToTaskWithReceive(List<EarlyWarnTransVO> warnList, Long warnId) {
        this.logger.info("\u53d1\u9001\u4efb\u52a1\uff1a{}", (Object)JSONObject.toJSONString(warnList));
        CommonResponse warnResp = this.warnCenterApi.sendToWarnCenterWithReceive(warnList, warnId);
        if (!warnResp.isSuccess()) {
            this.logger.error("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25\uff0c{}", (Object)warnResp.getMsg());
            return CommonResponse.error((String)("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25" + warnResp.getMsg()));
        }
        return CommonResponse.success((String)"\u4efb\u52a1\u63a5\u53d7\u5904\u7406\u6210\u529f\uff01");
    }
}

