package com.ejianc.business.contract.utils;

import com.ejianc.framework.core.response.BillStateEnum;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @Author
 * @Date
 * @Description
 */

public enum BillCodeSetEnum {
    SUB_BILL_CODE(1,"SUB_BFYJ"),
    EQUI_BILL_CODE(2,"EQUI_BFYJ"),
    MATERIAL_BILL_CODE(3,"MATERIAL_BFYJ"),
    OTHER_BILL_CODE(4,"OTHER_BFYJ"),
    INCOME_BILL_CODE(5,"INCOME_BFYJ");


    private Integer contractType;

    private String billCode;

    private static Map<Integer, BillCodeSetEnum> enumMap = new HashMap<>();
    //构造方法
    private BillCodeSetEnum(Integer contractType, String billCode ){
        this.contractType = contractType;
        this.billCode = billCode;
    }

    public Integer getContractType() {
        return contractType;
    }

    public void setContractType(Integer contractType) {
        this.contractType = contractType;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    static {
        enumMap = EnumSet.allOf(BillCodeSetEnum.class).stream().collect(Collectors.toMap(BillCodeSetEnum::getContractType, Function.identity(), (k1, k2) -> k2));
    }

    public static BillCodeSetEnum getEnumByContractType(Integer contractType) {
        return enumMap.get(contractType);
    }
}
