/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.bid.bean.BusOpportunityEntity;
import com.ejianc.business.bid.mapper.BusOpportunityMapper;
import com.ejianc.business.bid.service.IBusOpportunityService;
import com.ejianc.business.bid.vo.BusOpportunityVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="busOpportunityService")
public class BusOpportunityServiceImpl
extends BaseServiceImpl<BusOpportunityMapper, BusOpportunityEntity>
implements IBusOpportunityService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String PC_URL = "/ejc-bfyjerp-frontend/#/busOpportunity/card?id=";
    @Autowired
    private IPushMessageApi pushMessageApi;

    @Override
    public List<BusOpportunityEntity> getAllByRegistrationId(Long registrationId, Long id) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        if (null != registrationId) {
            query.eq((Object)"registration_id", (Object)registrationId);
        }
        if (null != id) {
            query.ne((Object)"id", (Object)id);
        }
        return super.list((Wrapper)query);
    }

    @Override
    public List<BusOpportunityVO> getAllUnQuoteBill() {
        List<Object> resp = new ArrayList<BusOpportunityVO>();
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.in((Object)"bill_state", (Object[])new Integer[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        query.eq((Object)"report_quote_flag", (Object)"0");
        List dbList = super.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)dbList)) {
            resp = BeanMapper.mapList((Iterable)dbList, BusOpportunityVO.class);
        }
        return resp;
    }

    @Override
    public void updateQuoteFlag(List<Long> updateOpprIds, String quoteFlag) {
        UpdateWrapper update = new UpdateWrapper();
        update.in((Object)"id", updateOpprIds);
        update.set((Object)"report_quote_flag", (Object)quoteFlag);
        update.set((Object)"update_time", (Object)new Date());
        update.set((Object)"update_user_code", (Object)InvocationInfoProxy.getUsercode());
        super.update((Wrapper)update);
    }

    @Override
    public void sendMsgToDocumenter(BusOpportunityEntity entity) {
        this.logger.info("\u5f00\u59cb\u7ed9\u8d44\u6599\u5458\u53d1\u9001\u6d88\u606f\uff1a----");
        String msg = this.sendMsg(entity, "\u8d44\u6599\u5458\u786e\u8ba4", entity.getEngineeringName() + "\uff0c\u9879\u76ee\u62a5\u540d\uff01\u8bf7\u786e\u8ba4\uff01");
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            this.logger.error("\u5f00\u59cb\u7ed9\u8d44\u6599\u5458\u53d1\u9001\u6d88\u606f\u5f02\u5e38\uff1a" + msg);
        }
        this.logger.info("\u5f00\u59cb\u7ed9\u8d44\u6599\u5458\u53d1\u9001\u6d88\u606f\u7ed3\u675f\uff01");
    }

    private String sendMsg(BusOpportunityEntity entity, String subject, String content) {
        Object[] msgRecUserIds = new String[]{entity.getDocumenterId().toString()};
        this.logger.info("\u6d88\u606f\u63a5\u6536\u4eba: {}", (Object)StringUtils.join((Object[])msgRecUserIds, (String)","));
        PushMsgParameter msgParameter = new PushMsgParameter();
        msgParameter.setReceivers((String[])msgRecUserIds);
        msgParameter.setContent(content);
        msgParameter.setSubject(content);
        msgParameter.setMsgType("notice");
        msgParameter.setTenantId(entity.getTenantId().toString());
        msgParameter.setSaveFlag(true);
        msgParameter.setSendUserId(InvocationInfoProxy.getUserid());
        msgParameter.setChannel(new String[]{"sys"});
        msgParameter.setPcUrl(PC_URL + entity.getId());
        CommonResponse msgSendResp = this.pushMessageApi.pushMessage(msgParameter);
        if (!msgSendResp.isSuccess()) {
            return msgSendResp.getMsg();
        }
        return null;
    }
}

