package com.ejianc.business.bid.service.impl;

import com.ejianc.business.bid.bean.ProjectRegistrationEntity;
import com.ejianc.business.bid.service.IProjectRegistrationService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.Map;

@Service("projectRegistration") 
public class ProjectRegistrationBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IProjectRegistrationService service;

	@Autowired
	private SessionManager sessionManager;

	@Autowired
	private IBillTypeApi billTypeApi;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		ProjectRegistrationEntity e = service.selectById(billId);
		e.setCommitDate(new Date());
		e.setCommitUserCode(InvocationInfoProxy.getUsercode());
		e.setCommitUserCode(sessionManager.getUserContext().getUserName());
		service.saveOrUpdate(e, false);
		return CommonResponse.success("提交审批回调处理成功！");
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return doBack(billId, state, billTypeCode);
	}

	public CommonResponse<String> doBack(Long billId, Integer state, String billTypeCode) {
		logger.info("项目报名单据billId-{}, state-{}, billTypeCode-{}撤回事件处理", billId, state, billTypeCode);

		CommonResponse<String> checkCommonResponse = billTypeApi.checkQuote(billTypeCode, billId);
		boolean success = checkCommonResponse.isSuccess();
		if (!success){
			return CommonResponse.error("项目报名已发生下游业务,不能弃审和撤回");
		}

		ProjectRegistrationEntity e = service.selectById(billId);
		e.setCommitDate(null);
		e.setCommitUserCode(null);
		e.setCommitUserCode(null);
		e.setEffectiveDate(null);
		service.saveOrUpdate(e, false);

		return CommonResponse.success("审批回退回调查成功！");
	}

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		ProjectRegistrationEntity e = service.selectById(billId);
		if(BillStateEnum.COMMITED_STATE.getBillStateCode().equals(state)) {
			e.setCommitDate(new Date());
			e.setCommitUserCode(InvocationInfoProxy.getUsercode());
			e.setCommitUserCode(sessionManager.getUserContext().getUserName());
		}

		//设置生效时间
		e.setEffectiveDate(new Date());

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return doBack(billId, state, billTypeCode);
	}

}
