/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bid.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bid.service.ICALockDetailService;
import com.ejianc.business.bid.vo.CALockDetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"cALockDetail"})
public class CALockDetailController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ICALockDetailService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    public CommonResponse<IPage<CALockDetailVO>> queryList(@RequestBody QueryParam param) {
        Page page = null;
        HashMap<String, Object> params = new HashMap<String, Object>();
        Iterator iterator = param.getParams().keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = (String)iterator.next()) {
                case "handleTime": 
                case "endTime": {
                    params.put(key + "Start", ((Parameter)param.getParams().get(key)).getValue().toString().split(",")[0] + " 00:00:00");
                    params.put(key + "End", ((Parameter)param.getParams().get(key)).getValue().toString().split(",")[1] + " 23:59:59");
                    break;
                }
                case "lockTypes": {
                    params.put(key + "End", ((Parameter)param.getParams().get(key)).getValue().toString().split(","));
                    break;
                }
                default: {
                    params.put(key, ((Parameter)param.getParams().get(key)).getValue());
                }
            }
            if (!"handleTime".equals(key)) continue;
        }
        params.put("searchText", param.getSearchText());
        params.put("pageSize", param.getPageSize());
        params.put("startLine", param.getPageIndex() < 1 ? 0 : (param.getPageIndex() - 1) * param.getPageSize());
        Long count = this.service.countDetail(params);
        if (count == 0L) {
            page = new Page((long)param.getPageIndex(), (long)param.getPageSize(), 0L);
            page.setRecords(new ArrayList());
            return CommonResponse.success((Object)page);
        }
        List<CALockDetailVO> detailList = this.service.pageList(params);
        page = new Page((long)param.getPageIndex(), (long)param.getPageSize(), count.longValue());
        page.setRecords(detailList);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("acc");
        fuzzyFields.add("pwd");
        fuzzyFields.add("keerper");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        HashMap<String, Object> params = new HashMap<String, Object>();
        Iterator iterator = param.getParams().keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = (String)iterator.next()) {
                case "handleTime": 
                case "endTime": {
                    params.put(key + "Start", ((Parameter)param.getParams().get(key)).getValue().toString().split(",")[0] + " 00:00:00");
                    params.put(key + "End", ((Parameter)param.getParams().get(key)).getValue().toString().split(",")[1] + " 23:59:59");
                    break;
                }
                case "lockTypes": {
                    params.put(key + "End", ((Parameter)param.getParams().get(key)).getValue().toString().split(","));
                    break;
                }
                default: {
                    params.put(key, ((Parameter)param.getParams().get(key)).getValue());
                }
            }
            if (!"handleTime".equals(key)) continue;
        }
        params.put("searchText", param.getSearchText());
        List<CALockDetailVO> detailList = this.service.pageList(params);
        HashMap<String, List<CALockDetailVO>> beans = new HashMap<String, List<CALockDetailVO>>();
        beans.put("records", detailList);
        ExcelExport.getInstance().export("CALockDetail-export.xlsx", beans, response);
    }
}

