/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.oa.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.oa.bean.PayrollEntity;
import com.ejianc.business.oa.mapper.PayrollMapper;
import com.ejianc.business.oa.service.IEmployeeIntoService;
import com.ejianc.business.oa.service.IPayrollService;
import com.ejianc.business.oa.vo.EmployeeIntoVO;
import com.ejianc.business.oa.vo.PayrollDetailImportVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.Period;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="payrollService")
public class PayrollServiceImpl
extends BaseServiceImpl<PayrollMapper, PayrollEntity>
implements IPayrollService {
    @Autowired
    private IEmployeeIntoService employeeIntoService;

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        ArrayList<PayrollDetailImportVO> successList = new ArrayList<PayrollDetailImportVO>();
        ArrayList<PayrollDetailImportVO> errorList = new ArrayList<PayrollDetailImportVO>();
        if (result != null && result.size() > 0) {
            if (result.size() >= 1000) {
                throw new BusinessException("\u6587\u4ef6\u6570\u636e\u4e0d\u80fd\u8d85\u8fc71000\u884c\uff0c\u8d85\u8fc7\u8bf7\u5206\u6279\u6b21\u591a\u6b21\u5bfc\u5165");
            }
            List<EmployeeIntoVO> employeeList = this.employeeIntoService.queryEmployeeData();
            if (CollectionUtils.isEmpty(employeeList)) {
                throw new BusinessException("\u8bf7\u6dfb\u52a0\u5165\u804c\u7533\u8bf7\u4eba\u5458\uff01");
            }
            Map<String, EmployeeIntoVO> employeeMap = employeeList.stream().collect(Collectors.toMap(e -> e.getIdCard(), e -> e));
            for (int i = 3; i < result.size() - 1; ++i) {
                StringBuilder errorMessage = new StringBuilder();
                List datas = (List)result.get(i);
                PayrollDetailImportVO importVO = new PayrollDetailImportVO();
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                    errorMessage.append("[\u8eab\u4efd\u8bc1\u53f7\u4e3a\u5fc5\u586b\u9879]");
                } else {
                    if (((String)datas.get(1)).length() > 200) {
                        importVO.setErrorMessage("\u586b\u5199\u8eab\u4efd\u8bc1\u53f7\u957f\u5ea6\u4e3a1~200\u5b57");
                    }
                    if (!employeeMap.containsKey(((String)datas.get(1)).trim())) continue;
                    EmployeeIntoVO employeeIntoVO = employeeMap.get(((String)datas.get(1)).trim());
                    importVO = (PayrollDetailImportVO)BeanMapper.map((Object)employeeIntoVO, PayrollDetailImportVO.class);
                    importVO.setEmployeeId(employeeIntoVO.getId());
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(8)))) {
                    importVO.setSalaryTime(new BigDecimal(((String)datas.get(8)).trim()));
                }
                BigDecimal noClockTime = BigDecimal.ZERO;
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(17)))) {
                    noClockTime = ComputeUtil.safeAdd((BigDecimal)new BigDecimal(((String)datas.get(17)).trim()), (BigDecimal)noClockTime);
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(18)))) {
                    noClockTime = ComputeUtil.safeAdd((BigDecimal)new BigDecimal(((String)datas.get(18)).trim()), (BigDecimal)noClockTime);
                }
                importVO.setNoClockTime(noClockTime);
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(19)))) {
                    importVO.setAbsenteeTime(ComputeUtil.safeMultiply((BigDecimal)new BigDecimal(((String)datas.get(19)).trim()), (BigDecimal)new BigDecimal(8)));
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(22)))) {
                    importVO.setThingTime(new BigDecimal(((String)datas.get(22)).trim()));
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(24)))) {
                    importVO.setIllnessTime(new BigDecimal(((String)datas.get(24)).trim()));
                }
                BigDecimal marryTime = BigDecimal.ZERO;
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(26)))) {
                    marryTime = ComputeUtil.safeAdd((BigDecimal)new BigDecimal(((String)datas.get(26)).trim()), (BigDecimal)marryTime);
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(28)))) {
                    marryTime = ComputeUtil.safeAdd((BigDecimal)new BigDecimal(((String)datas.get(28)).trim()), (BigDecimal)marryTime);
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(30)))) {
                    marryTime = ComputeUtil.safeAdd((BigDecimal)new BigDecimal(((String)datas.get(30)).trim()), (BigDecimal)marryTime);
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(31)))) {
                    marryTime = ComputeUtil.safeAdd((BigDecimal)new BigDecimal(((String)datas.get(31)).trim()), (BigDecimal)marryTime);
                }
                importVO.setMarryTime(ComputeUtil.safeAdd((BigDecimal)marryTime, (BigDecimal[])new BigDecimal[0]));
                importVO.setYearSalary(this.calYearSalary(importVO.getFormalDate(), importVO.getRank()));
                BigDecimal basicSalary = ComputeUtil.safeAdd((BigDecimal)importVO.getBasicSalary(), (BigDecimal[])new BigDecimal[]{importVO.getPostSalary(), importVO.getLevelSalary(), importVO.getSportSalary(), importVO.getYearSalary()});
                if (null != importVO.getSalaryTime() && importVO.getSalaryTime().compareTo(BigDecimal.ZERO) > 0) {
                    BigDecimal hourSalary = ComputeUtil.safeDiv((BigDecimal)basicSalary, (BigDecimal)importVO.getSalaryTime()).setScale(2, 4);
                    if (null != importVO.getThingTime() && importVO.getThingTime().compareTo(BigDecimal.ZERO) > 0) {
                        importVO.setThingTimeDeduct(ComputeUtil.safeMultiply((BigDecimal)hourSalary, (BigDecimal)importVO.getThingTime()).setScale(2, 4));
                    }
                    if (null != importVO.getAbsenteeTime() && importVO.getAbsenteeTime().compareTo(BigDecimal.ZERO) > 0) {
                        importVO.setAbsenteeTimeDeduct(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)hourSalary, (BigDecimal)new BigDecimal(3)), (BigDecimal)importVO.getAbsenteeTime()).setScale(2, 4));
                    }
                    if (null != importVO.getNoClockTime() && importVO.getNoClockTime().compareTo(BigDecimal.ZERO) > 0) {
                        importVO.setNoClockTimeDeduct(ComputeUtil.safeMultiply((BigDecimal)hourSalary, (BigDecimal)new BigDecimal(3)).setScale(2, 4));
                    }
                    if (null != importVO.getIllnessTime() && importVO.getIllnessTime().compareTo(BigDecimal.ZERO) > 0) {
                        hourSalary = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeSub((BigDecimal)basicSalary, (BigDecimal)importVO.getBasicSalary()), (BigDecimal)importVO.getSalaryTime()).setScale(2, 4);
                        importVO.setIllnessTimeDeduct(ComputeUtil.safeMultiply((BigDecimal)hourSalary, (BigDecimal)importVO.getIllnessTime()).setScale(2, 4));
                    }
                    if (null != importVO.getMarryTime() && importVO.getMarryTime().compareTo(BigDecimal.ZERO) > 0) {
                        hourSalary = ComputeUtil.safeDiv((BigDecimal)importVO.getSportSalary(), (BigDecimal)importVO.getSalaryTime()).setScale(2, 4);
                        importVO.setMarryTimeDeduct(ComputeUtil.safeMultiply((BigDecimal)hourSalary, (BigDecimal)importVO.getMarryTime()).setScale(2, 4));
                    }
                    importVO.setAttendanceDeduct(ComputeUtil.safeAdd((BigDecimal)importVO.getThingTimeDeduct(), (BigDecimal[])new BigDecimal[]{importVO.getIllnessTimeDeduct(), importVO.getMarryTimeDeduct(), importVO.getAbsenteeTimeDeduct(), importVO.getNoClockTimeDeduct()}));
                }
                importVO.setSalaryMny(ComputeUtil.safeSub((BigDecimal)ComputeUtil.safeAdd((BigDecimal)importVO.getBasicSalary(), (BigDecimal[])new BigDecimal[]{importVO.getPostSalary(), importVO.getLevelSalary(), importVO.getSportSalary(), importVO.getYearSalary(), importVO.getEducatedSalary()}), (BigDecimal)importVO.getAttendanceDeduct()));
                importVO.setActualSalaryMny(ComputeUtil.safeSub((BigDecimal)importVO.getSalaryMny(), (BigDecimal[])new BigDecimal[]{importVO.getEndownmentPersonMny(), importVO.getUnemployeePersonMny(), importVO.getBaseMedicalPersonMny()}));
                importVO.setId(Long.valueOf(IdWorker.getId()));
                if (StringUtils.isBlank((CharSequence)errorMessage)) {
                    successList.add(importVO);
                    continue;
                }
                importVO.setErrorMessage(String.valueOf(errorMessage));
                errorList.add(importVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }

    private BigDecimal calYearSalary(Date formalDate, Integer rank) {
        BigDecimal yearSalary = BigDecimal.ZERO;
        int year = formalDate.getYear() + 1900;
        int month = formalDate.getMonth() + 1;
        if (month == 12) {
            ++year;
            month = 1;
        } else {
            ++month;
        }
        Period period = Period.between(LocalDate.of(year, month, 1), LocalDate.now());
        int yearNum = period.getYears();
        if (yearNum < 1) {
            return yearSalary;
        }
        switch (yearNum) {
            case 1: {
                yearSalary = rank == 3 ? new BigDecimal(200) : new BigDecimal(250);
                break;
            }
            case 2: {
                yearSalary = rank == 3 ? new BigDecimal(150) : new BigDecimal(200);
                break;
            }
            case 3: {
                yearSalary = rank == 3 ? new BigDecimal(100) : new BigDecimal(150);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                yearSalary = rank == 3 ? new BigDecimal(50) : new BigDecimal(100);
                break;
            }
            case 8: {
                yearSalary = rank == 3 ? new BigDecimal(100) : new BigDecimal(150);
                break;
            }
            case 9: {
                yearSalary = rank == 3 ? new BigDecimal(150) : new BigDecimal(200);
                break;
            }
            case 10: {
                yearSalary = rank == 3 ? new BigDecimal(20) : new BigDecimal(250);
                break;
            }
            default: {
                yearSalary = rank == 3 ? new BigDecimal(20) : new BigDecimal(250);
            }
        }
        return yearSalary;
    }
}

