/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tax.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.bean.PayContractEntity;
import com.ejianc.business.finance.bean.PayMigrantEntity;
import com.ejianc.business.finance.bean.PaySporadicEntity;
import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.business.finance.service.IPayMigrantService;
import com.ejianc.business.finance.service.IPaySporadicService;
import com.ejianc.business.tax.bean.InvoiceReceiveRegistEntity;
import com.ejianc.business.tax.service.IInvoiceReceivePoolService;
import com.ejianc.business.tax.service.IInvoiceReceiveRegistService;
import com.ejianc.business.tax.vo.InvoiceReceiveRegistVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"invoiceReceiveRegist"})
public class InvoiceReceiveRegistController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IInvoiceReceiveRegistService service;
    @Autowired
    private IInvoiceReceivePoolService invoiceReceivePoolService;
    @Autowired
    private IPaySporadicService paySporadicService;
    @Autowired
    private IPayContractService payContractService;
    @Autowired
    private IPayMigrantService payMigrantService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<InvoiceReceiveRegistVO> saveOrUpdate(@RequestBody InvoiceReceiveRegistVO saveOrUpdateVO) {
        InvoiceReceiveRegistEntity entity = (InvoiceReceiveRegistEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, InvoiceReceiveRegistEntity.class));
        this.service.insertOrUpdate(entity);
        InvoiceReceiveRegistVO vo = (InvoiceReceiveRegistVO)BeanMapper.map((Object)((Object)entity), InvoiceReceiveRegistVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryMnyByProjectAndSupplierId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<InvoiceReceiveRegistVO> queryMnyByProjectAndSupplierId(Long projectId, Long supplierId) {
        List payMigrantList;
        List payContractList;
        InvoiceReceiveRegistVO invoiceOpenRegistVO = new InvoiceReceiveRegistVO();
        BigDecimal sumPayMny = BigDecimal.ZERO;
        LambdaQueryWrapper lambdaWrapper = new LambdaQueryWrapper();
        lambdaWrapper.in(PaySporadicEntity::getBillState, new Object[]{1, 3});
        lambdaWrapper.eq(PaySporadicEntity::getProjectId, (Object)projectId);
        lambdaWrapper.eq(PaySporadicEntity::getSupplyId, (Object)supplierId);
        List daypayEntityList = this.paySporadicService.list((Wrapper)lambdaWrapper);
        if (CollectionUtils.isNotEmpty((Collection)daypayEntityList)) {
            sumPayMny = daypayEntityList.stream().filter(s -> s.getApplyMny() != null).map(PaySporadicEntity::getApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        if (CollectionUtils.isNotEmpty((Collection)(payContractList = this.payContractService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().in((Object)"bill_state", Arrays.asList(1, 3))).eq((Object)"project_id", (Object)projectId)).eq((Object)"supplier_id", (Object)supplierId)))) && payContractList.size() > 0) {
            sumPayMny = ComputeUtil.safeAdd((BigDecimal)sumPayMny, (BigDecimal)payContractList.stream().filter(s -> s.getApplyMny() != null).map(PayContractEntity::getApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add));
        }
        if (CollectionUtils.isNotEmpty((Collection)(payMigrantList = this.payMigrantService.list((Wrapper)((QueryWrapper)new QueryWrapper().in((Object)"bill_state", Arrays.asList(1, 3))).eq((Object)"project_id", (Object)projectId)))) && payMigrantList.size() > 0) {
            sumPayMny = ComputeUtil.safeAdd((BigDecimal)sumPayMny, (BigDecimal)payMigrantList.stream().filter(s -> s.getApplyMny() != null).map(PayMigrantEntity::getApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add));
        }
        invoiceOpenRegistVO.setSumPayMny(sumPayMny);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)invoiceOpenRegistVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<InvoiceReceiveRegistVO> queryDetail(Long id) {
        InvoiceReceiveRegistEntity entity = (InvoiceReceiveRegistEntity)((Object)this.service.selectById(id));
        InvoiceReceiveRegistVO vo = (InvoiceReceiveRegistVO)BeanMapper.map((Object)((Object)entity), InvoiceReceiveRegistVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InvoiceReceiveRegistVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (InvoiceReceiveRegistVO invoiceReceiveRegistVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<InvoiceReceiveRegistVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("projectName", "code"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), InvoiceReceiveRegistVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("projectName", "code"));
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        if ("1".equals(((Parameter)param.getParams().get("projectFlag")).getValue().toString())) {
            ExcelExport.getInstance().exportWithTrans("InvoiceReceiveRegist-export.xlsx", beans, response);
        } else {
            ExcelExport.getInstance().exportWithTrans("InvoiceReceiveRegistOrg-export.xlsx", beans, response);
        }
    }

    @RequestMapping(value={"/queryTotalReceiveMnyBySupplierId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BigDecimal> queryTotalReceiveMnyBySupplierId(@RequestParam(value="supplierId", required=true) Long supplierId, @RequestParam(value="id", required=false) Long id) {
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)lambdaQueryWrapper.eq(InvoiceReceiveRegistEntity::getSellerId, (Object)supplierId)).eq(BaseEntity::getDr, (Object)0)).ne(id != null, BaseEntity::getId, (Object)id)).in(InvoiceReceiveRegistEntity::getBillState, new Object[]{1, 3});
        List list = this.service.list((Wrapper)lambdaQueryWrapper);
        BigDecimal sumMny = list.stream().map(InvoiceReceiveRegistEntity::getCurrentReceiveMnyTax).reduce(BigDecimal.ZERO, BigDecimal::add);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)sumMny);
    }

    @RequestMapping(value={"/refInvoiceReceiveRegistData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<InvoiceReceiveRegistVO>> refInvoiceReceiveRegistData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), InvoiceReceiveRegistVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryInvoiceReceiveRegisterByProjectBillId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryInvoiceReceiveRegisterByProjectBillId(@RequestParam Long projectBillId) {
        JSONObject returnObject = new JSONObject();
        List invoiceReceiveRegisterIdList = this.service.list((Wrapper)new QueryWrapper().eq((Object)"project_bill_id", (Object)projectBillId));
        if (CollectionUtils.isNotEmpty((Collection)invoiceReceiveRegisterIdList) && invoiceReceiveRegisterIdList.size() > 0) {
            returnObject.put("detailList", (Object)invoiceReceiveRegisterIdList);
            List detailList = this.invoiceReceivePoolService.list((Wrapper)new QueryWrapper().in((Object)"receive_bill_id", (Collection)invoiceReceiveRegisterIdList.stream().map(BaseEntity::getId).collect(Collectors.toList())));
            List passList = detailList.stream().filter(p -> p.getPassFlag() != null && 1 == p.getPassFlag()).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(passList) && passList.size() > 0) {
                returnObject.put("specialDetailList", passList.stream().filter(p -> p.getInvoiceType() != null && "1853691016918339586".equals(String.valueOf(p.getInvoiceType()))).collect(Collectors.toList()));
                returnObject.put("commonDetailList", passList.stream().filter(p -> p.getInvoiceType() != null && "1853691041769590785".equals(String.valueOf(p.getInvoiceType()))).collect(Collectors.toList()));
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)returnObject);
    }
}

