package com.ejianc.business.cost.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cost.service.IProjectBillService;
import com.ejianc.business.cost.vo.ProjectDetailBillVO;
import com.ejianc.business.finance.bean.PayContractEntity;
import com.ejianc.business.finance.bean.PaySporadicEntity;
import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.business.finance.service.IPaySporadicService;
import com.ejianc.business.project.bean.ProjectRegisterEntity;
import com.ejianc.business.project.service.IProjectRegisterService;
import com.ejianc.business.tax.vo.InvoiceReceivePoolVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.bouncycastle.asn1.cmc.PKIData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;


/**
 * 成本会计-项目明细账
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("projectCost")
public class ProjectCostController implements Serializable {
	private static final long serialVersionUID = 1L;

    @Autowired
    private IProjectRegisterService projectRegisterService;

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IProjectBillService service;

    @Autowired
    private IPayContractService payContractService;

    @Autowired
    private IPaySporadicService paySporadicService;



    @Autowired
    private IProjectRegisterService registerService;

    /**
     * @Description queryProjectDetailBill 查询项目明细账
     * @param param
     */
    @RequestMapping(value = "/queryProjectDetailBill", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryProjectDetailBill(@RequestBody QueryParam param) {
        param.setPageIndex(1);
        param.setPageSize(100);
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
//        param.getOrderMap().put("date", QueryParam.ASC);
        JSONObject res = new JSONObject();
        if (null == param.getParams().get("projectId")){
            return CommonResponse.success("查询列表数据成功！",res);
        }
        Long projectId = Long.valueOf(param.getParams().get("projectId").getValue().toString());


        ProjectRegisterEntity projectRegisterEntity = registerService.selectById(projectId);


        QueryWrapper<ProjectDetailBillVO> queryWrapper = changeToQueryWrapper(param);
        Page<ProjectDetailBillVO> page = new Page<>((long)param.getPageIndex(), (long)param.getPageSize());
        List<ProjectDetailBillVO> pageData = service.pageList(page, queryWrapper);
        BigDecimal balance = BigDecimal.ZERO;
        for (ProjectDetailBillVO data : pageData) {
            data.setId(IdWorker.getId());
            balance = ComputeUtil.safeSub(ComputeUtil.safeAdd(null != data.getReceiveMny() ? data.getReceiveMny() : BigDecimal.ZERO, balance), null != data.getPaymentMny() ? data.getPaymentMny() : BigDecimal.ZERO);
            data.setBalance(balance);
        }


        res.put("records", pageData);
        res.put("total", page.getTotal());
        res.put("current", page.getCurrent());
        res.put("size", page.getSize());
        res.put("pages", page.getPages());
        res.put("collectionTypeName", projectRegisterEntity.getCollectionTypeName());
        res.put("contractMny", projectRegisterEntity.getBidMny());
        res.put("balance", null != pageData && pageData.size() > 1 ? pageData.get(pageData.size() - 1).getBalance() : BigDecimal.ZERO);

        return CommonResponse.success("查询列表数据成功！",res);
    }



    /**
     * @Description 报表导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/projectDetailBillExport", method = RequestMethod.POST)
    @ResponseBody
    public void projectDetailBillExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();

        QueryWrapper<ProjectDetailBillVO> queryWrapper = changeToQueryWrapper(param);
        Page<ProjectDetailBillVO> page = new Page<>((long)param.getPageIndex(), (long)param.getPageSize());
        List<ProjectDetailBillVO> pageData = service.pageList(page, queryWrapper);
        BigDecimal balance = BigDecimal.ZERO;
        for (ProjectDetailBillVO data : pageData) {
            data.setId(IdWorker.getId());
            balance = ComputeUtil.safeSub(ComputeUtil.safeAdd(null != data.getReceiveMny() ? data.getReceiveMny() : BigDecimal.ZERO, balance), null != data.getPaymentMny() ? data.getPaymentMny() : BigDecimal.ZERO);
            data.setBalance(balance);
        }

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", pageData);
        ExcelExport.getInstance().export("ProjectDetailBillReport-export.xlsx", beans, response);
    }



    /**
     * @Description queryCostDetailReport 查询成本明细账
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryCostDetailReport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryCostDetailReport(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("supplierName","invoiceCode"));
//        param.getOrderMap().put("date", QueryParam.ASC);
        JSONObject res = new JSONObject();

        QueryWrapper<InvoiceReceivePoolVO> queryWrapper = changeToQueryWrapper(param);
        Page<InvoiceReceivePoolVO> page = new Page<>((long)param.getPageIndex(), (long)param.getPageSize());
        List<InvoiceReceivePoolVO> pageData = service.queryCostDetailReport(page, queryWrapper);


        res.put("records", pageData);
        res.put("total", page.getTotal());
        res.put("current", page.getCurrent());
        res.put("size", page.getSize());
        res.put("pages", page.getPages());

        return CommonResponse.success("查询列表数据成功！",res);
    }


    /**
     * @Description 报表导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/costDetailReportExport", method = RequestMethod.POST)
    @ResponseBody
    public void costDetailReportExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("supplierName","invoiceCode"));
//        param.getOrderMap().put("date", QueryParam.ASC);
        JSONObject res = new JSONObject();

        QueryWrapper<InvoiceReceivePoolVO> queryWrapper = changeToQueryWrapper(param);
        Page<InvoiceReceivePoolVO> page = new Page<>((long)param.getPageIndex(), (long)param.getPageSize());
        List<InvoiceReceivePoolVO> pageData = service.queryCostDetailReport(page, queryWrapper);
        for (InvoiceReceivePoolVO pageDatum : pageData) {
            pageDatum.setPassFlagName(null != pageDatum.getPassFlag() && pageDatum.getPassFlag() == 1 ? "合格" : "不合格");
        }

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", pageData);
        ExcelExport.getInstance().export("CostDetailReport-export.xlsx", beans, response);
    }


    /**
     * 查询项目剩余可用金额
     * @param projectId
     * @return
     */
    @RequestMapping(value = "/queryProjectLeaveMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryProjectLeaveMny(Long projectId, Long payContractId, Long paySporadicId) {
        QueryParam param = new QueryParam();
        param.setPageIndex(1);
        param.setPageSize(100);
        /** 模糊搜索配置字段示例 */
        param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        JSONObject res = new JSONObject();
        QueryWrapper<ProjectDetailBillVO> queryWrapper = changeToQueryWrapper(param);
        Page<ProjectDetailBillVO> page = new Page<>((long)param.getPageIndex(), (long)param.getPageSize());
        List<ProjectDetailBillVO> pageData = service.pageList(page, queryWrapper);
        pageData = pageData.stream().filter(e -> null != e.getFeeType() && 0 == e.getFeeType()).collect(Collectors.toList());
        BigDecimal balance = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(pageData) && pageData.size() > 0){
            for (ProjectDetailBillVO data : pageData) {
                balance = ComputeUtil.safeSub(ComputeUtil.safeAdd(null != data.getReceiveMny() ? data.getReceiveMny() : BigDecimal.ZERO, balance), null != data.getPaymentMny() ? data.getPaymentMny() : BigDecimal.ZERO);
            }
        }

        QueryWrapper<PayContractEntity> payContractEntityQueryWrapper = new QueryWrapper<PayContractEntity>().eq("project_id", projectId);
        if (null != payContractId){
            payContractEntityQueryWrapper.ne("id", payContractId);
        }
        List<PayContractEntity> payContractEntityList = payContractService.list(payContractEntityQueryWrapper);
        if (CollectionUtils.isNotEmpty(payContractEntityList) && payContractEntityList.size() > 0){
            balance = ComputeUtil.safeSub(balance, payContractEntityList.stream().filter(item -> null != item.getApplyMny()).map(PayContractEntity::getApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add));
        }
        QueryWrapper<PaySporadicEntity> paySporadicEntityQueryWrapper = new QueryWrapper<PaySporadicEntity>().eq("project_id", projectId);
        if (null != paySporadicId){
            paySporadicEntityQueryWrapper.ne("id", paySporadicId);
        }
        List<PaySporadicEntity> paySporadicEntityList = paySporadicService.list();
        if (CollectionUtils.isNotEmpty(paySporadicEntityList) && paySporadicEntityList.size() > 0){
            balance = ComputeUtil.safeSub(balance, paySporadicEntityList.stream().filter(item -> null != item.getApplyMny()).map(PaySporadicEntity::getApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add));
        }

        res.put("projectId", projectId);
        res.put("balance", balance);
        return CommonResponse.success("查询详情数据成功！", res);
    }
}
