package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.finance.bean.ReceiveEntity;
import com.ejianc.business.finance.service.IReceiveInvoiceService;
import com.ejianc.business.finance.service.IReceiveService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

@Service("receive")
public class ReceiveBpmServiceImpl implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

//    @Autowired
//    private IIncomeContractApi incomApi;

    @Autowired
    private IReceiveService receiveService;

    @Autowired
    private IBillTypeApi billTypeApi;

//    @Autowired
//    private IPrjRiskMarginApi prjRiskMarginApi;

    @Autowired
    private IReceiveInvoiceService invoiceService;
//    @Autowired
//    private IIncomeContractApi iIncomeContractApi;

//    @Autowired
//    private IBankFlowService bankFlowService;

//    @Autowired
//    private IInvoiceApi invoiceApi;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        ReceiveEntity entity = receiveService.selectById(billId);
        CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        };
        // 校验创建时间
        if (!validateCreateTime(entity)) return CommonResponse.error("该合同已存在后续单据,不能弃审!");
        // 校验存在未生效单据
        if (!validateEffective(entity)) return CommonResponse.error("该支出单据数据已被引用，不可进行撤回操作!");
        return CommonResponse.success("校验通过");
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /**
     * 校验存在未生效单据
     *
     * @param entity
     * @return
     */
    private boolean validateEffective(ReceiveEntity entity) {
        Long contractId = entity.getContractId();
        QueryWrapper wrapper = new QueryWrapper<ReceiveEntity>();
        wrapper.eq("contract_id", contractId);
        wrapper.eq("org_id", entity.getOrgId());
        wrapper.ne("bill_state", 1);
        wrapper.ne("bill_state", 3);
        List<ReceiveEntity> list = receiveService.list(wrapper);
        if (!list.isEmpty()) {
            return false;
        }
        return true;
    }

    /**
     * 校验创建时间
     *
     * @param entity
     * @return
     */
    private boolean validateCreateTime(ReceiveEntity entity) {
        Long contractId = entity.getContractId();
        Date createTime = entity.getCreateTime();
        QueryWrapper wrapper = new QueryWrapper<ReceiveEntity>();
        wrapper.eq("contract_id", contractId);
        wrapper.eq("org_id", entity.getOrgId());
        wrapper.gt("create_time", createTime);
        List<ReceiveEntity> list = receiveService.list(wrapper);
        if (!list.isEmpty()) {
            return false;
        }
        return true;
    }
}
