package com.ejianc.business.oa.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 人力行政-证书档案-证件信息
 * 
 * @author generator
 * 
 */
 @TableName("ejc_oa_cert_record_detail")
public class CertRecordDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="record_id")
    private Long recordId; // 证书档案id
    @TableField(value="cert_type")
    private Long certType; // 证照类别
    @TableField(value="cert_type_name")
    private String certTypeName; // 证照类别
    @TableField(value="cert_name")
    private String certName; // 证照名称
    @TableField(value="cert_name_id")
    private Long certNameId; // 证照名称
    @TableField(value="cert_code")
    private String certCode; // 证照编号
    @TableField(value="cert_major")
    private String certMajor; // 证照专业
    @TableField(value="cert_major_id")
    private Long certMajorId; // 证照专业名称
    @TableField(value="seal_major")
    private String sealMajor; // 印章专业
    @TableField(value="authorities")
    private String authorities; // 发证机关
    @TableField(value="approve_num")
    private String approveNum; // 批准文号
    @TableField(value="begin_time")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date beginTime; // 生效日期
    @TableField(value="term")
    private Integer term; // 有无期限 1：有 2：无
    @TableField(value="term_name")
    private String termName; // 有无期限 1：有 2：无
    @TableField(value="end_time")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endTime; // 失效日期
    @TableField(value="electron_cert_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date electronCertDate; // 电子证照有效期
    @TableField(value="send_cert_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date sendCertDate; // 发证日期
    @TableField(value="add_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date addDate; // 加注有效期
    @TableField(value="cert_state")
    private Integer certState; // 证书使用状态
    @TableField(value="cert_state_name")
    private String certStateName; // 证书使用状态
    @TableField(value="place")
    private String place; // 存放地点
    @TableField(value="org_detail_id")
    private Long orgDetailId; // 组织ID
    @TableField(value="org_detail_name")
    private String orgDetailName; // 组织

    public Long getCertNameId() {
        return certNameId;
    }

    public void setCertNameId(Long certNameId) {
        this.certNameId = certNameId;
    }

    public Long getCertMajorId() {
        return certMajorId;
    }

    public void setCertMajorId(Long certMajorId) {
        this.certMajorId = certMajorId;
    }

    public Long getCertType() {
        return certType;
    }

    public void setCertType(Long certType) {
        this.certType = certType;
    }

    public Long getRecordId() {
        return recordId;
    }

    public void setRecordId(Long recordId) {
        this.recordId = recordId;
    }
    public String getCertTypeName() {
        return certTypeName;
    }

    public void setCertTypeName(String certTypeName) {
        this.certTypeName = certTypeName;
    }
    public String getCertName() {
        return certName;
    }

    public void setCertName(String certName) {
        this.certName = certName;
    }
    public String getCertCode() {
        return certCode;
    }

    public void setCertCode(String certCode) {
        this.certCode = certCode;
    }
    public String getCertMajor() {
        return certMajor;
    }

    public void setCertMajor(String certMajor) {
        this.certMajor = certMajor;
    }
    public String getSealMajor() {
        return sealMajor;
    }

    public void setSealMajor(String sealMajor) {
        this.sealMajor = sealMajor;
    }
    public String getAuthorities() {
        return authorities;
    }

    public void setAuthorities(String authorities) {
        this.authorities = authorities;
    }
    public String getApproveNum() {
        return approveNum;
    }

    public void setApproveNum(String approveNum) {
        this.approveNum = approveNum;
    }
    public Date getBeginTime() {
        return beginTime;
    }

    public void setBeginTime(Date beginTime) {
        this.beginTime = beginTime;
    }
    public Integer getTerm() {
        return term;
    }

    public void setTerm(Integer term) {
        this.term = term;
    }
    public String getTermName() {
        return termName;
    }

    public void setTermName(String termName) {
        this.termName = termName;
    }
    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }
    public Date getElectronCertDate() {
        return electronCertDate;
    }

    public void setElectronCertDate(Date electronCertDate) {
        this.electronCertDate = electronCertDate;
    }
    public Date getSendCertDate() {
        return sendCertDate;
    }

    public void setSendCertDate(Date sendCertDate) {
        this.sendCertDate = sendCertDate;
    }
    public Date getAddDate() {
        return addDate;
    }

    public void setAddDate(Date addDate) {
        this.addDate = addDate;
    }
    public Integer getCertState() {
        return certState;
    }

    public void setCertState(Integer certState) {
        this.certState = certState;
    }
    public String getCertStateName() {
        return certStateName;
    }

    public void setCertStateName(String certStateName) {
        this.certStateName = certStateName;
    }
    public String getPlace() {
        return place;
    }

    public void setPlace(String place) {
        this.place = place;
    }
    public Long getOrgDetailId() {
        return orgDetailId;
    }
    public void setOrgDetailId(Long orgDetailId) {
        this.orgDetailId = orgDetailId;
    }
    public String getOrgDetailName() {
        return orgDetailName;
    }

    public void setOrgDetailName(String orgDetailName) {
        this.orgDetailName = orgDetailName;
    }
    
}
