package com.ejianc.business.oa.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.oa.enums.ChangeStateEnum;
import com.ejianc.business.oa.service.ICertTypeService;
import com.ejianc.business.oa.vo.*;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.checkerframework.checker.units.qual.A;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.oa.mapper.CertRecordMapper;
import com.ejianc.business.oa.bean.CertRecordEntity;
import com.ejianc.business.oa.service.ICertRecordService;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 人力行政-证书档案
 * 
 * @author generator
 * 
 */
@Service("certRecordService")
public class CertRecordServiceImpl extends BaseServiceImpl<CertRecordMapper, CertRecordEntity> implements ICertRecordService{

    @Autowired
    private IDefdocApi defdocApi;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ICertTypeService certTypeService;

    private static final String BILL_CODE = "BFYJ_OA_ZSDA";//此处需要根据实际修改

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<CertRecordDetailImportVO> successList = new ArrayList<>();
            List<CertRecordDetailImportVO> errorList = new ArrayList<>();

            if (result != null && result.size() > 0) {
                if (result.get(0).size() != 14) {
                    throw new BusinessException("请按照导入模板导入数据");
                }
                if (result.size() >= 1000) {
                    throw new BusinessException("文件数据不能超过1000行，超过请分批次多次导入");
                }

//                CommonResponse<List<DefdocDetailVO>> defDocByDefCode = defdocApi.getDefDocByDefCode("bfyj-oa-cert");
//                if (!defDocByDefCode.isSuccess()){
//                    throw new BusinessException("获取证书情况自定义档案失败！");
//                }
//                List<DefdocDetailVO> defdocList = defDocByDefCode.getData();
//                Map<String, DefdocDetailVO> defDocMap = defdocList.stream().collect(Collectors.toMap(e -> e.getName(), e -> e));

                //获取证照类别档案
                List<CertTypeVO> certTypeList = certTypeService.queryListEntityTree(new HashMap<>());
                Map<String, CertTypeVO> defDocMap = certTypeList.stream().collect(Collectors.toMap(e -> e.getName(), e -> e));

                Map<String, OrgVO> orgMap = new HashMap<>();

                for (int i = 1; i < result.size(); i++) {
                    StringBuilder errorMessage = new StringBuilder();
                    List<String> datas = result.get(i);
                    CertRecordDetailImportVO importVO = new CertRecordDetailImportVO();

                    //证照类别
                    if (StringUtils.isBlank(datas.get(0))) {
                        errorMessage.append("[证照类别为必填项]");
                    } else {
                        if (datas.get(0).length() > 200) {
                            errorMessage.append("[填写证照类别长度为1~200字]");
                        }
                        if (defDocMap.containsKey(datas.get(0).trim())){
                            importVO.setCertTypeName(datas.get(0).trim());
                            importVO.setCertType(defDocMap.get(datas.get(0).trim()).getId());
                        }else {
                            errorMessage.append("[请在证照分类档案添加该证照类别项！]");
                        }
                    }

                    //证照名称
                    if (StringUtils.isNotBlank(datas.get(1))) {
                        if (datas.get(1).length() > 200) {
                            errorMessage.append("[填写证照名称长度为1~200字]");
                        }
                        if (defDocMap.containsKey(datas.get(1).trim())){
                            if (importVO.getCertType().longValue() != defDocMap.get(datas.get(1).trim()).getParentId().longValue()){
                                errorMessage.append("[该证照名称项不是证照分类的下级！]");
                            }else {
                                importVO.setCertName(datas.get(1).trim());
                                importVO.setCertNameId(defDocMap.get(datas.get(1).trim()).getId());
                            }
                        }else {
                            errorMessage.append("[请在证照分类档案添加该证照名称项！]");
                        }
                    }



                    //证照编号
                    if (StringUtils.isBlank(datas.get(2))) {
                        errorMessage.append("[证照编号为必填项]");
                    } else {
                        if (datas.get(2).length() > 50) {
                            errorMessage.append("[填写证照编号长度为1~50字]");
                        }
                        importVO.setCertCode(datas.get(2).trim());
                    }


                    if (StringUtils.isNotBlank(datas.get(3))) {
                        if (datas.get(3).length() > 200) {
                            errorMessage.append("[填写证书专业长度为1~200字]");
                        }
                        if (defDocMap.containsKey(datas.get(3).trim())){
                            if (importVO.getCertNameId().longValue() != defDocMap.get(datas.get(3).trim()).getParentId().longValue()){
                                errorMessage.append("[该证书专业不是证照名称的下级！]");
                            }else {
                                importVO.setCertMajor(datas.get(3).trim());
                                importVO.setCertMajorId(defDocMap.get(datas.get(3).trim()).getId());
                            }
                        }else {
                            errorMessage.append("[请在证照分类档案添加该证书专业项！]");
                        }
                    }


//                    importVO.setSealMajor(datas.get(4));
                    importVO.setAuthorities(datas.get(4));
                    importVO.setApproveNum(datas.get(5));

                    //生效日期
                    if (StringUtils.isNotBlank(datas.get(6))) {
                        try {
                            importVO.setBeginTime(DateUtils.parseDate(datas.get(6), "YYYY-MM-dd"));
                        } catch (ParseException e) {
                            errorMessage.append("[生效日期填写格式错误，请填写 YYYY-MM-dd 类型的日期格式]");
                            e.printStackTrace();
                        }
                    }else {
                        errorMessage.append("[生效日期为必填项]");
                    }

                    //有无期限
                    if (StringUtils.isBlank(datas.get(7))) {
                        errorMessage.append("[有无期限为必填项]");
                    } else {
                        importVO.setTermName(datas.get(7).trim());
                        importVO.setTerm("有".equals(datas.get(7).trim()) ? 1 : 2);
                    }

                    //失效日期
                    if (StringUtils.isNotBlank(datas.get(8))) {
                        try {
                            importVO.setEndTime(DateUtils.parseDate(datas.get(8), "YYYY-MM-dd"));
                        } catch (ParseException e) {
                            errorMessage.append("[失效日期填写格式错误，请填写 YYYY-MM-dd 类型的日期格式]");
                            e.printStackTrace();
                        }
                    }

                    //电子证照有效期
                    if (StringUtils.isNotBlank(datas.get(9))) {
                        try {
                            importVO.setElectronCertDate(DateUtils.parseDate(datas.get(9), "YYYY-MM-dd"));
                        } catch (ParseException e) {
                            errorMessage.append("[电子证照有效期填写格式错误，请填写 YYYY-MM-dd 类型的日期格式]");
                            e.printStackTrace();
                        }
                    }

                    //发证日期
                    if (StringUtils.isNotBlank(datas.get(10))) {
                        try {
                            importVO.setSendCertDate(DateUtils.parseDate(datas.get(10), "YYYY-MM-dd"));
                        } catch (ParseException e) {
                            errorMessage.append("[发证日期填写格式错误，请填写 YYYY-MM-dd 类型的日期格式]");
                            e.printStackTrace();
                        }
                    }

                    //加注有效期
//                    if (StringUtils.isNotBlank(datas.get(12))) {
//                        try {
//                            importVO.setAddDate(DateUtils.parseDate(datas.get(12), "YYYY-MM-dd"));
//                        } catch (ParseException e) {
//                            errorMessage.append("[加注有效期日期填写格式错误，请填写 YYYY-MM-dd 类型的日期格式]");
//                            e.printStackTrace();
//                        }
//                    }

                    //证书使用状态
                    if (StringUtils.isNotBlank(datas.get(11))) {
                        importVO.setCertStateName(datas.get(11).trim());
                        importVO.setCertState("是".equals(datas.get(11).trim()) ? 1 : 2);
                    }

                    //存放地点
                    importVO.setPlace(datas.get(12));

                    //所属组织
                    if (StringUtils.isNotBlank(datas.get(13))){
                        if (orgMap.containsKey(datas.get(13))){
                            importVO.setOrgDetailId(orgMap.get(datas.get(13)).getId());
                            importVO.setOrgDetailName(orgMap.get(datas.get(13)).getName());
                        }else {
                            CommonResponse<OrgVO> orgResp = orgApi.findByNameAndTenantId(datas.get(13), InvocationInfoProxy.getTenantid());
                            if (!orgResp.isSuccess()){
                                throw new BusinessException("获取组织信息失败，请稍后重试！");
                            }
                            if (null != orgResp.getData()){
                                OrgVO orgVO = orgResp.getData();
                                orgMap.put(orgVO.getName(), orgVO);
                                importVO.setOrgDetailId(orgVO.getId());
                                importVO.setOrgDetailName(orgVO.getName());
                            }
                        }
                    }
                    importVO.setId(IdWorker.getId());


                    if (StringUtils.isBlank(errorMessage)) {
                        successList.add(importVO);
                    } else {
                        importVO.setErrorMessage(String.valueOf(errorMessage));
                        errorList.add(importVO);
                    }
                }
            }
            JSONObject json = new JSONObject();
            json.put("successList", successList);
            json.put("errorList", errorList);
            return CommonResponse.success(json);
        }
    }

    @Override
    public CommonResponse<CertRecordVO> insertOrUpdate(CertRecordVO saveOrUpdateVO) {
        CertRecordEntity entity = BeanMapper.map(saveOrUpdateVO, CertRecordEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            //第一版设置版本号、原始版本主键、第一版本创建时间
            if(null == entity.getLastTaskId()){
                entity.setTaskVersion(1);

                entity.setOneTime(entity.getCreateTime());
                entity.setChangeState(ChangeStateEnum.未变更.getCode());
            }

            entity.setLatestFlag(true);//新增时默认最新版本
            entity.setEnableState(false);//新增时默认不生效

            if (null == entity.getBillCode()){
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if(billCode.isSuccess()) {
                    entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                }else{
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }
        }
        this.saveOrUpdate(entity, false);
        
        //如果是变更单，则原单据保存变更信息
        if(entity.getLastTaskId() != null){
            CertRecordEntity revise = super.getById(entity.getLastTaskId());
            if (revise.getLatestFlag()){

                revise.setChangeId(entity.getId());
                revise.setChangeState(ChangeStateEnum.变更中.getCode());
                //变更单保存后，原单据就不是最新版本！（这里是否变更单生效后再把原单据改为 非最新版本）
                revise.setLatestFlag(false);
                //第一次变更保存，设置原单据初始版本id
                revise.setBaseTaskId(null != revise.getBaseTaskId() ? revise.getBaseTaskId() : revise.getId());

                super.saveOrUpdate(revise);
            }
        }
        return CommonResponse.success("保存或修改单据成功！", this.queryDetail(entity.getId()));
    }

    @Override
    public CertRecordVO queryDetail(Long id) {
        CertRecordEntity entity = super.selectById(id);
        CertRecordVO vo = BeanMapper.map(entity, CertRecordVO.class);

        //记录表
        List<CertRecordRecordVO> list = new ArrayList<>();
        LambdaQueryWrapper<CertRecordEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(CertRecordEntity::getBaseTaskId, entity.getBaseTaskId());
        queryWrapper.in(CertRecordEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        queryWrapper.ne(CertRecordEntity::getId, id);
        queryWrapper.orderByAsc(CertRecordEntity::getCreateTime);
        List<CertRecordEntity> taskEntityList = super.list(queryWrapper);
        if(CollectionUtils.isNotEmpty(taskEntityList)){
            list = BeanMapper.mapList(taskEntityList, CertRecordRecordVO.class);
        }
        vo.setRecordList(list);
        return vo;
    }

    @Override
    public CertRecordVO queryChangeDetail(Long id) {
        CertRecordEntity entity = super.selectById(id);
        CertRecordVO vo = BeanMapper.map(entity, CertRecordVO.class);
        vo.setId(null);
//        vo.setBillCode(null);
        vo.setBillState(null);
        vo.setCreateTime(null);
        vo.setCreateUserCode(null);
        vo.setUpdateTime(null);
        vo.setUpdateUserCode(null);

        vo.setBeforeTaskVersion(vo.getTaskVersion());
        vo.setTaskVersion(vo.getTaskVersion() + 1);
        vo.setLastTaskId(id);
        vo.setBaseTaskId(null != entity.getBaseTaskId() ? entity.getBaseTaskId() : id);

        vo.setChangeEmployeeId(null);
        vo.setChangeEmployeeName(null);
        vo.setChangeReason(null);

//        vo.setChangeState(ChangeStateEnum.未变更.getCode());
//        vo.setLatestFlag(true);
//        vo.setEnableState(false);

        List<CertRecordDetailVO> detailList = vo.getCertRecordDetailList();
        if(CollectionUtils.isNotEmpty(detailList)){
            detailList.forEach(changeDetailVO ->{
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setRowState("add");
            });
            vo.setCertRecordDetailList(detailList);
        }
        return vo;
    }

    @Override
    public CommonResponse<String> deleteVos(List<CertRecordVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for(CertRecordVO taskVO : vos){
                CertRecordEntity taskEntity = super.selectById(taskVO.getId());
                //删除变更中的数据、回写原数据
                // （这里是否有问题，如果变更一次后，第二次变更怎么显示？版本号是不是这里体现意义？这里得价格版本号）
                if(taskEntity.getLastTaskId() != null){
                    CertRecordEntity revise = super.getById(taskEntity.getLastTaskId());
                    revise.setChangeId(null);
                    revise.setLatestFlag(true);

                    //可能不是第一次变更
                    revise.setChangeState(1 == taskEntity.getTaskVersion() ? ChangeStateEnum.未变更.getCode() : ChangeStateEnum.已变更.getCode());
                    super.saveOrUpdate(revise);
                }
            }
        }
        super.removeByIds(vos.stream().map(CertRecordVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }


}
