package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.finance.bean.PayRecordEntity;
import com.ejianc.business.finance.bean.PaySporadicEntity;
import com.ejianc.business.finance.service.IPayRecordService;
import com.ejianc.business.finance.service.IPaySporadicService;
import com.ejianc.business.tax.bean.InvoiceReceivePoolEntity;
import com.ejianc.business.tax.bean.InvoiceReceiveRegistEntity;
import com.ejianc.business.tax.service.IInvoiceReceiveRegistService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

@Service("paySporadic") 
public class PaySporadicBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IBillTypeApi billTypeApi;
	@Autowired
	private IPaySporadicService service;

	@Autowired
	private IPayRecordService recordService;
	@Autowired
	private IInvoiceReceiveRegistService invoiceReceiveRegistService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		PaySporadicEntity entity = service.selectById(billId);

		List<InvoiceReceiveRegistEntity> registerList = invoiceReceiveRegistService.list(new QueryWrapper<InvoiceReceiveRegistEntity>().eq("project_id", entity.getProjectId()).eq("seller_id", entity.getSupplyId()));
		if (CollectionUtils.isNotEmpty(registerList) && registerList.size() > 0){
			InvoiceReceiveRegistEntity registerEntity = registerList.get(0);


			List<PaySporadicEntity> entityList = service.list(new QueryWrapper<PaySporadicEntity>().eq("project_id", entity.getProjectId()).eq("supply_id", entity.getSupplyId()).in("bill_state", Arrays.asList(1,3)).ne("id", entity.getId()));
			BigDecimal applyMny = entity.getApplyMny();
			if (CollectionUtils.isNotEmpty(entityList) && entityList.size() > 1){
				applyMny = ComputeUtil.safeAdd(applyMny, entityList.stream().filter(item -> null != item.getApplyMny()).map(PaySporadicEntity::getApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add));
			}

			if (registerEntity.getSumPayMny().compareTo(registerEntity.getContractMnyTax()) == 0 && registerEntity.getSumPayMny().compareTo(registerEntity.getTotalReceiveMnyTax()) == 0){
				registerEntity = invoiceReceiveRegistService.selectById(registerEntity.getId());
				//判断收票登记是否三流一致 如果是则改发票是否合格
				List<InvoiceReceivePoolEntity> registerPoolList = registerEntity.getInvoiceReceivePoolList();
				if (CollectionUtils.isNotEmpty(registerPoolList) && registerPoolList.size() > 0){
					registerPoolList.forEach(e -> {
						e.setPassFlag(1);
					});
				}
			}
			registerEntity.setSumPayMny(applyMny);
			invoiceReceiveRegistService.saveOrUpdate(registerEntity, false);
		}

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		PaySporadicEntity entity = service.selectById(billId);
		if (null != entity.getPayMny() && entity.getPayMny().compareTo(BigDecimal.ZERO) > 0){
			return CommonResponse.error("该单据已支付不能弃审/撤回!");
		}
		CommonResponse<String>  res = billTypeApi.checkQuote(billTypeCode,billId);




		if(res.isSuccess()) {//单据未被下游单据引用
			return CommonResponse.success();
		}else{
			return CommonResponse.error(res.getMsg());
		}
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		PaySporadicEntity applyEntity = service.selectById(billId);
		applyEntity.setPayMny(BigDecimal.ZERO);//支付金额
		applyEntity.setUnPayMny(ComputeUtil.safeSub(applyEntity.getApplyMny(),applyEntity.getPayMny()));//未支付金额
		applyEntity.setConfirmTime(null);
		service.updateById(applyEntity);
		// 删除付款记录表
		recordService.remove(new QueryWrapper<PayRecordEntity>().eq("payapply_id", billId));


		List<InvoiceReceiveRegistEntity> registerList = invoiceReceiveRegistService.list(new QueryWrapper<InvoiceReceiveRegistEntity>().eq("project_id", applyEntity.getProjectId()).eq("seller_id", applyEntity.getSupplyId()));
		if (CollectionUtils.isNotEmpty(registerList) && registerList.size() > 0){
			InvoiceReceiveRegistEntity registerEntity = registerList.get(0);
			if (null == registerEntity.getProjectBillId()){

				List<PaySporadicEntity> entityList = service.list(new QueryWrapper<PaySporadicEntity>().eq("project_id", applyEntity.getProjectId()).eq("supply_id", applyEntity.getSupplyId()).in("bill_state", Arrays.asList(1,3)).ne("id", applyEntity.getId()));
				BigDecimal applyMny = BigDecimal.ZERO;
				if (CollectionUtils.isNotEmpty(entityList) && entityList.size() > 1){
					applyMny = entityList.stream().filter(item -> null != item.getApplyMny()).map(PaySporadicEntity::getApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add);
				}

				if (!(registerEntity.getSumPayMny().compareTo(registerEntity.getContractMnyTax()) == 0 && registerEntity.getSumPayMny().compareTo(registerEntity.getTotalReceiveMnyTax()) == 0)){
					//如果不是三流一致 是否合格改为否
					registerEntity = invoiceReceiveRegistService.selectById(registerEntity.getId());

					List<InvoiceReceivePoolEntity> registerPoolList = registerEntity.getInvoiceReceivePoolList();
					if (CollectionUtils.isNotEmpty(registerPoolList) && registerPoolList.size() > 0){
						registerPoolList.forEach(e -> {
							e.setPassFlag(0);
						});
					}
				}
				registerEntity.setSumPayMny(applyMny);
				invoiceReceiveRegistService.saveOrUpdate(registerEntity, false);
			}
		}

		//TODO
		return CommonResponse.success();
	}

}
