/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bid.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bid.bean.AreaEntity;
import com.ejianc.business.bid.service.IAreaService;
import com.ejianc.business.bid.vo.AreaVO;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/area/"})
public class AreaController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IAreaService areaService;
    @Autowired
    private CacheManager cacheManager;
    private static final String EJC_ADMINISTRATIVE_AREA = "EJC_ADMINISTRATIVE_AREA";

    @GetMapping(value={"queryList"})
    public CommonResponse<List<AreaVO>> queryList(@RequestParam(value="pid", required=false) Long pid, @RequestParam(value="billCode", required=false) String billCode, @RequestParam(value="areaName", required=false) String areaName, @RequestParam(value="status", required=false) Integer status) {
        List<AreaVO> listMap = this.areaService.queryList(pid, billCode, areaName, status);
        if (CollectionUtils.isNotEmpty(listMap)) {
            listMap.stream().forEach(item -> {
                if (item.isLeaf()) {
                    item.setChildren(null);
                }
            });
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", listMap);
    }

    @PostMapping(value={"saveOrUpdate"})
    public CommonResponse<AreaVO> saveOrUpdate(@RequestBody AreaVO vo) {
        List billCodeEntityList;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"bill_code", (Object)vo.getBillCode());
        if (null != vo.getId()) {
            query.ne((Object)"id", (Object)vo.getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)(billCodeEntityList = this.areaService.list((Wrapper)query)))) {
            return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7f16\u7801\u91cd\u590d\uff01");
        }
        AreaEntity saveEntity = null;
        if (null == vo.getId()) {
            saveEntity = (AreaEntity)((Object)BeanMapper.map((Object)vo, AreaEntity.class));
            saveEntity.setId(IdWorker.getId());
            saveEntity.setStatus(AreaVO.STATUS_VALID);
        } else {
            saveEntity = (AreaEntity)((Object)this.areaService.selectById(vo.getId()));
            saveEntity.setAreaName(vo.getAreaName());
            saveEntity.setBillCode(vo.getBillCode());
            saveEntity.setDescription(vo.getDescription());
        }
        if (null != vo.getPid()) {
            AreaEntity parent = (AreaEntity)((Object)this.areaService.selectById(vo.getPid()));
            saveEntity.setPid(parent.getId());
            saveEntity.setpName(parent.getAreaName());
            saveEntity.setInnerCode(parent.getInnerCode() + "|" + saveEntity.getId());
        } else {
            saveEntity.setInnerCode(saveEntity.getId().toString());
        }
        saveEntity.setSequence(vo.getSequence());
        this.areaService.saveOrUpdate((Object)saveEntity);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01", (Object)BeanMapper.map((Object)((Object)saveEntity), AreaVO.class));
    }

    @GetMapping(value={"queryDetail"})
    public CommonResponse<AreaVO> queryDetail(@RequestParam(value="id") Long id) {
        AreaVO resp = null;
        AreaEntity dbEntity = (AreaEntity)((Object)this.areaService.selectById(id));
        if (null != dbEntity) {
            resp = (AreaVO)BeanMapper.map((Object)((Object)dbEntity), AreaVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", resp);
    }

    @PostMapping(value={"delete"})
    public CommonResponse<String> delete(@RequestBody List<AreaVO> vos) {
        List<Long> ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        queryWrapper.in((Object)"pid", ids);
        List childList = this.areaService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)childList)) {
            return CommonResponse.error((String)"\u5220\u9664\u6570\u636e\u5b58\u5728\u5b50\u7ea7\u8282\u70b9\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01");
        }
        this.areaService.batchDelByIds(ids);
        this.refreshCache();
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @PostMapping(value={"changeStatus"})
    public CommonResponse<String> changeStatus(@RequestBody AreaVO vo) {
        AreaEntity dbEntity = (AreaEntity)((Object)this.areaService.selectById(vo.getId()));
        if (null != dbEntity) {
            dbEntity.setStatus(vo.getStatus());
            this.areaService.saveOrUpdate((Object)dbEntity, false);
        }
        this.refreshCache();
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @GetMapping(value={"loadAreaCascader"})
    public List<Map<String, Object>> loadAreaCascader(@RequestParam(value="pid", required=false) Long pid) {
        List<Map> listMap = this.areaService.queryAll(pid);
        List resp = ResultAsTree.createTreeData(listMap);
        return resp;
    }

    @GetMapping(value={"refAreaList"})
    public CommonResponse<IPage<AreaVO>> refAreaList(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("status", new Parameter("eq", (Object)AreaVO.STATUS_VALID));
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            JSONObject _json = JSONObject.parseObject((String)condition);
            if (_json.containsKey((Object)"level")) {
                param.getParams().put("level", new Parameter("eq", _json.get((Object)"level")));
            }
            if (_json.containsKey((Object)"pid")) {
                param.getParams().put("pid", new Parameter("eq", _json.get((Object)"pid")));
            }
        }
        param.getOrderMap().put("sequence", "asc");
        IPage page = this.areaService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), AreaVO.class));
        pageData.getRecords().forEach(item -> item.setChildren(null));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @PostMapping(value={"areaExcelImport"})
    public CommonResponse<JSONObject> areaExcelImport(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        ArrayList<JSONObject> successList = new ArrayList<JSONObject>();
        ArrayList<JSONObject> errorList = new ArrayList<JSONObject>();
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            if (result.size() > 10000) {
                return CommonResponse.error((String)"\u5730\u533a\u6570\u636e\u8d85\u8fc710000\u6761\uff0c\u8bf7\u5206\u6279\u4e0a\u4f20\uff01");
            }
            HashMap<String, JSONObject> areaBeanMap = new HashMap<String, JSONObject>();
            JSONObject parent = null;
            AreaEntity parentEntity = null;
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                JSONObject area = new JSONObject();
                area.put("id", (Object)IdWorker.getId());
                area.put("billCode", datas.get(0));
                area.put("areaName", datas.get(1));
                area.put("pName", datas.get(2));
                area.put("pCode", datas.get(3));
                area.put("description", datas.get(4));
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(0)))) {
                    area.put("err", (Object)"\u884c\u653f\u5730\u533a\u7f16\u7801\u4e3a\u7a7a\uff01");
                    errorList.add(area);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                    area.put("err", (Object)"\u884c\u653f\u5730\u533a\u540d\u79f0\u4e3a\u7a7a\uff01");
                    errorList.add(area);
                    continue;
                }
                if (((String)datas.get(0)).length() > 50) {
                    area.put("err", (Object)"\u884c\u653f\u5730\u533a\u7f16\u7801\u957f\u5ea6\u9650\u5236\u4e3a50\u5b57\u4ee5\u5185\uff01");
                    errorList.add(area);
                    continue;
                }
                if (((String)datas.get(1)).length() > 50) {
                    area.put("err", (Object)"\u884c\u653f\u5730\u533a\u540d\u79f0\u957f\u5ea6\u9650\u5236\u4e3a50\u5b57\u4ee5\u5185\uff01");
                    errorList.add(area);
                    continue;
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(4))) && ((String)datas.get(4)).length() > 200) {
                    area.put("err", (Object)"\u884c\u653f\u5730\u533a\u63cf\u8ff0\u957f\u5ea6\u9650\u5236\u4e3a200\u5b57\u4ee5\u5185\uff01");
                    errorList.add(area);
                    continue;
                }
                if (areaBeanMap.containsKey(area.get((Object)"billCode").toString())) {
                    area.put("err", (Object)"\u884c\u653f\u5730\u533a\u7f16\u7801\u91cd\u590d\uff01");
                    errorList.add(area);
                    continue;
                }
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("billCode", new Parameter("eq", area.get((Object)"billCode")));
                queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
                List list = this.areaService.queryList(queryParam, false);
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    area.put("err", (Object)"\u884c\u653f\u5730\u533a\u7f16\u7801\u91cd\u590d\uff01");
                    errorList.add(area);
                    continue;
                }
                if (null != area.get((Object)"pName") && StringUtils.isNotBlank((CharSequence)area.get((Object)"pName").toString())) {
                    parent = (JSONObject)areaBeanMap.get(area.get((Object)"pCode"));
                    if (null != parent) {
                        area.put("pid", parent.get((Object)"id"));
                        area.put("pName", parent.get((Object)"areaName"));
                        area.put("level", (Object)(Integer.valueOf(parent.get((Object)"level").toString()) + 1));
                    } else {
                        if (null == area.get((Object)"pCode") || StringUtils.isBlank((CharSequence)area.get((Object)"pCode").toString())) {
                            area.put("err", (Object)"\u4e0a\u7ea7\u884c\u653f\u5730\u533a\u7f16\u7801\u4e3a\u7a7a\uff01");
                            errorList.add(area);
                            continue;
                        }
                        QueryParam parentQueryParam = new QueryParam();
                        parentQueryParam.getParams().put("area_name", new Parameter("eq", area.get((Object)"pName")));
                        parentQueryParam.getParams().put("bill_code", new Parameter("eq", area.get((Object)"pCode")));
                        parentQueryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
                        List parentList = this.areaService.queryList(parentQueryParam, false);
                        if (CollectionUtils.isEmpty((Collection)parentList)) {
                            area.put("err", (Object)"\u4e0a\u7ea7\u884c\u653f\u5730\u533a\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff01");
                            errorList.add(area);
                            continue;
                        }
                        parentEntity = (AreaEntity)((Object)parentList.get(0));
                        area.put("pid", (Object)parentEntity.getId());
                        area.put("pName", (Object)parentEntity.getAreaName());
                        area.put("level", (Object)(parentEntity.getLevel() + 1));
                        area.put("id", (Object)IdWorker.getId());
                        area.put("innerCode", (Object)(parentEntity.getInnerCode() + "|" + area.get((Object)"id")));
                    }
                } else {
                    area.put("level", (Object)1);
                    area.put("id", (Object)IdWorker.getId());
                    area.put("innerCode", area.get((Object)"id"));
                }
                area.put("status", (Object)AreaVO.STATUS_VALID);
                successList.add(area);
                areaBeanMap.put(area.get((Object)"billCode").toString(), area);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }

    @PostMapping(value={"downloadImportTemplate"})
    public void downloadImportTemplate(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"administrativeArea-import.xlsx", (String)"\u884c\u653f\u5730\u533a\u5bfc\u5165\u6a21\u677f");
    }

    @PostMapping(value={"saveAreaExcelImport"})
    public CommonResponse<String> saveAreaExcelImport(@RequestBody List<JSONObject> importData) {
        if (ListUtil.isEmpty(importData)) {
            return CommonResponse.error((String)"\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        List saveData = BeanMapper.mapList(importData, AreaEntity.class);
        this.areaService.saveOrUpdateBatch(saveData, saveData.size(), false);
        this.refreshCache();
        return CommonResponse.success((String)"\u5bfc\u5165\u6210\u529f\uff01");
    }

    @GetMapping(value={"refreshCache"})
    public void refreshCache() {
        Thread t = new Thread(() -> {
            this.logger.info("\u5f00\u59cb\u5237\u65b0\u5730\u5740\u7f13\u5b58.......");
            List<JSONObject> data = this.queryArea();
            if (ListUtil.isNotEmpty(data)) {
                this.cacheManager.set(EJC_ADMINISTRATIVE_AREA, (Serializable)((Object)JSONObject.toJSONString(data)));
            } else {
                this.cacheManager.set(EJC_ADMINISTRATIVE_AREA, (Serializable)((Object)"[]"));
            }
            this.logger.info("\u5237\u65b0\u5730\u5740\u7f13\u5b58\u5b8c\u6210.......");
        });
        t.start();
    }

    @GetMapping(value={"queryAreaCascader"})
    public JSONArray queryAreaCascader() {
        JSONArray data = JSONObject.parseArray((String)this.cacheManager.get(EJC_ADMINISTRATIVE_AREA).toString());
        this.logger.info(data.toJSONString());
        return data;
    }

    public List<JSONObject> queryArea() {
        QueryParam param = new QueryParam();
        param.getParams().put("status", new Parameter("eq", (Object)1));
        param.getParams().put("pid", new Parameter("eq", null));
        List listMap = this.areaService.queryList(param);
        List<JSONObject> resp = this.createTreeData(listMap);
        return resp;
    }

    public List<JSONObject> createTreeData(List<AreaEntity> list) {
        ArrayList<JSONObject> resp = new ArrayList<JSONObject>();
        for (AreaEntity item : list) {
            JSONObject object = JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)item)));
            object.put("value", (Object)(item.getId() + ""));
            object.put("title", (Object)item.getAreaName());
            object.put("label", (Object)item.getAreaName());
            resp.add(object);
        }
        for (JSONObject parent : resp) {
            this.setChildren(parent);
        }
        return resp;
    }

    private void setChildren(JSONObject parent) {
        ArrayList<JSONObject> children = new ArrayList<JSONObject>();
        QueryParam param = new QueryParam();
        param.getParams().put("status", new Parameter("eq", (Object)1));
        param.getParams().put("pid", new Parameter("eq", (Object)parent.getString("id")));
        List list = this.areaService.queryList(param);
        if (ListUtil.isNotEmpty((List)list)) {
            for (AreaEntity item : list) {
                JSONObject child = JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)item)));
                child.put("value", (Object)(item.getId() + ""));
                child.put("title", (Object)item.getAreaName());
                child.put("label", (Object)item.getAreaName());
                children.add(child);
            }
        }
        if (ListUtil.isNotEmpty(children)) {
            parent.put("children", children);
            for (JSONObject child : children) {
                this.setChildren(child);
            }
        }
    }
}

