/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.finance.bean.PayContractEntity;
import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.business.finance.service.IPayRecordService;
import com.ejianc.business.tax.bean.InvoiceReceivePoolEntity;
import com.ejianc.business.tax.bean.InvoiceReceiveRegistEntity;
import com.ejianc.business.tax.service.IInvoiceReceiveRegistService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="payContract")
public class PayContractBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IPayContractService service;
    @Autowired
    private IPayRecordService recordService;
    @Autowired
    private IInvoiceReceiveRegistService invoiceReceiveRegistService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        PayContractEntity payContractEntity = (PayContractEntity)((Object)this.service.selectById(billId));
        List registerList = this.invoiceReceiveRegistService.list((Wrapper)new QueryWrapper().eq((Object)"contract_id", (Object)payContractEntity.getContractId()));
        if (CollectionUtils.isNotEmpty((Collection)registerList) && registerList.size() > 0) {
            List<InvoiceReceivePoolEntity> registerPoolList;
            InvoiceReceiveRegistEntity registerEntity = (InvoiceReceiveRegistEntity)((Object)registerList.get(0));
            List payContractEntityList = this.service.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"contract_id", (Object)payContractEntity.getContractId())).in((Object)"bill_state", Arrays.asList(1, 3))).ne((Object)"id", (Object)payContractEntity.getId()));
            BigDecimal applyMny = payContractEntity.getApplyMny();
            if (CollectionUtils.isNotEmpty((Collection)payContractEntityList) && payContractEntityList.size() > 1) {
                applyMny = ComputeUtil.safeAdd((BigDecimal)applyMny, (BigDecimal)payContractEntityList.stream().filter(item -> null != item.getApplyMny()).map(PayContractEntity::getApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            }
            if (registerEntity.getSumPayMny().compareTo(registerEntity.getContractMnyTax()) == 0 && registerEntity.getSumPayMny().compareTo(registerEntity.getTotalReceiveMnyTax()) == 0 && CollectionUtils.isNotEmpty(registerPoolList = (registerEntity = (InvoiceReceiveRegistEntity)((Object)this.invoiceReceiveRegistService.selectById(registerEntity.getId()))).getInvoiceReceivePoolList()) && registerPoolList.size() > 0) {
                registerPoolList.forEach(e -> e.setPassFlag(1));
            }
            registerEntity.setSumPayMny(applyMny);
            this.logger.info("\u66f4\u65b0\u6536\u7968\u767b\u8bb0\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014>");
            this.invoiceReceiveRegistService.saveOrUpdate((Object)registerEntity, false);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        PayContractEntity entity = (PayContractEntity)((Object)this.service.selectById(billId));
        if (null != entity.getPayMny() && entity.getPayMny().compareTo(BigDecimal.ZERO) > 0) {
            return CommonResponse.error((String)"\u8be5\u5355\u636e\u5df2\u652f\u4ed8\u4e0d\u80fd\u5f03\u5ba1/\u64a4\u56de!");
        }
        if (!this.validateApproveTime(entity)) {
            return CommonResponse.error((String)"\u8be5\u5408\u540c\u5728\u672c\u7ec4\u7ec7\u4e0b\u975e\u6700\u65b0\u4ed8\u6b3e\u7533\u8bf7\uff0c\u4e0d\u80fd\u64a4\u56de!");
        }
        if (!this.validateEffective(entity)) {
            return CommonResponse.error((String)"\u8be5\u5408\u540c\u5728\u672c\u7ec4\u7ec7\u4e0b\u5b58\u5728\u672a\u751f\u6548\u4ed8\u6b3e\u7533\u8bf7\uff0c\u4e0d\u80fd\u64a4\u56de!");
        }
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        if (res.isSuccess()) {
            return CommonResponse.success();
        }
        return CommonResponse.error((String)res.getMsg());
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        InvoiceReceiveRegistEntity registerEntity;
        PayContractEntity applyEntity = (PayContractEntity)((Object)this.service.selectById(billId));
        applyEntity.setPayMny(BigDecimal.ZERO);
        applyEntity.setUnPayMny(ComputeUtil.safeSub((BigDecimal)applyEntity.getApplyMny(), (BigDecimal)applyEntity.getPayMny()));
        applyEntity.setConfirmTime(null);
        this.service.updateById((Object)applyEntity);
        this.recordService.remove((Wrapper)new QueryWrapper().eq((Object)"payapply_id", (Object)billId));
        List registerList = this.invoiceReceiveRegistService.list((Wrapper)new QueryWrapper().eq((Object)"contract_id", (Object)applyEntity.getContractId()));
        this.logger.info("\u5f00\u59cb\u6536\u7968\u767b\u8bb0\u67e5\u8be2\uff01-------------------->{}", (Object)JSONObject.toJSONString((Object)registerList));
        if (CollectionUtils.isNotEmpty((Collection)registerList) && registerList.size() > 0 && null == (registerEntity = (InvoiceReceiveRegistEntity)((Object)registerList.get(0))).getProjectBillId()) {
            List<InvoiceReceivePoolEntity> registerPoolList;
            List payContractEntityList = this.service.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"contract_id", (Object)applyEntity.getContractId())).in((Object)"bill_state", Arrays.asList(1, 3))).ne((Object)"id", (Object)applyEntity.getId()));
            BigDecimal applyMny = BigDecimal.ZERO;
            if (CollectionUtils.isNotEmpty((Collection)payContractEntityList) && payContractEntityList.size() > 1) {
                applyMny = payContractEntityList.stream().filter(item -> null != item.getApplyMny()).map(PayContractEntity::getApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            if ((registerEntity.getSumPayMny().compareTo(registerEntity.getContractMnyTax()) != 0 || registerEntity.getSumPayMny().compareTo(registerEntity.getTotalReceiveMnyTax()) != 0) && CollectionUtils.isNotEmpty(registerPoolList = (registerEntity = (InvoiceReceiveRegistEntity)((Object)this.invoiceReceiveRegistService.selectById(registerEntity.getId()))).getInvoiceReceivePoolList()) && registerPoolList.size() > 0) {
                registerPoolList.forEach(e -> e.setPassFlag(0));
            }
            registerEntity.setSumPayMny(applyMny);
            this.logger.info("\u67e5\u8be2registerEntity\uff01-------------------->{}", (Object)JSONObject.toJSONString((Object)((Object)registerEntity)));
            this.logger.info("\u66f4\u65b0\u6536\u7968\u767b\u8bb0\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014>");
            this.invoiceReceiveRegistService.saveOrUpdate((Object)registerEntity, false);
            this.logger.info("\u6536\u7968\u767b\u8bb0\u67e5\u8be2\u7ed3\u675f\uff01-------------------->{}", (Object)JSONObject.toJSONString((Object)((Object)registerEntity)));
        }
        return CommonResponse.success();
    }

    private boolean validateEffective(PayContractEntity entity) {
        Long contractId = entity.getContractId();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"contract_id", (Object)contractId);
        wrapper.eq((Object)"org_id", (Object)entity.getOrgId());
        wrapper.ne((Object)"bill_state", (Object)1);
        wrapper.ne((Object)"bill_state", (Object)3);
        List list = this.service.list((Wrapper)wrapper);
        return list.isEmpty();
    }

    private boolean validateApproveTime(PayContractEntity entity) {
        Long contractId = entity.getContractId();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"contract_id", (Object)contractId);
        wrapper.eq((Object)"org_id", (Object)entity.getOrgId());
        wrapper.gt((Object)"apply_date", (Object)entity.getApplyDate());
        List list = this.service.list((Wrapper)wrapper);
        return list.isEmpty();
    }
}

