/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.oa.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.oa.bean.InstoreEntity;
import com.ejianc.business.oa.bean.OutstoreDetailEntity;
import com.ejianc.business.oa.bean.OutstoreEntity;
import com.ejianc.business.oa.service.IInstoreService;
import com.ejianc.business.oa.service.IOutstoreService;
import com.ejianc.business.oa.vo.InstoreDetailVO;
import com.ejianc.business.oa.vo.InstoreVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="outstore")
public class OutstoreBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOutstoreService outstoreService;
    @Autowired
    private IInstoreService instoreService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IBillTypeApi billTypeApi;
    private static final String BILL_CODE = "OA_INSTORE";

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        OutstoreEntity entity = (OutstoreEntity)((Object)this.outstoreService.selectById(billId));
        if (Objects.equals(entity.getOutStoreType(), 0)) {
            InstoreVO vo = new InstoreVO();
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)vo);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            vo.setBillCode((String)billCode.getData());
            vo.setId(Long.valueOf(IdWorker.getId()));
            vo.setOrgId(entity.getInOrgId());
            vo.setOrgCode(entity.getInOrgCode());
            vo.setOrgName(entity.getInOrgName());
            vo.setStoreId(entity.getInStoreId());
            vo.setStoreName(entity.getInStoreName());
            vo.setInstoreDate(entity.getInStoreDate());
            vo.setMainSourceId(entity.getId());
            vo.setMainSourceType("1");
            vo.setMemo(entity.getMemo());
            vo.setEmployeeId(entity.getEmployeeId());
            vo.setEmployeeName(entity.getEmployeeName());
            vo.setBillState(Integer.valueOf(1));
            List instoreDetailVOList = vo.getDetailList();
            List<OutstoreDetailEntity> outStoreSubs = entity.getDetailList();
            if (!ListUtil.isEmpty(outStoreSubs)) {
                for (OutstoreDetailEntity outStoreSub : outStoreSubs) {
                    InstoreDetailVO detailVO = new InstoreDetailVO();
                    detailVO.setId(null);
                    detailVO.setVersion(null);
                    detailVO.setInstoreId(vo.getId());
                    detailVO.setStoreId(vo.getStoreId());
                    detailVO.setStoreName(vo.getStoreName());
                    detailVO.setInstoreDate(vo.getInstoreDate());
                    detailVO.setMaterialCategoryId(outStoreSub.getMaterialCategoryId());
                    detailVO.setMaterialCategoryName(outStoreSub.getMaterialCategoryName());
                    detailVO.setMaterialId(outStoreSub.getMaterialId());
                    detailVO.setMaterialCode(outStoreSub.getMaterialCode());
                    detailVO.setMaterialName(outStoreSub.getMaterialName());
                    detailVO.setMaterialSpec(outStoreSub.getMaterialSpec());
                    detailVO.setMaterialUnit(outStoreSub.getMaterialUnit());
                    detailVO.setInstoreNumber(outStoreSub.getOutStoreNumber());
                    detailVO.setResidueNumber(outStoreSub.getOutStoreNumber());
                    detailVO.setUnitPrice(outStoreSub.getUnitPrice());
                    detailVO.setTaxRate(outStoreSub.getTaxRate());
                    detailVO.setAmount(outStoreSub.getAmount());
                    detailVO.setRemark(outStoreSub.getRemark());
                    detailVO.setSourceType("2");
                    instoreDetailVOList.add(detailVO);
                }
            }
            this.logger.info("\u751f\u6210\u65b0\u7684\u5165\u5e93\u5355-{}", (Object)JSONObject.toJSONString((Object)vo));
            this.instoreService.saveOrUpdate(BeanMapper.map((Object)vo, InstoreEntity.class), false);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u5f03\u5ba1\u524d\u4e8b\u4ef6\u56de\u8c03-------------------");
        CommonResponse resp = this.billTypeApi.checkQuote(billTypeCode, billId);
        if (!resp.isSuccess()) {
            return CommonResponse.error((String)resp.getMsg());
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

