package com.ejianc.business.oa.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 人力行政-薪资异动审批表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_oa_employee_salary")
public class EmployeeSalaryEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 编号
    @TableField(value="employee_id")
    private Long employeeId; // 员工名称
    @TableField(value="name")
    private String name; // 员工名称
    @TableField(value="org_id")
    private Long orgId; // 区域ID
    @TableField(value="org_name")
    private String orgName; // 区域
    @TableField(value="dept_id")
    private Long deptId; // 部门ID
    @TableField(value="dept_name")
    private String deptName; // 部门
    @TableField(value="post_id")
    private Long postId; // 岗位ID
    @TableField(value="post_name")
    private String postName; // 岗位
    @TableField(value="into_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date intoDate; // 入职日期
    @TableField(value="use_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date useDate; // 生效日期
    @TableField(value="rank")
    private Integer rank; // 层级
    @TableField(value="rank_name")
    private String rankName; // 层级
    @TableField(value="change_type")
    private Integer changeType; // 异动类别（1涨薪2降薪）
    @TableField(value="change_type_name")
    private String changeTypeName; // 异动类别
    @TableField(value="change_salary")
    private BigDecimal changeSalary; // 异动金额
    @TableField(value="salary")
    private BigDecimal salary; // 薪资标准
    @TableField(value="basic_salary")
    private BigDecimal basicSalary; // 原基本薪资
    @TableField(value="post_salary")
    private BigDecimal postSalary; // 原岗位薪资
    @TableField(value="level_salary")
    private BigDecimal levelSalary; // 原层级薪资
    @TableField(value="cert_salary")
    private BigDecimal certSalary; // 证书津贴
    @TableField(value="base_cert_salary")
    private BigDecimal baseCertSalary; // 原证书津贴
    @TableField(value="educated_salary")
    private BigDecimal educatedSalary; // 学历津贴
    @TableField(value="sport_salary")
    private BigDecimal sportSalary; // 交通补助
    @TableField(value="year_salary")
    private BigDecimal yearSalary; // 司龄津贴
    @TableField(value="new_salary")
    private BigDecimal newSalary; // 异动后薪资标准
    @TableField(value="new_basic_salary")
    private BigDecimal newBasicSalary; // 新基本薪资
    @TableField(value="new_post_salary")
    private BigDecimal newPostSalary; // 新岗位薪资
    @TableField(value="new_level_salary")
    private BigDecimal newLevelSalary; // 新层级薪资
    @TableField(value="memo")
    private String memo; // 异动原因
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中

    @TableField(value="cert")
    private String cert; // 证书情况
    @TableField(value="cert_name")
    private String certName; // 证书情况
    @TableField(value="base_cert")
    private String baseCert; // 证书情况
    @TableField(value="base_cert_name")
    private String baseCertName; // 证书情况

    public String getBaseCert() {
        return baseCert;
    }

    public void setBaseCert(String baseCert) {
        this.baseCert = baseCert;
    }

    public String getBaseCertName() {
        return baseCertName;
    }

    public void setBaseCertName(String baseCertName) {
        this.baseCertName = baseCertName;
    }

    public String getCert() {
        return cert;
    }

    public void setCert(String cert) {
        this.cert = cert;
    }

    public String getCertName() {
        return certName;
    }

    public void setCertName(String certName) {
        this.certName = certName;
    }

    public BigDecimal getBaseCertSalary() {
        return baseCertSalary;
    }

    public void setBaseCertSalary(BigDecimal baseCertSalary) {
        this.baseCertSalary = baseCertSalary;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    public Long getPostId() {
        return postId;
    }

    public void setPostId(Long postId) {
        this.postId = postId;
    }
    public String getPostName() {
        return postName;
    }

    public void setPostName(String postName) {
        this.postName = postName;
    }
    public Date getIntoDate() {
        return intoDate;
    }

    public void setIntoDate(Date intoDate) {
        this.intoDate = intoDate;
    }
    public Date getUseDate() {
        return useDate;
    }

    public void setUseDate(Date useDate) {
        this.useDate = useDate;
    }
    public Integer getRank() {
        return rank;
    }

    public void setRank(Integer rank) {
        this.rank = rank;
    }
    public String getRankName() {
        return rankName;
    }

    public void setRankName(String rankName) {
        this.rankName = rankName;
    }
    public Integer getChangeType() {
        return changeType;
    }

    public void setChangeType(Integer changeType) {
        this.changeType = changeType;
    }
    public String getChangeTypeName() {
        return changeTypeName;
    }

    public void setChangeTypeName(String changeTypeName) {
        this.changeTypeName = changeTypeName;
    }
    public BigDecimal getChangeSalary() {
        return changeSalary;
    }

    public void setChangeSalary(BigDecimal changeSalary) {
        this.changeSalary = changeSalary;
    }
    public BigDecimal getSalary() {
        return salary;
    }

    public void setSalary(BigDecimal salary) {
        this.salary = salary;
    }
    public BigDecimal getBasicSalary() {
        return basicSalary;
    }

    public void setBasicSalary(BigDecimal basicSalary) {
        this.basicSalary = basicSalary;
    }
    public BigDecimal getPostSalary() {
        return postSalary;
    }

    public void setPostSalary(BigDecimal postSalary) {
        this.postSalary = postSalary;
    }
    public BigDecimal getLevelSalary() {
        return levelSalary;
    }

    public void setLevelSalary(BigDecimal levelSalary) {
        this.levelSalary = levelSalary;
    }
    public BigDecimal getCertSalary() {
        return certSalary;
    }

    public void setCertSalary(BigDecimal certSalary) {
        this.certSalary = certSalary;
    }
    public BigDecimal getEducatedSalary() {
        return educatedSalary;
    }

    public void setEducatedSalary(BigDecimal educatedSalary) {
        this.educatedSalary = educatedSalary;
    }
    public BigDecimal getSportSalary() {
        return sportSalary;
    }

    public void setSportSalary(BigDecimal sportSalary) {
        this.sportSalary = sportSalary;
    }
    public BigDecimal getYearSalary() {
        return yearSalary;
    }

    public void setYearSalary(BigDecimal yearSalary) {
        this.yearSalary = yearSalary;
    }
    public BigDecimal getNewSalary() {
        return newSalary;
    }

    public void setNewSalary(BigDecimal newSalary) {
        this.newSalary = newSalary;
    }
    public BigDecimal getNewBasicSalary() {
        return newBasicSalary;
    }

    public void setNewBasicSalary(BigDecimal newBasicSalary) {
        this.newBasicSalary = newBasicSalary;
    }
    public BigDecimal getNewPostSalary() {
        return newPostSalary;
    }

    public void setNewPostSalary(BigDecimal newPostSalary) {
        this.newPostSalary = newPostSalary;
    }
    public BigDecimal getNewLevelSalary() {
        return newLevelSalary;
    }

    public void setNewLevelSalary(BigDecimal newLevelSalary) {
        this.newLevelSalary = newLevelSalary;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    
}
