package com.ejianc.business.contract.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.contract.vo.ContractManageVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.contract.mapper.ContractManageMapper;
import com.ejianc.business.contract.bean.ContractManageEntity;
import com.ejianc.business.contract.service.IContractManageService;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 合同管理
 * 
 * @author generator
 * 
 */
@Service("contractManageService")
public class ContractManageServiceImpl extends BaseServiceImpl<ContractManageMapper, ContractManageEntity> implements IContractManageService{

    @Override
    public ContractManageVO saveContract(ContractManageEntity entity) {
        LambdaQueryWrapper<ContractManageEntity> lambda = Wrappers.lambdaQuery();
        lambda.eq(ContractManageEntity::getTenantId, InvocationInfoProxy.getTenantid());
        lambda.eq(ContractManageEntity::getBillCode, entity.getBillCode());
        lambda.eq(ContractManageEntity::getContractType, entity.getContractType());
        lambda.ne(entity.getId() != null && entity.getId() > 0, ContractManageEntity::getId, entity.getId());
        List<ContractManageEntity> entities = super.list(lambda);
        if (CollectionUtils.isNotEmpty(entities)) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }

        entity.setChangeStatus(1);
        entity.setBeforeChangeMny(entity.getContractMny());
        entity.setBeforeChangeTaxMny(entity.getContractTaxMny());
        entity.setBaseMoney(entity.getContractMny());
        entity.setBaseTaxMoney(entity.getContractTaxMny());
        this.saveOrUpdateNoES(entity);
        return BeanMapper.map(entity, ContractManageVO.class);
    }
    @Override
    public Map<String, Object> countContractAmount(QueryParam param) {
        Map<String, Object> resp = new HashMap<>();
        QueryWrapper wrapper = changeToQueryWrapper(param);
        wrapper.select("sum(base_tax_money) as baseTaxMoney, sum(contract_tax_mny) as contractTaxMny");
        resp = super.getMap(wrapper);
        if (null == resp) {
            resp = new HashMap<>();
            resp.put("baseTaxMoney", 0);
            resp.put("contractTaxMny", 0);
        }
        return resp;

    }

}
