package com.ejianc.business.oa.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.finance.utils.DateUtil;
import com.ejianc.business.oa.service.IEmployeeIntoService;
import com.ejianc.business.oa.vo.EmployeeIntoVO;
import com.ejianc.business.oa.vo.PayrollDetailImportVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.oa.mapper.PayrollMapper;
import com.ejianc.business.oa.bean.PayrollEntity;
import com.ejianc.business.oa.service.IPayrollService;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.Period;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 人力行政-工资表
 * 
 * @author generator
 * 
 */
@Service("payrollService")
public class PayrollServiceImpl extends BaseServiceImpl<PayrollMapper, PayrollEntity> implements IPayrollService{

    @Autowired
    private IEmployeeIntoService employeeIntoService;

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<PayrollDetailImportVO> successList = new ArrayList<>();
            List<PayrollDetailImportVO> errorList = new ArrayList<>();

            if (result != null && result.size() > 0) {
//                if (result.get(0).size() != 16) {
//                    throw new BusinessException("请按照导入模板导入数据");
//                }
                if (result.size() >= 1000) {
                    throw new BusinessException("文件数据不能超过1000行，超过请分批次多次导入");
                }

                //获取全部人员
                List<EmployeeIntoVO> employeeList = employeeIntoService.queryEmployeeData();
                if (CollectionUtils.isEmpty(employeeList)){
                    throw new BusinessException("请添加入职申请人员！");
                }

                Map<String, EmployeeIntoVO> employeeMap = employeeList.stream().collect(Collectors.toMap(e -> e.getIdCard(), e -> e));


                for (int i = 3; i < result.size() - 1; i++) {
                    StringBuilder errorMessage = new StringBuilder();
                    List<String> datas = result.get(i);
                    PayrollDetailImportVO importVO = new PayrollDetailImportVO();

                    //身份证号
                    if (StringUtils.isBlank(datas.get(1))) {
                        errorMessage.append("[身份证号为必填项]");
                    } else {
                        if (datas.get(1).length() > 200) {
                            importVO.setErrorMessage("填写身份证号长度为1~200字");
                        }
                        if (employeeMap.containsKey(datas.get(1).trim())){
                            EmployeeIntoVO employeeIntoVO = employeeMap.get(datas.get(1).trim());
                            importVO = BeanMapper.map(employeeIntoVO, PayrollDetailImportVO.class);
                            importVO.setEmployeeId(employeeIntoVO.getId());
                        }else {
                            continue;
                        }
                    }

                    //工作时长
                    if (StringUtils.isNotBlank(datas.get(8))) {
                        importVO.setSalaryTime(new BigDecimal(datas.get(8).trim()));
                    }


                    BigDecimal noClockTime = BigDecimal.ZERO;
                    //缺卡次数
                    if (StringUtils.isNotBlank(datas.get(17))) {
                        noClockTime = ComputeUtil.safeAdd(new BigDecimal(datas.get(17).trim()), noClockTime);
                    }
                    if (StringUtils.isNotBlank(datas.get(18))) {
                        noClockTime = ComputeUtil.safeAdd(new BigDecimal(datas.get(18).trim()), noClockTime);
                    }
                    importVO.setNoClockTime(noClockTime);

                    //旷工工时
                    //todo: 一天按8小时算 后续修改
                    if (StringUtils.isNotBlank(datas.get(19))) {
                        importVO.setAbsenteeTime(ComputeUtil.safeMultiply(new BigDecimal(datas.get(19).trim()), new BigDecimal(8)));
                    }


                    //事假
                    if (StringUtils.isNotBlank(datas.get(22))) {
                        importVO.setThingTime(new BigDecimal(datas.get(22).trim()));
                    }
                    //病假工时
                    if (StringUtils.isNotBlank(datas.get(24))) {
                        importVO.setIllnessTime(new BigDecimal(datas.get(24).trim()));
                    }
                    BigDecimal marryTime = BigDecimal.ZERO;
                    //婚假、产假、哺乳假、丧假
                    if (StringUtils.isNotBlank(datas.get(26))) {
                        marryTime = ComputeUtil.safeAdd(new BigDecimal(datas.get(26).trim()), marryTime);
                    }
                    if (StringUtils.isNotBlank(datas.get(28))) {
                        marryTime = ComputeUtil.safeAdd(new BigDecimal(datas.get(28).trim()), marryTime);
                    }
                    if (StringUtils.isNotBlank(datas.get(30))) {
                        marryTime = ComputeUtil.safeAdd(new BigDecimal(datas.get(30).trim()), marryTime);
                    }
                    if (StringUtils.isNotBlank(datas.get(31))) {
                        marryTime = ComputeUtil.safeAdd(new BigDecimal(datas.get(31).trim()), marryTime);
                    }
                    importVO.setMarryTime(ComputeUtil.safeAdd(marryTime));


                    //算司龄
                    importVO.setYearSalary(this.calYearSalary(importVO.getFormalDate(), importVO.getRank()));

                    //基本工资+岗位工资+层级工资+交通+司龄
                    BigDecimal basicSalary = ComputeUtil.safeAdd(importVO.getBasicSalary(), importVO.getPostSalary(), importVO.getLevelSalary(), importVO.getSportSalary(), importVO.getYearSalary());

                    // 计算扣款
                    if (null != importVO.getSalaryTime() && importVO.getSalaryTime().compareTo(BigDecimal.ZERO) > 0){
                        //时薪
                        BigDecimal hourSalary = ComputeUtil.safeDiv(basicSalary, importVO.getSalaryTime()).setScale(2, BigDecimal.ROUND_HALF_UP);

                        //事假扣款计算：（基本工资+岗位工资+层级工资+交通+司龄）/计时工薪*事假工时
                        if (null != importVO.getThingTime() && importVO.getThingTime().compareTo(BigDecimal.ZERO) > 0){
                            importVO.setThingTimeDeduct(ComputeUtil.safeMultiply(hourSalary, importVO.getThingTime()).setScale(2, BigDecimal.ROUND_HALF_UP));
                        }

                        //旷工：（基本工资+岗位工资+层级工资+交通+司龄）/计时工薪 * 矿工工时*3
                        if (null != importVO.getAbsenteeTime() && importVO.getAbsenteeTime().compareTo(BigDecimal.ZERO) > 0){
                            importVO.setAbsenteeTimeDeduct(ComputeUtil.safeMultiply(ComputeUtil.safeMultiply(hourSalary, new BigDecimal(3)), importVO.getAbsenteeTime()).setScale(2, BigDecimal.ROUND_HALF_UP));
                        }

                        //单次未打卡：每次扣当天（基本工资+岗位工资+层级工资+交通补助+司龄）/计时工薪 * 3
                        if (null != importVO.getNoClockTime() && importVO.getNoClockTime().compareTo(BigDecimal.ZERO) > 0){
                            importVO.setNoClockTimeDeduct(ComputeUtil.safeMultiply(hourSalary, new BigDecimal(3)).setScale(2, BigDecimal.ROUND_HALF_UP));
                        }


                        //病假扣款计算：（岗位工资+层级工资+交通+司龄）/计时工薪*病假工时
                        if (null != importVO.getIllnessTime() && importVO.getIllnessTime().compareTo(BigDecimal.ZERO) > 0){
                            hourSalary = ComputeUtil.safeDiv(ComputeUtil.safeSub(basicSalary, importVO.getBasicSalary()), importVO.getSalaryTime()).setScale(2, BigDecimal.ROUND_HALF_UP);
                            importVO.setIllnessTimeDeduct(ComputeUtil.safeMultiply(hourSalary, importVO.getIllnessTime()).setScale(2, BigDecimal.ROUND_HALF_UP));
                        }


                        //婚假、产假、哺乳假、丧假：交通补助/计时工薪*对应假工时
                        if (null != importVO.getMarryTime() && importVO.getMarryTime().compareTo(BigDecimal.ZERO) > 0){
                            hourSalary = ComputeUtil.safeDiv(importVO.getSportSalary(), importVO.getSalaryTime()).setScale(2, BigDecimal.ROUND_HALF_UP);
                            importVO.setMarryTimeDeduct(ComputeUtil.safeMultiply(hourSalary, importVO.getMarryTime()).setScale(2, BigDecimal.ROUND_HALF_UP));
                        }

                        //todo:迟到？

                        //考勤扣款
                        importVO.setAttendanceDeduct(ComputeUtil.safeAdd(importVO.getThingTimeDeduct(), importVO.getIllnessTimeDeduct(), importVO.getMarryTimeDeduct(), importVO.getAbsenteeTimeDeduct(), importVO.getNoClockTimeDeduct()));

                    }
                    importVO.setSalaryMny(ComputeUtil.safeSub(ComputeUtil.safeAdd(importVO.getBasicSalary(), importVO.getPostSalary(), importVO.getLevelSalary(), importVO.getSportSalary(), importVO.getYearSalary(), importVO.getEducatedSalary()), importVO.getAttendanceDeduct()));
                    importVO.setActualSalaryMny(ComputeUtil.safeSub(importVO.getSalaryMny(), importVO.getEndownmentPersonMny(), importVO.getUnemployeePersonMny(), importVO.getBaseMedicalPersonMny()));


                    importVO.setId(IdWorker.getId());


                    if (StringUtils.isBlank(errorMessage)) {
                        successList.add(importVO);
                    } else {
                        importVO.setErrorMessage(String.valueOf(errorMessage));
                        errorList.add(importVO);
                    }
                }
            }
            JSONObject json = new JSONObject();
            json.put("successList", successList);
            json.put("errorList", errorList);
            return CommonResponse.success(json);
        }
    }

    //计算司龄
    private BigDecimal calYearSalary(Date formalDate, Integer rank) {
        //转正次月视为司龄满一年。
        //举例：2024年9月转正，初始司龄0
        //在2025年10月1日开始以后的查询，司龄为1
        //在2026年10月1日开始以后的查询，司龄为2
        /*
            司龄每年对应的补助
            高层、中层	基层
            1年250	1年200
            2年200	2年150
            3年150	3年100
            4年100	4年50
            5年100	5年50
            6年100	6年50
            7年100	7年50
            8年150	8年100
            9年200	9年150
            10年250	10年20
         */

        // rank 1：高 2：中 3：基
        BigDecimal yearSalary = BigDecimal.ZERO;
        int year = formalDate.getYear() + 1900;
        int month = formalDate.getMonth() + 1;
        if (month == 12){
            year+=1;
            month = 1;
        }else {
            month+=1;
        }
        Period period = Period.between(LocalDate.of(year, month, 1), LocalDate.now());
        int yearNum = period.getYears();
        if (yearNum < 1){
            return yearSalary;
        }

        switch (yearNum) {
            case 1:
                yearSalary = rank == 3 ? new BigDecimal(200) : new BigDecimal(250);
                break;
            case 2:
                yearSalary = rank == 3 ? new BigDecimal(150) : new BigDecimal(200);
                break;
            case 3:
                yearSalary = rank == 3 ? new BigDecimal(100) : new BigDecimal(150);
                break;
            case 4:
            case 5:
            case 6:
            case 7:
                yearSalary = rank == 3 ? new BigDecimal(50) : new BigDecimal(100);
                break;
            case 8:
                yearSalary = rank == 3 ? new BigDecimal(100) : new BigDecimal(150);
                break;
            case 9:
                yearSalary = rank == 3 ? new BigDecimal(150) : new BigDecimal(200);
                break;
            case 10:
                yearSalary = rank == 3 ? new BigDecimal(20) : new BigDecimal(250);
                break;
            default:
                yearSalary = rank == 3 ? new BigDecimal(20) : new BigDecimal(250);

        }
        return yearSalary;
    }

}
