/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bid.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.bid.bean.BusOpportunityEntity;
import com.ejianc.business.bid.bean.ProjectRegistrationAffirmEntity;
import com.ejianc.business.bid.bean.WinningRegistrationEntity;
import com.ejianc.business.bid.constants.BidCommonContants;
import com.ejianc.business.bid.service.IBusOpportunityService;
import com.ejianc.business.bid.service.IProjectRegistrationAffirmService;
import com.ejianc.business.bid.service.IWinningRegistrationService;
import com.ejianc.business.project.bean.ProjectRegisterEntity;
import com.ejianc.business.project.service.IProjectRegisterService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="projectRegistrationAffirm")
public class ProjectRegistrationAffirmBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProjectRegistrationAffirmService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IProjectRegisterService projectRegisterService;
    @Autowired
    private IBusOpportunityService busOpportunityService;
    @Autowired
    private IWinningRegistrationService winningRegistrationService;
    @Autowired
    private IOrgApi orgApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        ProjectRegistrationAffirmEntity e = (ProjectRegistrationAffirmEntity)((Object)this.service.selectById(billId));
        e.setCommitDate(new Date());
        e.setCommitUserCode(InvocationInfoProxy.getUsercode());
        e.setCommitUserCode(this.sessionManager.getUserContext().getUserName());
        this.service.saveOrUpdate((Object)e, false);
        return CommonResponse.success((String)"\u63d0\u4ea4\u5ba1\u6279\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.doBack(billId, state, billTypeCode);
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ProjectRegistrationAffirmEntity e = (ProjectRegistrationAffirmEntity)((Object)this.service.selectById(billId));
        if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(state)) {
            e.setCommitDate(new Date());
            e.setCommitUserCode(InvocationInfoProxy.getUsercode());
            e.setCommitUserCode(this.sessionManager.getUserContext().getUserName());
        }
        e.setEffectiveDate(new Date());
        this.saveProjectInfo(e);
        this.service.saveOrUpdate((Object)e, false);
        return CommonResponse.success((String)"\u7ec8\u5ba1\u5ba1\u6279\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    private void saveProjectInfo(ProjectRegistrationAffirmEntity e) {
        ProjectRegisterEntity project = new ProjectRegisterEntity();
        project.setRegistrationId(e.getRegistrationId());
        project.setOpportunityId(e.getOpportunityId());
        project.setOpportunityBillCode(e.getOpportunityBillCode());
        project.setAffirmId(e.getId());
        project.setAffirmBillCode(e.getBillCode());
        project.setName(e.getEngineeringName());
        project.setShortName(e.getEngineeringName());
        project.setCode(e.getEngineeringCode());
        project.setOrgId(e.getOrgId());
        project.setOrgName(e.getOrgName());
        project.setOrgCode(e.getOrgCode());
        project.setPlannedCommencementDate(e.getPlannedCommencementDate());
        project.setPlannedFinishDate(e.getPlannedFinishDate());
        project.setTaxLevyRate(e.getCollectionStandardName());
        project.setNoCostTicketReservedLevyRate(e.getNoCostTicketReservedLevyRate());
        project.setManagementFeeRate(e.getManagementFeeCollectionType());
        BusOpportunityEntity opportunityEntity = (BusOpportunityEntity)((Object)this.busOpportunityService.selectById(e.getOpportunityId()));
        opportunityEntity.setIsBidWinning(1);
        this.busOpportunityService.saveOrUpdate((Object)opportunityEntity);
        project.setFollowPersonId(opportunityEntity.getFollowPersonId());
        List<WinningRegistrationEntity> winList = this.winningRegistrationService.getByBusOpportunityId(e.getOpportunityId());
        if (CollectionUtils.isNotEmpty(winList)) {
            WinningRegistrationEntity win = winList.get(0);
            project.setBidMny(win.getBidMny());
            project.setBidDate(win.getBidDate());
            project.setPubUnit(win.getPubUnitId());
            project.setPubUnitName(win.getPubUnitName());
        }
        project.setCreateTime(new Date());
        project.setCreateUserCode(e.getCreateUserCode());
        project.setValidStatus("0");
        project.setStatus("2");
        project.setSyncEsFlag(BidCommonContants.INTEGER_NO);
        project.setDr(BidCommonContants.INTEGER_NO);
        project.setTenantId(e.getTenantId());
        OrgVO projectDepartment = this.generateProjectDepartment(project);
        if (null != projectDepartment) {
            CommonResponse resp = this.orgApi.saveOrgInfo(projectDepartment);
            if (!resp.isSuccess()) {
                this.logger.error("\u9879\u76ee\u786e\u8ba4\u5355id-{}\u751f\u6210\u9879\u76ee\u90e8\u4fe1\u606f\u5931\u8d25\uff0c\u4fdd\u5b58\u66f4\u65b0\u5bf9\u5e94\u9879\u76ee\u90e8\u4fe1\u606f\u3010{}\u3011\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", new Object[]{project.getAffirmId(), JSONObject.toJSONString((Object)projectDepartment), JSONObject.toJSONString((Object)resp)});
                throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u751f\u6210\u9879\u76ee\u90e8\u4fe1\u606f\u51fa\u9519: " + resp.getMsg());
            }
            projectDepartment = (OrgVO)resp.getData();
        }
        project.setProjectDepartmentId(projectDepartment.getId());
        project.setProjectDepartmentCode(projectDepartment.getCode());
        project.setProjectDepartmentName(projectDepartment.getName());
        this.projectRegisterService.saveOrUpdate((Object)project, false);
    }

    private OrgVO generateProjectDepartment(ProjectRegisterEntity project) {
        CommonResponse response = this.orgApi.getOneById(project.getOrgId());
        OrgVO parentOrg = null;
        if (!response.isSuccess() || null == response.getData()) {
            this.logger.error("\u9879\u76ee\u786e\u8ba4\u5355id-{}\u751f\u6210\u9879\u76ee\u90e8\u4fe1\u606f\u5931\u8d25\uff0c\u83b7\u53d6\u6240\u5c5e\u7ec4\u7ec7id-{}\u4fe1\u606f\u4e3a\u7a7a\u6216\u5931\u8d25, {}", new Object[]{project.getAffirmId(), project.getOrgId(), JSONObject.toJSONString((Object)response)});
            throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u67e5\u8be2\u9879\u76ee\u6240\u5c5e\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25!");
        }
        parentOrg = (OrgVO)response.getData();
        OrgVO projectDepartment = new OrgVO();
        projectDepartment.setId(Long.valueOf(IdWorker.getId()));
        projectDepartment.setParentId(project.getOrgId());
        projectDepartment.setTenantId(parentOrg.getTenantId());
        projectDepartment.setEnterpriseId(parentOrg.getEnterpriseId());
        projectDepartment.setIsParent(Boolean.valueOf(false));
        projectDepartment.setName(project.getName());
        projectDepartment.setShortName(project.getName());
        projectDepartment.setState(Integer.valueOf(1));
        projectDepartment.setOrgType(OrgVO.ORG_TYPE_DEPARTMENT);
        return projectDepartment;
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.doBack(billId, state, billTypeCode);
    }

    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> doBack(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u9879\u76ee\u767b\u8bb0\u786e\u8ba4\u5355\u636ebillId-{}, state-{}, billTypeCode-{}\u64a4\u56de\u4e8b\u4ef6\u5904\u7406", new Object[]{billId, state, billTypeCode});
        ProjectRegisterEntity project = this.projectRegisterService.getByAffirmId(billId);
        CommonResponse checkCommonResponse = this.billTypeApi.checkQuote("BT202410000054", project.getId());
        boolean success = checkCommonResponse.isSuccess();
        if (!success) {
            return CommonResponse.error((String)"\u786e\u8ba4\u5355\u5bf9\u5e94\u9879\u76ee\u7acb\u9879\u6863\u6848\u5df2\u53d1\u751f\u4e0b\u6e38\u4e1a\u52a1,\u4e0d\u80fd\u5f03\u5ba1\u548c\u64a4\u56de");
        }
        this.logger.info("\u6267\u884c\u9879\u76ee\u5220\u90e8\u9664\u64cd\u4f5c\uff0c\u5220\u9664\u9879\u76ee\u90e8[id-{}]", (Object)project.getProjectDepartmentId());
        CommonResponse delResp = this.orgApi.delByOrgId(project.getProjectDepartmentId());
        if (!delResp.isSuccess()) {
            this.logger.error("\u5220\u9664\u9879\u76ee\u786e\u8ba4\u5355[id-{}]\u5bf9\u5e94\u9879\u76ee\u90e8[id-{}]\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", new Object[]{billId, project.getProjectDepartmentId(), delResp.getMsg()});
            return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5220\u9664\u5bf9\u5e94\u9879\u76ee\u90e8\u4fe1\u606f\u5931\u8d25\u3002");
        }
        this.projectRegisterService.removeById(project.getId(), false);
        ProjectRegistrationAffirmEntity e = (ProjectRegistrationAffirmEntity)((Object)this.service.selectById(billId));
        e.setCommitDate(null);
        e.setCommitUserCode(null);
        e.setCommitUserCode(null);
        e.setEffectiveDate(null);
        this.service.saveOrUpdate((Object)e, false);
        return CommonResponse.success((String)"\u5ba1\u6279\u56de\u9000\u56de\u8c03\u67e5\u6210\u529f\uff01");
    }
}

